# encoding: utf-8

require 'rubygems'
require 'rspec'
require 'watir-webdriver'

require_relative '../../shared-test-ruby/WebDriverFactory'
require_relative '../lib/helper/QueryRDK'
require_relative '../lib/helper/HTTPartyWithBasicAuth'
require_relative '../lib/helper/HTTPartyWithAuthorization'
require_relative '../lib/helper/FetchResourceDirectory'
require_relative '../lib/helper/HTTPartyWithCookies'
require_relative '../lib/helper/JsonFieldDateValidator.rb'
require_relative '../lib/helper/JsonVerifier.rb'
require_relative '../lib/helper/VerifyJsonRuntimeValue.rb'

require_relative '../lib/module/vxapi_utility'
require_relative '../lib/module/json_utilities'

describe 'f137_resource_directory_fetch_spec.rb', acceptance: true do
  include VxAPIUtility
  include JsonUtilities

  before(:all) do
    #  'cdsworkproduct-retrieveWorkProducts',
    #  'cdsworkproduct-subscriptions',

    @fetch_keys = [
      'resource-directory',
      'resource-directory-html',
      'resource-directory-cors',
      'resource-directory-cors-html',
      'healthcheck-healthy',
      'healthcheck-detail-html',
      'healthcheck-checks',
      'healthcheck-detail',
      'healthcheck-noupdate',
      'authentication-authentication',
      'authentication-refreshToken',
      'authentication-destroySession',
      'authentication-list',
      'user-service-userinfo',
      'user-service-userlist',
      # 'synchronization-load',
      # 'synchronization-loadPrioritized',
      # 'synchronization-loadForced',
      'synchronization-clear',
      'synchronization-status',
      'synchronization-datastatus',
      'synchronization-syncStatusDetail',
      'synchronization-operationalstatus',
      'asu-evaluate',
      'patient-search-full-name',
      'patient-search-last5',
      'patient-search-pid',
      'search-global-search',
      'search-mvi-patient-sync',
      'search-default-search',
      'uid',
      'patient-record-search-text',
      'patient-record-search-suggest',
      'patient-record-search-detail-trend',
      'patient-record-search-detail-document',
      'patient-record-accession',
      'patient-record-patient',
      'patient-record-vital',
      'patient-record-problem',
      'patient-record-allergy',
      'patient-record-order',
      'patient-record-treatment',
      'patient-record-med',
      'patient-record-consult',
      'patient-record-procedure',
      'patient-record-obs',
      'patient-record-lab',
      'patient-record-image',
      'patient-record-surgery',
      'patient-record-document',
      'patient-record-mh',
      'patient-record-immunization',
      'patient-record-pov',
      'patient-record-skin',
      'patient-record-exam',
      'patient-record-cpt',
      'patient-record-education',
      'patient-record-factor',
      'patient-record-appointment',
      'patient-record-visit',
      'patient-record-ptf',
      'patient-record-rad',
      'patient-record-newsfeed',
      'patient-record-document-view',
      'patient-record-vlerdocument',
      'patient-record-parent-documents',
      # 'clinical-reminder-list',
      # 'clinical-reminder-detail',
      'patient-record-complexnote',
      'patient-record-cwad',
      'patient-record-labsbyorder',
      'patient-record-labsbypanel',
      'patient-record-labsbytype',
      'patient-record-searchbytype-lab',
      'patient-record-searchbytype-immunization',
      'patient-record-searchbytype-vital',
      'patient-record-timeline',
      'patient-entered-goals',
      'patient-self-assessment',
      'patient-service-connected-serviceConnected',
      'patient-service-connected-scButtonSelection',
      'healthsummaries-getSitesInfoFromPatientData',
      'healthsummaries-getReportContentByReportID',
      'global-timeline-getTimeline',
      'patientphoto-getPatientPhoto',
      'cds-advice-list',
      'cds-advice-detail',
      'cds-advice-read-status',
      # 'cds-advice-readStatus',
      # 'cdsworkproduct-createWorkProduct',
      # 'cdsworkproduct-retrieveWorkProduct',
      # 'cdsworkproduct-updateWorkProduct',
      # 'cdsworkproduct-deleteWorkProduct',
      # 'cdsworkproduct-Inbox',
      # 'cdsworkproduct-retrieveSubscriptions',
      # 'cdsworkproduct-updateSubscriptions',
      # 'cdsworkproduct-deleteSubscriptions',
      # 'patient-list-CDS-criteria-get',
      # 'patient-list-CDS-criteria-post',
      # 'patient-list-CDS-criteria-delete',
      # 'patient-list-CDS-definition-get',
      # 'patient-list-CDS-definition-post',
      # 'patient-list-CDS-definition-delete',
      # 'patient-list-CDS-definition-copy',
      # 'patient-list-CDS-patientlist-get',
      # 'patient-list-CDS-patientlist-post',
      # 'patient-list-CDS-patientlist-delete',
      # 'patient-list-CDS-patientlist-add',
      # 'patient-list-CDS-patientlist-remove',
      # 'patient-list-CDS-patientlist-copy',
      # 'cdsschedule-CDS-schedule-get',
      # 'cdsschedule-CDS-schedule-post',
      # 'cdsschedule-CDS-schedule-put',
      # 'cdsschedule-CDS-schedule-delete',
      # 'cdsexecute-CDS-execute-get',
      # 'cdsexecute-CDS-execute-post',
      # 'cdsexecute-CDS-execute-put',
      # 'cdsexecute-CDS-execute-delete',
      # 'cdsengine-CDS-engine-get',
      # 'cdsengine-CDS-engine-post',
      # 'cdsengine-CDS-engine-put',
      # 'cdsengine-CDS-engine-delete',
      # 'cdsintent-CDS-intent-get',
      # 'cdsintent-CDS-intent-post',
      # 'cdsintent-CDS-intent-put',
      # 'cdsintent-CDS-intent-delete',
      'immunization-crud-immunizationTypes',
      'immunization-crud-lotNumbers',
      'immunization-crud-anatomicalLocations',
      'immunization-crud-manufacturers',
      'immunization-crud-informationSources',
      'immunization-crud-routeOfAdministration',
      'locations-wards',
      'locations-clinics',
      'locations-wards-search',
      'locations-clinics-search',
      'order-detail',
      'problems-getProblems',
      # 'problems-AddProblem',
      # 'problems-UpdateProblem',
      'visits-providers',
      'visits-locations',
      'visits-appointments',
      'visits-admissions',
      'vitals-closest-reading',
      'vitals-qualifier-information',
      'vitals-all-vitals',
      'vitals-vitalsRule',
      'tasks-tasks',
      'tasks-tasksbypatient',
      'tasks-changestate',
      'tasks-startprocess',
      'notes-getNotesFromEcrud',
      'notes-titles-getUserRecentTitles',
      'user-defined-screens',
      'write-user-defined-screens',
      'write-user-defined-screens-copy',
      'user-defined-filter',
      'user-defined-filter-all',
      'user-defined-sort',
      'user-defined-stack',
      'user-defined-stack-all',
      'toc-toc',
      # 'allergy-op-data-search',
      # 'allergy-op-data-symptoms',
      # 'med-op-data-search',
      # 'med-op-data-schedule',
      # 'med-op-data-defaults',
      # 'med-op-data-searchlist',
      # 'med-op-data-dialogformat',
      # 'med-op-data-discontinuereason',
      # 'med-op-data-orderpresets',
      # 'med-op-data-daytoquantity',
      # 'med-op-data-dayssupply',
      # 'write-back-outpatient-med-save',
      # 'write-back-outpatient-med-sign',
      # 'write-back-outpatient-med-formulary',
      # 'write-back-save-allergy',
      # 'write-back-allergy-error-save',
      # 'write-back-allergy-error-permission',
      # 'write-back-save-vitals',
      # 'write-back-vitals-error',
      # 'write-back-save-nonVA-med',
      # 'write-back-save-nonVA-med-discontinue',
      'patient-demographics',
      'adversereaction-adversereactions',
      'allergyIntolerance-allergyintolerances',
      'vitals-observation',
      'healthFactors-healthFactors',
      'educations-educations',
      'diagnosticreport-diagnosticreport',
      'order-order',
      'condition-getProblems',
      'immunization',
      'composition',
      'referralrequest-getReferralRequest',
      'medicationdispense-getMedicationDispense',
      'medicationadministration-medicationAdministration',
      'medicationdstatement-getMedicationStatement',
      'medicationprescription-medicationprescription',
      'authorize-authorize',
      'operational-data-type-vital',
      'operational-data-type-laboratory',
      'operational-data-type-medication',
      'vergencevaultproxy-geticnforccow',
      'vergencevaultproxy-getSiteInfo',
      # 'metrics-metricSearch',
      # 'metrics-getConfig',
      # 'metrics-getDashboard',
      # 'metrics-getUserDashboards',
      # 'metrics-metricDefinitions',
      # 'metrics-createMetricDefinitions',
      # 'metrics-deleteMetricDefinition',
      # 'metrics-metricGroups',
      # 'metrics-createMetricGroup',
      # 'metrics-updateMetricGroup',
      # 'metrics-deleteMetricGroup',
      # 'metrics-roles',
      # 'metrics-updateRoles',
      # 'metrics-userRoles',
      # 'metrics-createDashboard',
      # 'metrics-deleteDashboard',
      # 'metrics-updateDashboard',
      'roles-edit',
      'roles-getUserRoles',
      'roles-list',
      # 'vista-js-test',
      'visit-service-category',
      'encounter-encounterInfo',
      'diagnostic-order-diagnostic-order',
      'cds-work-product-cds-work-product-create',
      'cds-work-product-cds-work-product-retrieve',
      'cds-work-product-cds-work-product-update',
      'cds-work-product-cds-work-product-delete',
      'cds-work-product-cds-work-product-subscription-retrieve',
      'cds-work-product-cds-work-product-subscription-update',
      'cds-work-product-cds-work-product-subscription-delete',
      'cds-work-product-inbox',
      'cds-patient-list-cds-criteria-get',
      'cds-patient-list-cds-criteria-post',
      'cds-patient-list-cds-criteria-delete',
      'cds-patient-list-cds-definition-get',
      'cds-patient-list-cds-definition-post',
      'cds-patient-list-cds-definition-delete',
      'cds-patient-list-cds-definition-copy',
      'cds-patient-list-cds-patientlist-get',
      'cds-patient-list-cds-patientlist-post',
      'cds-patient-list-cds-patientlist-delete',
      'cds-patient-list-cds-patientlist-add',
      'cds-patient-list-cds-patientlist-remove',
      'cds-patient-list-cds-patientlist-status',
      'cds-patient-list-cds-patientlist-copy',
      'cds-schedule-cds-schedule-get',
      'cds-schedule-cds-schedule-post',
      'cds-schedule-cds-schedule-put',
      'cds-schedule-cds-schedule-delete',
      'cds-execute-cds-execute-get',
      'cds-execute-cds-execute-post',
      'cds-execute-cds-execute-put',
      'cds-execute-cds-execute-delete',
      'cds-engine-cds-engine-get',
      'cds-engine-cds-engine-post',
      'cds-engine-cds-engine-put',
      'cds-engine-cds-engine-delete',
      'cds-intent-cds-intent-get',
      'cds-intent-cds-intent-post',
      'cds-intent-cds-intent-put',
      'cds-intent-cds-intent-delete',
      # 'cds-metrics-metricSearch',
      # 'cds-metrics-getDashboard',
      # 'cds-metrics-getUserDashboards',
      # 'cds-metrics-metricDefinitions',
      # 'cds-metrics-createMetricDefinitions',
      # 'cds-metrics-deleteMetricDefinition',
      # 'cds-metrics-metricGroups',
      # 'cds-metrics-createMetricGroup',
      # 'cds-metrics-updateMetricGroup',
      # 'cds-metrics-deleteMetricGroup',
      # 'cds-metrics-roles',
      # 'cds-metrics-updateRoles',
      # 'cds-metrics-userRoles',
      # 'cds-metrics-createDashboard',
      # 'cds-metrics-deleteDashboard',
      # 'cds-metrics-updateDashboard',
      'cds-metrics-cds-metric-search',
      'cds-metrics-cds-dashboard-get',
      'cds-metrics-cds-user-dashboards-get',
      'cds-metrics-cds-metric-definitions-get',
      'cds-metrics-cds-metric-definitions-post',
      'cds-metrics-cds-metric-definitions-delete',
      'cds-metrics-cds-metric-groups-get',
      'cds-metrics-cds-metric-groups-post',
      'cds-metrics-cds-metric-groups-put',
      'cds-metrics-cds-metric-groups-delete',
      # 'cds-metrics-cds-roles-get',
      # 'cds-metrics-cds-roles-put',
      # 'cds-metrics-cds-user-roles-get',
      # 'cds-metrics-cds-user-roles-put',
      'cds-metrics-cds-dashboard-post',
      'cds-metrics-cds-dashboard-delete',
      'cds-metrics-cds-dashboard-put',
      'locations-facility-monikers',
      'procedure-procedure',
      # 'orders-detail'
      'synchronization-load',
      'tasks-taskstatuslist',
      'tasks-processstatuslist',
      'tasks-getprocessdefinitions',
      'tasks-getactivitydefinitionsbyquery',
      'communicationrequest-add',
      'communicationrequest-get',
      'communicationrequest-delete',
      'communicationrequest-get-all',
      'communicationrequest-delete-all',
      'teams-list',
      'teams-deleteByTeamId',
      'teams-getByTeamId',
      'teams-byICN',
      'teams-byUser',
      'teams-add',
      # 'teams-teams-create-jds-storage',
      # 'teams-teams-delete-jds-storage',
      # 'teams-add-test-data'
      'patient-record-notes',
      'tasks-abortprocess',
      'teams-addFacilities'
    ]

    @picklist_keys = [
      'resource-directory',
      'resource-directory-html',
      'resource-directory-cors',
      'resource-directory-cors-html',
      'healthcheck-healthy',
      'healthcheck-detail-html',
      'healthcheck-checks',
      'healthcheck-detail',
      'healthcheck-noupdate',
      'write-pick-list',
      'write-pick-list-allergies-match',
      'write-pick-list-encounters-diagnosis-lexicon-lookup',
      'write-pick-list-encounters-procedures-lexicon-lookup',
      'write-pick-list-lab-time-valid-immediate-collect-time',
      'write-pick-list-lab-times-available',
      'write-pick-list-medication-list',
      'write-pick-list-medication-orders-calc-max-refills',
      'write-pick-list-medication-orders-default-days',
      'write-pick-list-medication-orders-quantity-for-days-supply',
      'write-pick-list-problems-lexicon-lookup',
      'write-pick-list-radiology-dialog-default',
      'write-pick-list-allergies-symptoms',
      'write-pick-list-allergies-symptoms-top-ten',
      'write-pick-list-allergies-symptoms-all-with-top-ten',
      'write-pick-list-encounters-diagnosis-codes-for-clinic',
      'write-pick-list-encounters-procedure-types',
      'write-pick-list-encounters-procedures-cpt-modifier',
      'write-pick-list-encounters-visit-categories',
      'write-pick-list-encounters-visit-disabilities',
      'write-pick-list-encounters-visit-service-connected',
      'write-pick-list-immunization-admin-route',
      'write-pick-list-immunization-admin-site',
      'write-pick-list-immunization-data',
      'write-pick-list-immunization-info-source',
      'write-pick-list-immunization-lot',
      'write-pick-list-immunization-manufacturer',
      'write-pick-list-immunization-types',
      'write-pick-list-immunization-vaccine-info-statement',
      'write-pick-list-lab-all-samples',
      'write-pick-list-lab-collect-times',
      'write-pick-list-lab-order-dialog-def',
      'write-pick-list-lab-order-max-days-continuous',
      'write-pick-list-lab-order-orderable-items',
      'write-pick-list-lab-order-specimens',
      'write-pick-list-lab-sample-specimen-urgency',
      'write-pick-list-medication-defaults',
      'write-pick-list-medication-index',
      'write-pick-list-medication-order-defaults',
      'write-pick-list-medication-orders',
      'write-pick-list-medication-orders-dispense-drug-message',
      'write-pick-list-medication-schedules',
      'write-pick-list-new-persons',
      'write-pick-list-pki-enabled',
      'write-pick-list-printer-devices',
      'write-pick-list-progress-notes-titles-flags',
      'write-pick-list-progress-notes-titles',
      'write-pick-list-radiology-imaging-types',
      'write-pick-list-vitals'
    ]

    @writeback_keys = [
      'resource-directory',
      'resource-directory-html',
      'resource-directory-cors',
      'resource-directory-cors-html',
      'healthcheck-healthy',
      'healthcheck-detail-html',
      'healthcheck-checks',
      'healthcheck-detail',
      'healthcheck-noupdate',
      'allergies-add',
      # 'allergies-update',
      'encounters-add',
      'encounters-update',
      'immunizations-add',
      'orders-print-print',
      'orders-create',
      'orders-update',
      'orders-edit',
      'orders-discontinue',
      'notes-add',
      'notes-update',
      'notes-unsigned-delete',
      'notes-unsigned-read',
      'problems-add',
      'problems-update',
      'vitals-add',
      'lab-support-data',
      # 'write-back-sign-note-sign',
      'write-back-sign-order-sign',
      # 'vitals-update'
      'allergies-eie',
      'orders-detail',
      'notes-sign',
      'vitals-update',
      'orders-sign-details',
      'orders-sign',
      'orders-discontinue-details'
    ]
  end

  context '@F137 RDK Resource Directory List' do
    it 'Scenario: Fetch API directory entry exists' do
      verify_list(DefaultLogin.rdk_fetch_url,
                  '/resource/resourcedirectory',
                  @fetch_keys)
    end

    it 'Scenario: Picklist API directory entry exists' do
      verify_list(DefaultLogin.rdk_picklist_url,
                  '/resource/write-pick-list/resourcedirectory',
                  @picklist_keys)
    end

    it 'Scenario: Writeback API directory entry exists' do
      verify_list(DefaultLogin.rdk_writeback_url,
                  '/resource/write-health-data/resourcedirectory',
                  @writeback_keys)
    end
  end

  def verify_list(login_url, resource_path, key_list)
    urls = resource_directory_list(login_url, resource_path)
    puts "expected_size=[#{key_list.size}] actual_size=[#{urls.size}]"
    urls.each do |k|
      unless key_list.include?(k[0])
        puts "Note: key=[#{k[0]}] is new"
      end
    end
    key_list.each do |k|
      unless urls.include?(k)
        puts "Note: key=[#{k}] has been removed from RDK"
      end
    end
    key_list.each do |k|
      expect(urls.key?(k)).to eq(true),
                              "Key=[#{k}] not found in list of resource " \
                              "[#{resource_path}]"
      expect(urls[k].strip.size).to be > (0) if urls.key?(k)
    end
  end

  def resource_directory_list(login_url, resource_dir_path)
    path = String.new(login_url)
    path.concat(resource_dir_path)
    # puts "path=[#{path}]"
    response = HTTPartyWithBasicAuth.get_with_authorization(path)
    json = JSON.parse(response.body)
    urls = {}
    links = json['data']['link']
    links.each do |paths|
      urls[paths['title']] = paths['href']
    end

    # puts '--- Resource Directory List --------------------------------------'
    # urls.each do |k, _v|
    #   # puts "k=[#{k}]  v=[#{_v}]"
    #   puts "    \'#{k}\',"
    #end
    urls
  end
end
