package org.opencds.config.api.model.impl;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.opencds.config.api.model.EntityIdentifier;
import org.opencds.config.api.model.KMId;

public class KMIdImpl implements KMId {

    private String scopingEntityId;
    private String businessId;
    private String version;

    public static KMIdImpl create(String scopingEntityId, String businessId, String version) {
        KMIdImpl ssid = new KMIdImpl();
        ssid.scopingEntityId = scopingEntityId;
        ssid.businessId = businessId;
        ssid.version = version;
        return ssid;
    }
    
    public static KMIdImpl create(KMId kmid) {
        if (kmid == null) {
            return null;
        }
        if (kmid instanceof KMIdImpl) {
            return KMIdImpl.class.cast(kmid);
        }
        return create(kmid.getScopingEntityId(), kmid.getBusinessId(), kmid.getVersion());
    }
    
    public static KMId create(EntityIdentifier ei) {
        return create(ei.getScopingEntityId(), ei.getBusinessId(), ei.getVersion());
    }

    @Override
    public String getScopingEntityId() {
        return scopingEntityId;
    }

    @Override
    public String getBusinessId() {
        return businessId;
    }

    @Override
    public String getVersion() {
        return version;
    }
    
    @Override
    public String toString() {
        return "KMIdImpl [scopingEntityId= " + scopingEntityId + ", businessId= " + businessId + ", version= " + version
                + "]";
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(1579, 2731)
        .append(scopingEntityId)
        .append(businessId)
        .append(version)
        .toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) { return false; }
        if (obj == this) { return true; }
        if (obj.getClass() != getClass()) {
          return false;
        }
        KMIdImpl rhs = (KMIdImpl) obj;
        return new EqualsBuilder()
        .append(scopingEntityId, rhs.scopingEntityId)
        .append(businessId, rhs.businessId)
        .append(version, rhs.version)
        .isEquals();
    }

}
