package us.vistacore;

import static org.junit.Assert.*;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.BundleEntry;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.parser.IParser;

public class RulesTest {
	private static Map<String, Object> namedObjects;
	private static KieServices ks;
	private static KieContainer kContainer;
	private static KieSession kSession;
	private static IParser jsonParser;

	@BeforeClass
	public static void oneTimeSetUp() {
		namedObjects = new HashMap<String, Object>();
		ks = KieServices.Factory.get();
		kContainer = ks.getKieClasspathContainer();
		kSession = kContainer.newKieSession("ksession-rules");
		kSession.setGlobal("namedObjects", namedObjects);
		FhirContext ctx = FhirContext.forDstu2();
		jsonParser = ctx.newJsonParser();
	}

	@Test
	public void testFobt() {
		try {
			namedObjects.clear();
			String diagnosticReport = getFhirString("diagnostic-report.json");

			Bundle obsBundle = jsonParser.parseBundle(diagnosticReport);
			List<BundleEntry> bundles = obsBundle.getEntries();
			for (Iterator iterator = bundles.iterator(); iterator.hasNext();) {
				BundleEntry bundleEntry = (BundleEntry) iterator.next();

				kSession.insert(bundleEntry.getResource());
				List<? extends IResource> contaned = bundleEntry.getResource().getContained().getContainedResources();
				for (Iterator iterator2 = contaned.iterator(); iterator2.hasNext();) {
					IResource iResource = (IResource) iterator2.next();
					kSession.insert(iResource);
				}
			}
			kSession.fireAllRules();
			assertTrue(namedObjects.get("communicationRequest") != null);
		} catch (Throwable t) {
			t.printStackTrace();
		}
	}
	
	@Test
	public void testHypertension() {
		try {
			namedObjects.clear();
			String diagnosticReport = getFhirString("vitals.json");

			Bundle obsBundle = jsonParser.parseBundle(diagnosticReport);
			List<BundleEntry> bundles = obsBundle.getEntries();
			for (Iterator iterator = bundles.iterator(); iterator.hasNext();) {
				BundleEntry bundleEntry = (BundleEntry) iterator.next();

				kSession.insert(bundleEntry.getResource());
				List<? extends IResource> contaned = bundleEntry.getResource().getContained().getContainedResources();
				for (Iterator iterator2 = contaned.iterator(); iterator2.hasNext();) {
					IResource iResource = (IResource) iterator2.next();
					kSession.insert(iResource);
				}
			}
			kSession.fireAllRules();
			assertTrue(namedObjects.get("communicationRequest") != null);
		} catch (Throwable t) {
			t.printStackTrace();
		}

	}

	private static String getFhirString(String file) {
		StringBuilder tmp = new StringBuilder();
		try (BufferedReader br = new BufferedReader(new FileReader(
				"/Users/tsefer/Projects/vistacore/opencds/product/production/opencds/src/cds-rules-test/src/main/resources/fhir-data/"
						+ file))) {
			String sCurrentLine;
			while ((sCurrentLine = br.readLine()) != null) {
				tmp.append(sCurrentLine);
				// System.out.println(sCurrentLine);
			}
		} catch (IOException e) {
			// System.out.print();
			e.printStackTrace();
		}
		return tmp.toString();
	}

}