package us.vistacore;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.kie.api.KieServices;

import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.BundleEntry;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.parser.IParser;

/**
 * This is a sample class to launch a rule.
 */
public class DroolsTest {

    public static final void main(String[] args) {
        try {
            // load up the knowledge base
            Map<String, Object> namedObjects = new HashMap<String, Object>();
           
            KieServices ks = KieServices.Factory.get();
    	    KieContainer kContainer = ks.getKieClasspathContainer();
        	KieSession kSession = kContainer.newKieSession("ksession-rules");
        	
        	kSession.setGlobal( "namedObjects", namedObjects );
        	//kSession2.setGlobal( "namedObjects", namedObjects );
            FhirContext ctx =  FhirContext.forDstu2();
            IParser jsonParser = ctx.newJsonParser();
            //String diagnosticReport = getFhirString("diagnostic-report.json");
            String vitals = getFhirString("vitals.json");
            
            //Bundle  obsBundle = jsonParser.parseBundle(diagnosticReport);
            Bundle  obsBundle = jsonParser.parseBundle(vitals);
            List<BundleEntry> bundles = obsBundle.getEntries();
            for (Iterator iterator = bundles.iterator(); iterator.hasNext();) {
                BundleEntry bundleEntry = (BundleEntry) iterator.next();
              
                kSession.insert(bundleEntry.getResource());
                List<? extends IResource> contaned = bundleEntry.getResource().getContained().getContainedResources();
                for (Iterator iterator2 = contaned.iterator(); iterator2.hasNext();) {
					IResource iResource = (IResource) iterator2.next();
					kSession.insert(iResource);
				}
            }
            kSession.fireAllRules();
            //kSession2.fireAllRules();
           System.out.println( kSession.getGlobal("namedObjects"));
        } catch (Throwable t) {
            t.printStackTrace();
        }
        
    }
    private static String getFhirString(String file){
        StringBuilder tmp = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader("/Users/tsefer/Projects/vistacore/opencds/product/production/opencds/src/cds-rules-test/src/main/resources/fhir-data/" + file))){	            
        	String sCurrentLine;
            while ((sCurrentLine = br.readLine()) != null) {
                tmp.append(sCurrentLine);
                //System.out.println(sCurrentLine);
            }
        } catch (IOException e) {
            //System.out.print();
            e.printStackTrace();
        } 
        return tmp.toString();
    }

}
