/*******************************************************************************
 *
 *   Copyright 2015 Cognitive Medical Systems
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 *     
 *******************************************************************************/

package com.cognitive.cds.services.cdsexecution.workproduct.producers;

import ca.uhn.fhir.model.api.IResource;

import com.cognitive.cds.invocation.model.Context;
import com.cognitive.cds.invocation.model.Result;
import com.cognitive.cds.invocation.workproduct.model.WorkProduct;
import com.cognitive.cds.services.cdsresults.model.CDSResult;

/**
 * Create a Work Product from Fhir result and context data.
 * 
 */
public interface FHIRWorkProductProducerIFace {

    /**
     * 
     * @param result
     * @param wp
     * @param fhirResource
     * @param ctx
     * @param idInBundle
     * @return
     */
    public boolean handleWorkProduct(Result result, WorkProduct wp, IResource fhirResource, Context ctx, int idInBundle);

    /**
     *
     * @param result
     * @param fhirResource
     * @param ctx
     * @param idInBundle
     * @return
     */
    public CDSResult createCDSResult(Result result, IResource fhirResource, Context ctx, int idInBundle);
}
