/**
 * *****************************************************************************
 *
 * Copyright 2015 Cognitive Medical Systems
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 *
 ******************************************************************************
 */
package com.cognitive.cds.invocation.workproduct.model;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author jeremy
 */
public class WorkProductSubscriptionTest {
    
    private WorkProductSubscription createWPS() throws ParseException
    {
        WorkProductSubscription wps = new WorkProductSubscription();
                
        wps.setPriority("URG"); //priority >= 61
        
        List<Integer> specialty = new ArrayList<>();
        specialty.add(408439002); //ALLERGY
        specialty.add(408478003); //CRITICAL_CARE
        specialty.add(394582007); //DERMATOLOGY
        
        wps.setSpecialty(specialty);
        
        List<String> type = new ArrayList<>();
        type.add("P");
        wps.setType(type);
        
        wps.setUser("1100032");
                   
        return wps;
        
    }
}
