/**
 * *****************************************************************************
 *
 * Copyright 2015 Cognitive Medical Systems
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 *
 ******************************************************************************
 */
package com.cognitive.cds.invocation.workproduct.model;

import com.cognitive.cds.invocation.model.Base;

/**
 * Generalized Payload model for work product data.
 * 
 * @author jgoodnough
 *
 */
public class Payload extends Base {

	private String type;
	private Object data;
	
	public Payload()
	{
		
	}
	
	/**
	 * Simple constructor
	 * @param type
	 * @param data
	 */
	public Payload(String type, Object data)
	{
		this.type=type;
		this.data = data;
	}
	
	/**
	 * Get the Type of payload - This is a coded string (e.g. CDSAdvise, or the Fire resource name)
	 * @return
	 */
	public String getType() {
		return type;
	}
	public void setType(String type) {
		this.type = type;
	}
	
	/**
	 * Get the actual data associated
	 * @return
	 */
	public Object getData() {
		return data;
	}
	public void setData(Object data) {
		this.data = data;
	}
	
	
}

