/*******************************************************************************
 *
 *   Copyright 2014 Cognitive Medical Systems
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 *     
 *******************************************************************************/
package com.cognitive.cds.invocation.model;



/**
 * Place Holder for Subject (e.g. Patient) - Should in the future be standards based
 * @author Jerry Goodnough
 * @version 1.0
 * @created 11-Dec-2014 9:10:43 AM
 */
public class Subject extends Entity {

	public Subject(){
		entityType ="Subject";
	}
	
	/**
	 * Simple parameter based constructor
	 * @param id The Id of the subject
	 */
	public Subject(String id){
		this.id=id;
		this.name="";
		entityType ="Subject";
	}
	/**
	 * Simple parameter based constructor
	 * @param name The subject name 
	 * @param id The Id of the subject
	 */
	public Subject(String name, String id){
		this.id=id;
		this.name=name;
		entityType ="Subject";
	}

	/**
	 * Simple parameter based constructor
	 * @param name The subject name 
	 * @param id The Id of the subject
	 * @param type The type of Subject 
	 */
	public Subject(String name, String id, String type){
		this.id=id;
		this.name=name;
		this.type=type;
		entityType ="Subject";
	}

	/**
	 * Simple parameter based constructor
	 * @param name The subject name 
	 * @param id The Id of the subject
	 * @param type The type of Subject
	 * @param codeSystem the Code System used by the Subject id 
	 */
	public Subject(String name, String id, String type, String codeSystem){
		this.id=id;
		this.name=name;
		this.type=type;
		this.codeSystem=codeSystem;
		entityType ="Subject";
	}
	public void finalize() throws Throwable {
		super.finalize();
	}

//	public String getEntityType(){
//		return entityType;
//	}

}