package com.cognitive.cds.invocation.exceptions;
/********************************************************************************
*
*   Copyright 2015 Cognitive Medical Systems
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
* 
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
*
*     
********************************************************************************/


/**
 * Exception used to indicate an error during data retrieval
 * 
 * @author jgoodnough
 *
 */
public class DataRetrievalException extends Exception {

    private String query;

    public DataRetrievalException(String msg) {
        super(msg);
        this.setQuery(query);
    }

    public DataRetrievalException(String msg, String query, Exception e) {
        super(msg, e);
        this.setQuery(query);
    }

    public DataRetrievalException(String msg, Exception e) {
        super(msg, e);
    }

    public DataRetrievalException(String msg, String query) {
        super(msg);
        this.setQuery(query);
    }

    /**
     * @return the query
     */
    public String getQuery() {
        return query;
    }

    /**
     * @param query
     *            the query to set
     */
    public void setQuery(String query) {
        this.query = query;
    }

}
