/*******************************************************************************
 *  Copyright 2015 Cognitive Medical Systems
 *  
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *  
 *       http://www.apache.org/licenses/LICENSE-2.0
 *  
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *******************************************************************************/
package com.cognitivemedicine.metricsdashboard.shared;

import java.util.Comparator;

import com.cognitivemedicine.metricsservice.model.Datapoint;

public class DateLongComparator implements Comparator<Datapoint> {

  @Override
  public int compare(Datapoint o1, Datapoint o2) {
    if (o1.getDatetime() > o2.getDatetime()) {
      return 1;
    } else if (o1.getDatetime() < o2.getDatetime()) {
      return -1;
    } else {
      return 0;
    }
  }

}
