/*******************************************************************************
 *  Copyright 2015 Cognitive Medical Systems
 *  
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *  
 *       http://www.apache.org/licenses/LICENSE-2.0
 *  
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *******************************************************************************/
package com.cognitivemedicine.metricsdashboard.client.charts.types;

import com.cognitivemedicine.metricsdashboard.client.charts.AbstractChartPanel;
import com.cognitivemedicine.metricsdashboard.client.charts.GrainMatrix;
import com.googlecode.gwt.charts.client.corechart.ColumnChart;
import com.googlecode.gwt.charts.client.corechart.ColumnChartOptions;

/**
 * A bar chart implementation
 * 
 * @author sschechter
 * 
 */
public class ColumnChartPanel extends AbstractChartPanel<ColumnChart, ColumnChartOptions> {

  public ColumnChartPanel(ColumnChart chart, ColumnChartOptions options) {
    super(chart, options);
  }

  @Override
  public void draw(GrainMatrix grainMatrix) {
    super.populateDataTable(grainMatrix);
    chart.draw(dataTable, options);
  }
}
