define([
    'backbone',
    'handlebars',
    'app/applets/problems/modalView/modalView',
    'app/applets/problems/modalView/modalHeaderView',
    'app/applets/problems/modalView/modalFooterView',
    'app/applets/problems/util',
    'hbs!app/applets/problems/list/tooltip',
    "app/applets/problems/gistView",
    'app/applets/problems/writeback/AddEditProblems',
    'app/applets/problems/writeback/ProblemSearch',
    'app/applets/problems/writeback/RequestFreeText',
    'app/applets/visit/writeback/addselectVisit',
    'app/applets/problems/writeback/formModel',
    'app/applets/problems/writeback/workflowUtils'
], function(Backbone, Handlebars, ModalView, modalHeader, modalFooter, Util, tooltip, GistView, AddEditProblemsView, ProblemSearchView, RequestFreeTextView, addselectEncounter, FormModel, WorkflowUtils) {
    'use strict';
    var problemChannel = ADK.Messaging.getChannel('problems');
    var allEncounterDateArray = [];
    //Data Grid Columns
    var summaryColumns = [{
        name: 'problemText',
        label: 'Description',
        flexWidth: 'flex-width-4',
        cell: Backgrid.StringCell.extend({
            className: 'string-cell flex-width-4'
        }),
        hoverTip: 'conditions_description'
    }, {
        name: 'acuityName',
        label: 'Acuity',
        cell: 'handlebars',
        template: Handlebars.compile('<span class="acuityType">{{acuityName}}</span>'),
        hoverTip: 'conditions_acuity'
    }, {
        name: 'statusName',
        label: 'Status',
        cell: 'string',
        hoverTip: 'conditions_status'
    }, ];

    var fullScreenColumns =
        summaryColumns.concat([{
            name: 'onsetFormatted',
            label: 'Onset Date',
            flexWidth: 'flex-width-2',
            cell: Backgrid.StringCell.extend({
                className: 'string-cell flex-width-2'
            }),
            sortValue: function(model, sortKey) {
                return model.get("onset");
            },
            hoverTip: 'conditions_onsetdate'
        }, {
            name: 'updatedFormatted',
            label: 'Last Updated',
            flexWidth: 'flex-width-2',
            cell: Backgrid.StringCell.extend({
                className: 'string-cell flex-width-2'
            }),
            sortValue: function(model, sortKey) {
                return model.get("updated");
            },
            hoverTip: 'conditions_lastupdated'
        }, {
            name: 'providerDisplayName',
            label: 'Provider',
            flexWidth: 'flex-width-2',
            cell: Backgrid.StringCell.extend({
                className: 'string-cell flex-width-2'
            }),
            hoverTip: 'conditions_provider'
        }, {
            name: 'facilityMoniker',
            label: 'Facility',
            cell: 'string',
            hoverTip: 'conditions_facility'
        }, {
            name: 'comments',
            label: '',
            flexWidth: 'flex-width-0_5 ',
            sortable: false,
            srOnlyLabel: 'Comments',
            cell: Backgrid.HandlebarsCell.extend ({
                className: 'handlebars-cell flex-width-0_5'
            }),
            template: Handlebars.compile([
                '{{#if commentBubble}}',
                '<i class="fa fa-comment"></i>',
                '<span class="sr-only">Comments</span>',
                '{{else}}',
                '<i class="fa fa-transparent-comment"></i>',
                '<span class="sr-only">No Comments</span>',
                '{{/if}}'
            ].join("\n"))
        }]);

    fullScreenColumns.splice(1, 0, {
        name: 'standardizedDescription',
        label: 'Standardized Description',
        flexWidth: 'flex-width-4',
        cell: Backgrid.StringCell.extend({
            className: 'string-cell flex-width-4'
        }),
        hoverTip: 'conditions_standardizeddescription'
    });

    var viewParseModel = {
        parse: function(response) {

            response = Util.getStandardizedDescription(response);
            response = Util.getStatusName(response);
            response = Util.getServiceConnected(response);
            response = Util.getProblemText(response);
            response = Util.getICDCode(response);
            response = Util.getAcuityName(response);
            response = Util.getFacilityColor(response);
            response = Util.getOnsetFormatted(response);
            response = Util.getEnteredFormatted(response);
            response = Util.getUpdatedFormatted(response);
            response = Util.getCommentBubble(response);
            response = Util.getICDName(response);
            response = Util.getTimeSince(response);
            response = Util.getStatusName(response);

            return response;
        }
    };
    //Collection fetchOptions
    var fetchOptions = {
        resourceTitle: 'patient-record-problem',
        pageable: false,
        criteria: {
            filter: 'ne(removed, true)'
        },
        cache: true,
        viewModel: viewParseModel
    };

    var AppletLayoutView = ADK.Applets.BaseGridApplet.extend({
        className: '',
        initialize: function(options) {
            this._super = ADK.Applets.BaseGridApplet.prototype;
            var dataGridOptions = {};
            dataGridOptions.filterEnabled = true;
            dataGridOptions.enableModal = true;
            dataGridOptions.tblRowSelector = '#data-grid-' + this.options.appletConfig.instanceId + ' tbody tr';
            //dataGridOptions.filterFields = ['summary']; //Defaults to all columns
            if (this.columnsViewType === "expanded") {
                dataGridOptions.columns = fullScreenColumns;
            } else if (this.columnsViewType === "summary") {
                dataGridOptions.columns = summaryColumns;
            } else {
                dataGridOptions.summaryColumns = summaryColumns;
                dataGridOptions.fullScreenColumns = fullScreenColumns;
            }
            this.fetchOptions = fetchOptions;
            var self = this;

            self.getExposure();
            dataGridOptions.toolbarOptions = true; //temporary until the toolbar refactor is complete
            dataGridOptions.showLinksButton = true;

            this.dataGridOptions = dataGridOptions;

            this.listenTo(ADK.Messaging.getChannel('problems'), 'refreshGridView', function() {
                this.refresh({});
            });

            dataGridOptions.collection = ADK.PatientRecordService.fetchCollection(this.fetchOptions);
            dataGridOptions.collection.comparator = function(a, b) {
                var statusNameA = a.get('statusName') || '';
                var statusNameB = b.get('statusName') || '';
                if (statusNameB.localeCompare(statusNameA) !== 0) {
                    return -statusNameB.localeCompare(statusNameA);
                }
            };
            dataGridOptions.onClickRow = function(model, event, gridView) {
                model.attributes.exposure = self.exposure;
                var view = new ModalView({
                    model: model,
                    collection: dataGridOptions.collection
                });
                var siteCode = ADK.UserService.getUserSession().get('site'),
                    pidSiteCode = model.get('pid') ? model.get('pid').split(';')[0] : '';
                var modalOptions;
                modalOptions = {
                    'title': Util.getModalTitle(model),
                    'size': 'large',
                    'headerView': modalHeader.extend({
                        model: model,
                        theView: view
                    }),
                    'footerView': modalFooter.extend({
                        model: model,
                        onRender: function() {
                            this.$el.find('.problemsTooltip').tooltip();
                        },
                        templateHelpers: function() {
                            if ((ADK.UserService.hasPermission('edit-condition-problem') || ADK.UserService.hasPermission('remove-patient-problem')) && pidSiteCode === siteCode) {
                                return {
                                    data: true
                                };
                            } else {
                                return {
                                    data: false
                                };
                            }
                        }
                    }),
                };

                var modal = new ADK.UI.Modal({
                    view: view,
                    options: modalOptions
                });
                modal.show();
            };

            if (ADK.UserService.hasPermission('add-condition-problem') && ADK.PatientRecordService.isPatientInPrimaryVista()) {
                dataGridOptions.onClickAdd = function(e) {
                    e.preventDefault();
                    onAddProblems();
                };
            }

            problemChannel.comply('editProblem', function(model) {
                onEditProblems(model);
            });

            this._super.initialize.apply(this, arguments);

            // add model to list after writeback.
            problemChannel.comply('addProblemListModel', this.handleAddProblemModel, this);
        },
        onBeforeDestroy: function() {
            problemChannel.stopComplying('addProblemListModel');
            problemChannel.stopComplying('editProblem');
            this.dataGridOptions.collection.off('sync');
            this.dataGridOptions.collection.comparator = null;
            this.dataGridOptions.onClickRow = null;
            this.dataGridOptions.onClickAdd = null;
        },
        handleAddProblemModel: function(appletKey, addedProblemModel) {
            //this.dataGridOptions.collection.push(addedProblemModel);
        },
        exposure: '',
        getExposure: function() {
            var self = this;
            var demographics = ADK.PatientRecordService.fetchCollection({
                resourceTitle: "patient-record-patient",
                onSuccess: function() {
                    if (demographics.models && demographics.models[0] && demographics.models[0].attributes) {
                        var exposure = demographics.models[0].attributes.exposure || [];
                        self.exposure = Util.parseExposure(exposure);
                    }
                }
            });
        }
    });

    // expose detail view through messaging
    var channel = ADK.Messaging.getChannel('problems');
    channel.reply('detailView', function(params) {
        var fetchOptions = {
            criteria: {
                "uid": params.uid
            },
            patient: ADK.PatientRecordService.getCurrentPatient(),
            resourceTitle: 'patient-record-problem',
            viewModel: viewParseModel
        };

        var response = $.Deferred();

        var data = ADK.PatientRecordService.fetchCollection(fetchOptions);
        data.on('sync', function() {
            var detailModel = data.first();
            var siteCode = ADK.UserService.getUserSession().get('site'),
                pidSiteCode = detailModel.get('pid') ? detailModel.get('pid').split(';')[0] : '';
            response.resolve({
                view: new ModalView({
                    model: detailModel,
                    collection: data
                }),
                title: Util.getModalTitle(detailModel),
                footerView: modalFooter.extend({
                    model: detailModel,
                    onRender: function() {
                        this.$el.find('.problemsTooltip').tooltip();
                    },
                    templateHelpers: function() {
                        if ((ADK.UserService.hasPermission('edit-patient-problem') || ADK.UserService.hasPermission('remove-patient-problem')) && pidSiteCode === siteCode) {
                            return {
                                data: true
                            };
                        } else {
                            return {
                                data: false
                            };
                        }
                    }
                })

            });
        }, this);

        return response.promise();
    });

    channel.reply('finalizeConsultOrder', function(){
        return {
            fetchOptions: fetchOptions
        };
    });

    function onAddProblems() {
        WorkflowUtils.startAddProblemsWorkflow(AddEditProblemsView);
    }

    function onEditProblems(model) {
        console.log(' in onEditProblems');
    }

    var applet = {
        id: 'problems',
        viewTypes: [{
            type: 'gist',
            view: GistView,
            chromeEnabled: true
        }, {
            type: 'summary',
            view: AppletLayoutView.extend({
                columnsViewType: "summary"
            }),
            chromeEnabled: true
        }, {
            type: 'expanded',
            view: AppletLayoutView.extend({
                columnsViewType: "expanded"
            }),
            chromeEnabled: true
        }, {
            type: 'writeback',
            view: ProblemSearchView,
            chromeEnabled: false
        }],
        defaultViewType: 'summary'
    };

    ADK.Messaging.trigger('register:component:item', {
        type: "tray",
        key: 'observations',
        label: 'Problem',
        onClick: onAddProblems,
        shouldShow: function() {
            return ADK.PatientRecordService.isPatientInPrimaryVista() && ADK.UserService.hasPermissions('add-condition-problem');
        }
    });

    return applet;
});