package us.vistacore.vxsync.config;

import org.junit.Test;

import static org.junit.Assert.assertEquals;

public class VxSoapConfigurationTest
{
    @Test
    public void testGenerateUrl() {
        VxSoapConfiguration cfg = new VxSoapConfiguration();
        assertEquals(cfg.generateUrlString("http", "IPADDRESS ", 80, "/jMeadows/JMeadowsDataService", "wsdl"),
                "http://IPADDRESS /jMeadows/JMeadowsDataService?wsdl");
        assertEquals(cfg.generateUrlString("https", "IPADDRESS ", 443, "/jMeadows/JMeadowsDataService", "wsdl"),
                "https://IPADDRESS /jMeadows/JMeadowsDataService?wsdl");
        assertEquals(cfg.generateUrlString("http", "IPADDRESS ", 8080, "/jMeadows/JMeadowsDataService", "wsdl"),
                "http://IPADDRESS :8080/jMeadows/JMeadowsDataService?wsdl");
        assertEquals(cfg.generateUrlString("https", "IPADDRESS ", 8443, "/jMeadows/JMeadowsDataService", "wsdl"),
                "https://IPADDRESS :8443/jMeadows/JMeadowsDataService?wsdl");
    }
}
