'use strict';

function returnError(ewd, job, query) {
  var json, tmp, url;

  tmp = new ewd.mumps.GlobalNode('TMP', ['HTTPERR', job]);

  json = tmp._getDocument(1);

  if (query.rest_url.split('?')[1] === undefined) {
    url = '';
  } else {
    url = query.rest_url.split('?')[1];
  }

  try {
    json[1].error.request = query.rest_method + ' ' 
                          + query.rest_path + ' '
                          + url;
  } catch (error) {
    return {
      "error": {
        "text": "Unknown JDS error",
        "statusCode": "520"
      }
    }
  }

  tmp._delete();

  return json[1];
}

module.exports = {
  associate: function(ewd, jpid, body) {
    var job = process.pid;
    var query = ewd.query;
    var name, result, tmp;

    tmp = new ewd.mumps.GlobalNode('TMP', ['ewdjs', job]);

    tmp._setDocument(JSON.parse(body), true, 1);

    name = '^TMP("ewdjs",' + job + ')';

    result = ewd.mumps.function('ASSOCIATE^VPRJWPR', jpid, name);

    tmp._delete();

    if (result === 'HTTPERR') { return returnError(ewd, job, query); }

    return;
  },

  putpt: function(ewd, body) {
    var job = process.pid;
    var query = ewd.query;
    var result, name, tmp;
    var jpid, pid, url;

    tmp = new ewd.mumps.GlobalNode('TMP', ['ewdjs', job]);

    tmp._setDocument(JSON.parse(body), true, 1);

    name = '^TMP("ewdjs",' + job + ')';

    result = ewd.mumps.function('PUTPT^VPRJWPR', name);

    if (result === 'HTTPERR') {
      return returnError(ewd, job, query);
    }

    url = result.split('/');
    jpid = url[3];

    result = ewd.mumps.function('SAVE^VPRJWPS', jpid, name, body);

    tmp._delete();

    if (result === 'HTTPERR') {
      return returnError(ewd, job, query);
    } else {
      pid = url[2];

      return '/vpr/' + pid + '/' + result;
    }
  },

  getpt: function(ewd, pid) {
    var job = process.pid;
    var data = '',
        sub1 = '',
        sub2 = '';
    var query = ewd.query;
    var template = query.template ? query.template : '';
    var json, result, tmp;

    result = ewd.mumps.function('GETPT^VPRJWPR', pid, template);

    if (result === 'HTTPERR') {
      return returnError(ewd, job, query);
    } else {
      tmp = new ewd.mumps.GlobalNode('TMP', [job]);

      json = tmp._getDocument();
      result = JSON.parse(result + ']}}');

      for (sub1 = 0; sub1 < json[job].length; sub1++) {
        for (sub2 in json[job][sub1]) {
          data = data + json[job][sub1][sub2];
        }

        result.data.items.push(JSON.parse(data));

        data = '';
      }

      tmp._delete();

      return result;
    }
  },

  getobj: function(ewd, pid, uid, template) {
    var job = process.pid;
    var data = '',
        sub1 = '',
        sub2 = '';
    var query = ewd.query;
    var json, result, tmp, url;

    result = ewd.mumps.function('GETOBJ^VPRJWPR', pid, uid, template);

    if (result === 'HTTPERR') {
      return returnError(ewd, job, query);
    } else {
      tmp = new ewd.mumps.GlobalNode('TMP', [job]);

      json = tmp._getDocument();
      result = JSON.parse(result + ']}}');

      for (sub1 = 0; sub1 < json[job].length; sub1++) {
        for (sub2 in json[job][sub1]) {
          data = data + json[job][sub1][sub2];
        }

        result.data.items.push(JSON.parse(data));

        data = '';
      }

      tmp._delete();

      return result;
    }
  },

  delpt: function(ewd, pid) {
    var job = process.pid;
    var query = ewd.query;
    var json, result, tmp, url;

    result = ewd.mumps.function('DELPT^VPRJWPR', pid);

    if (result === 'HTTPERR') {
      return returnError(ewd, job, query);
    }

    return
  },

  deluid: function(ewd, pid, uid) {
    var job = process.pid;
    var query = ewd.query;
    var json, result, tmp, url;

    result = ewd.mumps.function('DELUID^VPRJWPR', pid, uid);

    if (result === 'HTTPERR') {
      return returnError(ewd, job, query);
    }

    return
  }
};
