HMPROS4 ;SLC/GRR -- Roster Management
 ;;2.0;ENTERPRISE HEALTH MANAGEMENT PLATFORM;**1**;AUG 17, 2011;Build 49
GETSRC(HMP,HMPSRC,HMPFILT) ;; Get Source data from requested source type
 ;;  For example, If source type is "Clinic", pass all clinic names and id's to calling GUI
 ;; Input - HMPARRAY - contains roster data entered thru GUI
 ;K HMPLIST,HMPLIST2
 I '$D(HMPFILT) S HMPFILT=""
 N HMPLIST,HMPLIST2,HMPTYPE,VPERR,HMPI,HMPRNAME,HMPY,HMPOP,HMPTAG,HMPLAB,HMPNLIST,HMPSTN,HMPTEXT,HMPVER,Y,ACT,CHK,CSNM
 N CSNUM,CSP,IDNAME,IDVALUE,TYPENM,UPNAME,VDATE,HMPACT,HMPDATA,HMPDIVP,HMPNAME,HMPCNT,HMPRCNT,ACTIVE
 N HMPSYS S HMPSYS=$$GET^XPAR("SYS","HMP SYSTEM NAME")
 S (HMPLIST,HMPTYPE,HMPOP,HMPLIST2,VPERR)="",HMPI=0
 K ^TMP($J,"HMPROSTR")
 S HMP=$NA(^TMP($J,"HMPROSTR"))
 S HMPACT="I 1"
 I HMPFILT'="" S X=HMPFILT X ^%ZOSF("UPPERCASE") S HMPFILT=Y S HMPACT="I UPNAME[HMPFILT"
 I HMPSRC["Clinic" S HMPLAB="CLIN"
 I HMPSRC["Ward" S HMPLAB="WARD"
 I HMPSRC["Patient" S HMPLAB="PAT"
 I HMPSRC["PCMM Team" S HMPLAB="PCMM"
 I HMPSRC["OE/RR" S HMPLAB="CPRS"
 I HMPSRC["HMP Roster" S HMPLAB="ROST"
 I HMPSRC["Specialty" S HMPLAB="SPEC"
 I HMPSRC["Provider" S HMPLAB="PROV"
 I HMPSRC["PXRM" S HMPLAB="PXRM"
 I HMPLAB="" S VPERR="1^INVALID SOURCE TYPE" Q
 D @HMPLAB
 D SEND
 Q HMP
 ;
CLIN ;Process patients for this clinic.  Select all if filter is null
 K HMPARRAY S HMPARRAY=""
 S HMPNAME="" F  S HMPNAME=$O(^SC("B",HMPNAME)) Q:HMPNAME=""  S X=HMPNAME X ^%ZOSF("UPPERCASE") S UPNAME=Y X HMPACT I  D
 . S HMPI=$O(^SC("B",HMPNAME,0)) I ($P(^SC(HMPI,0),"^",3)="C")&($$ACTLOC^ORWU(HMPI)) D
 . . I $D(^SC(HMPI,"I")) Q:$P(^("I"),"^",2)=""  ;added 4/24/2013
 . . S (CSP,CSNM,CSNUM,SVC,SERVICE,HMPDIV,HMPDIVP)="" ;added 4/24/2013
 . . S CSP=$P(^SC(HMPI,0),"^",7) I CSP]"" S CSNM=$P(^DIC(40.7,CSP,0),"^",1),CSNUM=$P(^DIC(40.7,CSP,0),"^",2) ;modified 4/24/2013
 . . S HMPDIVP=$P(^SC(HMPI,0),"^",15) I HMPDIVP]"" S HMPDIV=$P($G(^DG(40.8,HMPDIVP,0)),"^",1) ;modified 4/24/2013
 . . S SVC=$P(^SC(HMPI,0),"^",8),SERVICE=$S(SVC="M":"MEDICINE",SVC="S":"SURGERY",SVC="P":"PSYCHIATRY",SVC="R":"REHAB MEDICINE",SVC="N":"NEUROLOGY",1:"NONE")
 . . S HMPARRAY(HMPNAME)=HMPI
 . . S HMPARRAY(HMPNAME,1)="DIVISION"_"^"_HMPDIV
 . . S HMPARRAY(HMPNAME,2)="CLINIC STOP NAME"_"^"_CSNM
 . . S HMPARRAY(HMPNAME,3)="CLINIC STOP NUMBER"_"^"_CSNUM
 . . S HMPARRAY(HMPNAME,4)="SERVICE"_"^"_SERVICE
 Q
 ;
WARD ;Process patients for this ward
 K HMPARRAY S HMPARRAY=""
 S HMPNAME="" F  S HMPNAME=$O(^DIC(42,"B",HMPNAME)) Q:HMPNAME=""  S X=HMPNAME X ^%ZOSF("UPPERCASE") S UPNAME=Y X HMPACT I  D 
 . S HMPI=$O(^DIC(42,"B",HMPNAME,0))
 . S HMPARRAY(HMPNAME)=HMPI
 . N DIVP,HMPDIV,SPECP,SPEC,SVC,SERVICE
 . S (DIVP,HMPDIV,SPECP,SPEC,SVC,SERVICE)=""
 . S DIVP=$P(^DIC(42,HMPI,0),"^",11) I DIVP]"" S HMPDIV=$P($G(^DG(40.8,DIVP,0)),"^",1)
 . S SPECP=$P(^DIC(42,HMPI,0),"^",12) I SPECP]"" S SPEC=$P($G(^DIC(42.4,SPECP,0)),"^",1)
 . S SVC=$P(^DIC(42,HMPI,0),"^",3)
 . S SERVICE=$S(SVC="M":"MEDICINE",SVC="S":"SURGERY",SVC="P":"PSYCHIATRY",SVC="NH":"NHCU",SVC="NE":"NEUROLOGY",SVC="I":"INTERMEDIATE MEDICINE",1:"")
 . S:'$L(SERVICE) SERVICE=$S(SVC="R":"REHAB MEDICINE",SVC="SCI":"SPINAL CORD INJURY",SVC="D":"DOMICILLIARY",SVC="B":"BLIND REHAB",1:"NONE")
 . S HMPARRAY(HMPNAME,1)="DIVISION"_"^"_HMPDIV
 . S HMPARRAY(HMPNAME,2)="SPECIALTY"_"^"_SPEC
 . S HMPARRAY(HMPNAME,3)="SERVICE"_"^"_SERVICE
 Q
 ;
PAT ;Process patient from Patient file Source
 K HMPARRAY S HMPARRAY=""
 N DFN,SEX,DOB,SSN,ICN,DOBOUT
 I HMPFILT?1U4N D  Q
 . I $D(^DPT("BS5",HMPFILT)) D
 . . S HMPI=0 F  S HMPI=$O(^DPT("BS5",HMPFILT,HMPI)) Q:HMPI'>0  D
 . . . S DFN=HMPI,ICN=$$GETICN^MPIF001(DFN)
 . . . K WARN S WARN="" D SECCHK ;ZW WARN
 . . . S HMPNAME=$P(^DPT(HMPI,0),"^",1),HMPARRAY(HMPNAME)=HMPI
 . . . S SEX=$P(^DPT(HMPI,0),"^",2),DOB=$P(^DPT(HMPI,0),"^",3),SSN=$P(^DPT(HMPI,0),"^",9)
 . . . S DOBOUT=$$FMTHL7^XLFDT(DOB)
 . . . S HMPARRAY(HMPNAME,1)="ICN"_"^"_ICN
 . . . S HMPARRAY(HMPNAME,2)="GENDER"_"^"_$S(SEX="M":"MALE",SEX="F":"FEMALE",1:"NONE")
 . . . S HMPARRAY(HMPNAME,3)="DOB"_"^"_DOBOUT
 . . . S HMPARRAY(HMPNAME,4)="SSN"_"^"_SSN
 S HMPNAME=HMPFILT
 I $D(^DPT("B",HMPNAME)) D  Q
 . S HMPI=0 F  S HMPI=$O(^DPT("B",HMPNAME,HMPI)) Q:HMPI'>0  S HMPARRAY(HMPNAME)=HMPI D
 . . S DFN=HMPI,ICN=$$GETICN^MPIF001(DFN)
 . . K WARN S WARN="" D SECCHK ;ZW WARN
 . . S SEX=$P(^DPT(HMPI,0),"^",2),DOB=$P(^DPT(HMPI,0),"^",3),SSN=$P(^DPT(HMPI,0),"^",9)
 . . S DOBOUT=$$FMTHL7^XLFDT(DOB)
 . . S HMPARRAY(HMPNAME,1)="ICN"_"^"_ICN
 . . S HMPARRAY(HMPNAME,2)="GENDER"_"^"_$S(SEX="M":"MALE",SEX="F":"FEMALE",1:"NONE")
 . . S HMPARRAY(HMPNAME,3)="DOB"_"^"_DOBOUT
 . . S HMPARRAY(HMPNAME,4)="SSN"_"^"_SSN
 E  F  S HMPNAME=$O(^DPT("B",HMPNAME)) Q:HMPNAME=""!(HMPNAME'[HMPFILT)  D
 . S HMPI=0 F  S HMPI=$O(^DPT("B",HMPNAME,HMPI)) Q:HMPI'>0  S HMPARRAY(HMPNAME)=HMPI D
 . . S DFN=HMPI,ICN=$$GETICN^MPIF001(DFN)
 . . K WARN S WARN="" D SECCHK ;ZW WARN
 . . S SEX=$P(^DPT(HMPI,0),"^",2),DOB=$P(^DPT(HMPI,0),"^",3),SSN=$P(^DPT(HMPI,0),"^",9)
 . . S DOBOUT=$$FMTHL7^XLFDT(DOB)
 . . S HMPARRAY(HMPNAME,1)="ICN"_"^"_ICN
 . . S HMPARRAY(HMPNAME,2)="GENDER"_"^"_$S(SEX="M":"MALE",SEX="F":"FEMALE",1:"NONE")
 . . S HMPARRAY(HMPNAME,3)="DOB"_"^"_DOBOUT
 . . S HMPARRAY(HMPNAME,4)="SSN"_"^"_SSN
 Q
 ;
PCMM ;Process patients from a PCMM team
 K HMPARRAY S HMPARRAY=""
 S HMPSTN=$P($G(^XMB(1,1,"XUS")),"^",17)
 S HMPI=0 F  S HMPI=$O(^SCTM(404.51,"AINST",HMPSTN,HMPI)) Q:HMPI'>0  S HMPNAME=$P($G(^SCTM(404.51,HMPI,0)),"^",1) S X=HMPNAME X ^%ZOSF("UPPERCASE") S UPNAME=Y X HMPACT I  D
 . S HMPARRAY(HMPNAME)=HMPI
 . N TEAMP,TEAMPP,SVCP,SERVICE S (TEAMP,TEAMPP,SVCP,SERVICE)=""
 . S TEAMPP=$P(^SCTM(404.51,HMPI,0),"^",3) I TEAMPP]"" S TEAMP=$P(^SD(403.47,TEAMPP,0),"^",1)
 . S SVCP=$P(^SCTM(404.51,HMPI,0),"^",6) I SVCP]"" S SERVICE=$P(^DIC(49,SVCP,0),"^",1)
 . S HMPARRAY(HMPNAME,1)="TEAM PURPOSE"_"^"_TEAMP
 . S HMPARRAY(HMPNAME,2)="SERVICE"_"^"_SERVICE
 Q
 ;
CPRS ;Process patients from CPRS Lists
 K HMPARRAY S HMPARRAY=""
 S HMPNAME="" F  S HMPNAME=$O(^OR(100.21,"B",HMPNAME)) Q:HMPNAME=""  S X=HMPNAME X ^%ZOSF("UPPERCASE") S UPNAME=Y X HMPACT I  D
 . S HMPI=0 F  S HMPI=$O(^OR(100.21,"B",HMPNAME,HMPI)) Q:HMPI'>0  D
 . . S HMPARRAY(HMPNAME)=HMPI
 . . N TYPE,CREATP,CREATOR
 . . S TYPE=$P(^OR(100.21,HMPI,0),"^",2)
 . . S TYPENM=$S(TYPE="P":"PERSONAL PATIENT",TYPE="TA":"TEAM PATIENT AUTOLINKED",TYPE="TM":"TEAM PATIENT MANUAL",TYPE="MRAL":"MANUAL REMOVAL AUTOLINK ADDITION",1:"NONE")
 . . S CREATP=$P(^OR(100.21,HMPI,0),"^",5),CREATOR=""
 . . I CREATP]"" S CREATOR=$P($G(^VA(200,CREATP,0)),"^",1)
 . . S HMPARRAY(HMPNAME,1)="TYPE"_"^"_TYPENM
 . . S HMPARRAY(HMPNAME,2)="CREATOR"_"^"_CREATOR
 Q
 ;
ROST ;Process patients from selected roster
 K HMPARRAY S HMPARRAY=""
 S HMPNAME="" F  S HMPNAME=$O(^HMPROSTR("B",HMPNAME)) Q:HMPNAME=""  S X=HMPNAME X ^%ZOSF("UPPERCASE") S UPNAME=Y X HMPACT I  D
 . S HMPI=$O(^HMPROSTR("B",HMPNAME,0)) S HMPARRAY(HMPNAME)=HMPI
 . N DISP,OWNERP,OWNER
 . S DISP=$P(^HMPROSTR(HMPI,0),"^",2)
 . S OWNERP=$P(^HMPROSTR(HMPI,0),"^",4),OWNER=""
 . I OWNERP]"" S OWNER=$P($G(^VA(200,OWNERP,0)),"^",1)
 . S HMPARRAY(HMPNAME,1)="DISPLAY NAME"_"^"_DISP
 . S HMPARRAY(HMPNAME,2)="OWNER"_"^"_OWNER
 Q
 ;
SPEC ;Process patients with selected Treating Specialty
 K HMPARRAY S HMPARRAY=""
 S HMPNAME="" F  S HMPNAME=$O(^DIC(45.7,"B",HMPNAME)) Q:HMPNAME=""  S X=HMPNAME X ^%ZOSF("UPPERCASE") S UPNAME=Y X HMPACT I  D
 . S HMPI=$O(^DIC(45.7,"B",HMPNAME,0)),VDATE=$O(^DIC(45.7,HMPI,"E","ADATE","")),ACT=$O(^DIC(45.7,HMPI,"E","ADATE",VDATE,0)),ACTIVE=$P(^DIC(45.7,HMPI,"E",ACT,0),"^",2)
 . I ACTIVE D
 . . S HMPARRAY(HMPNAME)=HMPI
 . . N SVC,SERVICE
 . . S SVC=$P(^DIC(45.7,HMPI,0),"^",3)
 . . S SERVICE=$S(SVC="M":"MEDICINE",SVC="S":"SURGERY",SVC="P":"PSYCHIATRY",SVC="NH":"NHCU",SVC="NE":"NEUROLOGY",SVC="I":"INTERMEDIATE MEDICINE",1:"")
 . . S:'$L(SERVICE) SERVICE=$S(SVC="R":"REHAB MEDICINE",SVC="SCI":"SPINAL CORD INJURY",SVC="D":"DOMICILLIARY",SVC="B":"BLIND REHAB",SVC="RE":"RESPITE CARE",1:"NONE")
 . . S HMPARRAY(HMPNAME,1)="SERVICE"_"^"_SERVICE
 Q
 ;
PROV ;Process patients for selected provider
 K HMPARRAY S HMPARRAY=""
 N TITLEP,VTITLE,SEX
 S VTITLE=""
 I HMPFILT'="" D
 . S HMPNAME=HMPFILT
 . F  S HMPNAME=$O(^VA(200,"B",HMPNAME)) Q:HMPNAME=""!(HMPNAME'[HMPFILT)  D
 . . S HMPI=0 F  S HMPI=$O(^VA(200,"B",HMPNAME,HMPI)) Q:HMPI'>0  D
 . . . S TITLEP=$P(^VA(200,HMPI,0),"^",9) I TITLEP]"" S VTITLE=$P($G(^DIC(3.1,TITLEP,0)),"^",1)
 . . . S SEX=$P(^VA(200,HMPI,1),"^",2)
 . . . S HMPARRAY(HMPNAME)=HMPI
 . . . S HMPARRAY(HMPNAME,1)="SEX"_"^"_SEX
 . . . S HMPARRAY(HMPNAME,2)="TITLE"_"^"_VTITLE
 I HMPFILT="" D
 . S HMPNAME="" F  S HMPNAME=$O(^VA(200,"B",HMPNAME)) Q:HMPNAME=""  D
 . . S HMPI=0 F  S HMPI=$O(^VA(200,"B",HMPNAME,HMPI)) Q:HMPI'>0  D
 . . . S TITLEP=$P(^VA(200,HMPI,0),"^",9) I TITLEP]"" S VTITLE=$P($G(^DIC(3.1,TITLEP,0)),"^",1)
 . . . S SEX=$P(^VA(200,HMPI,1),"^",2)
 . . . S HMPARRAY(HMPNAME)=HMPI
 . . . S HMPARRAY(HMPNAME,1)="SEX"_"^"_SEX
 . . . S HMPARRAY(HMPNAME,2)="TITLE"_"^"_VTITLE
 Q
 ;
PXRM ;Process patients for selected panel
 K HMPARRAY S HMPARRAY=""
 S HMPNAME="" F  S HMPNAME=$O(^PXRM(810.4,"B",HMPNAME)) Q:HMPNAME=""  S X=HMPNAME X ^%ZOSF("UPPERCASE") S UPNAME=Y X HMPACT I  D
 . S HMPI=0 F  S HMPI=$O(^PXRM(810.4,"B",HMPNAME,HMPI)) Q:HMPI'>0  I $P($G(^PXRM(810.4,HMPI,0)),"^",3)=3 D
 . . S HMPARRAY(HMPNAME)=HMPI
 . . N LISTP,LISTN,CLASS,CLASSNM
 . . S (LISTP,LISTN,CLASS,CLASSNM)="" ;added 3/15/11 grr
 . . S LISTP=$P(^PXRM(810.4,HMPI,0),"^",7) I LISTP]"" S LISTN=$P(^PXRMD(811.5,LISTP,0),"^",1)
 . . S CLASS=$P(^PXRM(810.4,HMPI,100),"^",1),CLASSNM=$S(CLASS="N":"National",CLASS="V":"VISN",CLASS="L":"Local",1:"NONE")
 . . S HMPARRAY(HMPNAME,1)="TERM"_"^"_LISTN
 . . S HMPARRAY(HMPNAME,2)="CLASS"_"^"_CLASSNM
 Q
 ;
SEND ;send pending rosters.  Called through RPC
 S HMPRCNT=0,HMPI=0
 S HMPVER="<results version='"_$P($T(HMPROS4+1),";",3)_"'>"
 D ADD(HMPVER)
 S HMPTEXT="<source name='"_HMPSRC_"' >" D ADD(HMPTEXT)
 D ADD("<entries>")
 K HMPII S HMPII="" F  S HMPII=$O(HMPARRAY(HMPII)) Q:HMPII=""  D
 . S HMPDATA=$$ESC^HMPD(HMPII)
 . S HMPTEXT="<entry NAME='"_HMPDATA_"' id='"_HMPARRAY(HMPII)_"' />" D ADD(HMPTEXT)
 . D ADD("<identifiers>")
 . N I S I=0 F  S I=$O(HMPARRAY(HMPII,I)) Q:I'>0  D
 . . S IDNAME=$P(HMPARRAY(HMPII,I),"^",1),IDVALUE=$P(HMPARRAY(HMPII,I),"^",2),IDVALUE=$$ESC^HMPD(IDVALUE)
 . . S HMPTEXT="<ident name='"_IDNAME_"' value='"_IDVALUE_"' />" D ADD(HMPTEXT)
 . D ADD("</identifiers>")
 D ADD("</entries>")
 D ADD("</source>")
 S HMPTEXT="</results>" D ADD(HMPTEXT)
 Q
 ;
ADD(X) ; -- Add a line @HMP@(n)=X
 I X'["<" S X=$$ESC^HMPD(X)
 S HMPI=$G(HMPI)+1
 S @HMP@(HMPI)=X
 Q
 ;
SECCHK ; check for sensitive record
 N HMPY,I,X
 K WARN
 D PTSEC^DGSEC4(.HMPY,DFN,1)  ;IA #3027
 S CHK("dfn")=DFN
 S CHK("sensitive")=(HMPY(1)>0)
 S CHK("mayAccess")=(HMPY(1)<3)
 S CHK("logAccess")=(HMPY(1)>1)
 M WARN=HMPY K WARN(1)
 ;
