'use strict';

var metrics = require('../utils/metrics/metrics');
var httpUtil = require('../utils/http');
var rdkAppConfig = require('../config/config');

var logger = {
    trace: function() {},
    debug: function() {},
    info: function() {},
    warn: function() {},
    error: function() {},
    fatal: function() {}
};

// @US6253
xdescribe('config http', function() {

    // @TC816
    describe('config.timeoutMillis', function() {

        it('tests that default appConfig timeout value exists', function() {
          expect(rdkAppConfig.timeoutMillis).toBeGreaterThan(0);
        });

    });

    // @TC817
    describe('fetch', function() {
        var logger;
        var app;

        beforeEach(function() {

            app = {
                logger : logger,
                config : {mvi : {host : '10.10.01.101'},
                    hmpServer : {host : ''},
                    jdsServer : {host : ''},
                    solrServer : {host : ''},
                    vistaSites : {'9E7A': {
                        name: 'PANORAMA',
                        host: '10.2.2.101'
                    }
                    }
                }
            };

            metrics.initialize(app);
        });

        afterEach(function() {
            clearInterval(metrics.memoryUsageTimerId);
        });

        it('tests that appConfig timeout value is used if supplied and requestConfig is not', function() {
            var config = {
                protocol: 'http',
                logger: logger,
                options: {
                    host: '192.0.0.2',
                    port: 8080,
                    path: '/info',
                    method: 'GET'
                }
            };
            var appConfig = {
                timeoutMillis: 1000
            };

            var done = false;
            var error;
            var test = {
                callback: function(err) {
                    error = err;
                    done = true;
                }
            };

            spyOn(test, 'callback').andCallThrough();
            jasmine.createSpy('callback');
            var begin = Date.now();
            httpUtil.fetch(appConfig, config, test.callback);

            waitsFor(function() {
                return done;
            }, '"done" should be true', 2400);

            runs(function() {
                var end = Date.now();
                expect(test.callback).toHaveBeenCalled();
                expect(error).toBeDefined();
                expect(end - begin).toBeGreaterThan(1000);
                expect(end - begin).toBeLessThan(1500);
            });
        });


        it('tests that requestConfig timeout value is used if supplied and appConfig is not', function() {
            var config = {
                protocol: 'http',
                logger: logger,
                timeoutMillis: 1500,
                options: {
                    host: '192.0.0.2',
                    port: 8080,
                    path: '/info',
                    method: 'GET'
                }
            };
            var appConfig = {};

            var done = false;
            var error;
            var test = {
                callback: function(err) {
                    error = err;
                    done = true;
                }
            };

            spyOn(test, 'callback').andCallThrough();
            jasmine.createSpy('callback');
            var begin = Date.now();
            httpUtil.fetch(appConfig, config, test.callback);

            waitsFor(function() {
                return done;
            }, '"done" should be true', 2400);

            runs(function() {
                var end = Date.now();
                expect(test.callback).toHaveBeenCalled();
                expect(error).toBeDefined();
                expect(end - begin).toBeGreaterThan(1500);
                expect(end - begin).toBeLessThan(2400);
            });
        });


        it('tests that requestConfig timeout value is used if supplied and appConfig is null', function() {
            var config = {
                protocol: 'http',
                logger: logger,
                timeoutMillis: 1500,
                options: {
                    host: '192.0.0.2',
                    port: 8080,
                    path: '/info',
                    method: 'GET'
                }
            };
            var done = false;
            var error;
            var test = {
                callback: function(err) {
                    error = err;
                    done = true;
                }
            };

            spyOn(test, 'callback').andCallThrough();
            jasmine.createSpy('callback');
            var begin = Date.now();
            httpUtil.fetch(null, config, test.callback);

            waitsFor(function() {
                return done;
            }, '"done" should be true', 2400);

            runs(function() {
                var end = Date.now();
                expect(test.callback).toHaveBeenCalled();
                expect(error).toBeDefined();
                expect(end - begin).toBeGreaterThan(1500);
                expect(end - begin).toBeLessThan(2400);
            });
        });


        it('tests that requestConfig timeout value is used if both it and appConfig are supplied', function() {
            var config = {
                protocol: 'http',
                logger: logger,
                timeoutMillis: 1500,
                options: {
                    host: '192.0.0.2',
                    port: 8080,
                    path: '/info',
                    method: 'GET'
                }
            };
            var appConfig = {
                timeoutMillis: 1000
            };

            var done = false;
            var error;
            var test = {
                callback: function(err) {
                    error = err;
                    done = true;
                }
            };

            spyOn(test, 'callback').andCallThrough();
            jasmine.createSpy('callback');
            var begin = Date.now();
            httpUtil.fetch(appConfig, config, test.callback);

            waitsFor(function() {
                return done;
            }, '"done" should be true', 2400);

            runs(function() {
                var end = Date.now();
                expect(test.callback).toHaveBeenCalled();
                expect(error).toBeDefined();
                expect(end - begin).toBeGreaterThan(1500);
                expect(end - begin).toBeLessThan(2400);
            });
        });
    });

    // @TC818
    describe('JSON POST', function() {

        it('tests that appConfig timeout value is used if supplied and requestConfig is not', function() {
            var config = {
                protocol: 'http',
                logger: logger,
                options: {
                    host: '192.0.0.2',
                    port: 8080,
                    path: '/info',
                    method: 'POST'
                }
            };

            var appConfig = {
                timeoutMillis: 1000
            };
            var done = false;
            var error;
            var test = {
                callback: function(err) {
                    done = true;
                    error = err;
                }
            };

            spyOn(test, 'callback').andCallThrough();
            jasmine.createSpy('callback');

            var begin = Date.now();
            httpUtil.postJSONObject('{\"test\":\"test\"}', appConfig, config, test.callback);

            waitsFor(function() {
                return done;
            }, '"done" should be true', 2400);

            runs(function() {
                var end = Date.now();
                expect(test.callback).toHaveBeenCalled();
                expect(error).toBeDefined();
                expect(end - begin).toBeGreaterThan(1000);
                expect(end - begin).toBeLessThan(1500);
            });

        });


        it('tests that requestConfig timeout value is used if supplied and appConfig is not', function() {
            var config = {
                protocol: 'http',
                logger: logger,
                timeoutMillis: 1500,
                options: {
                    host: '192.0.0.2',
                    port: 8080,
                    path: '/info',
                    method: 'POST'
                }
            };

            var appConfig = {};

            var done = false;
            var error;
            var test = {
                callback: function(err) {
                    done = true;
                    error = err;
                }
            };

            spyOn(test, 'callback').andCallThrough();
            jasmine.createSpy('callback');

            var begin = Date.now();
            httpUtil.postJSONObject('{\"test\":\"test\"}', appConfig, config, test.callback);

            waitsFor(function() {
                return done;
            }, '"done" should be true', 2400);

            runs(function() {
                var end = Date.now();
                expect(test.callback).toHaveBeenCalled();
                expect(error).toBeDefined();
                expect(end - begin).toBeGreaterThan(1500);
                expect(end - begin).toBeLessThan(2400);
            });

        });

        it('tests that requestConfig timeout value is used if supplied and appConfig is null', function() {
            var config = {
                protocol: 'http',
                logger: logger,
                timeoutMillis: 1500,
                options: {
                    host: '192.0.0.2',
                    port: 8080,
                    path: '/info',
                    method: 'POST'
                }
            };

            var done = false;
            var error;
            var test = {
                callback: function(err) {
                    done = true;
                    error = err;
                }
            };

            spyOn(test, 'callback').andCallThrough();
            jasmine.createSpy('callback');

            var begin = Date.now();
            httpUtil.postJSONObject('{\"test\":\"test\"}', null, config, test.callback);

            waitsFor(function() {
                return done;
            }, '"done" should be true', 2400);

            runs(function() {
                var end = Date.now();
                expect(test.callback).toHaveBeenCalled();
                expect(error).toBeDefined();
                expect(end - begin).toBeGreaterThan(1500);
                expect(end - begin).toBeLessThan(2400);
            });
        });

        it('tests that requestConfig timeout value is used if both it and appConfig are supplied', function() {
            var config = {
                protocol: 'http',
                logger: logger,
                timeoutMillis: 1500,
                options: {
                    host: '192.0.0.2',
                    port: 8080,
                    path: '/info',
                    method: 'POST'
                }
            };

            var appConfig = {
                timeoutMillis: 1000
            };
            var done = false;
            var error;
            var test = {
                callback: function(err) {
                    done = true;
                    error = err;
                }
            };

            spyOn(test, 'callback').andCallThrough();
            jasmine.createSpy('callback');

            var begin = Date.now();
            httpUtil.postJSONObject('{\"test\":\"test\"}', appConfig, config, test.callback);

            waitsFor(function() {
                return done;
            }, '"done" should be true', 2400);

            runs(function() {
                var end = Date.now();
                expect(test.callback).toHaveBeenCalled();
                expect(error).toBeDefined();
                expect(end - begin).toBeGreaterThan(1500);
                expect(end - begin).toBeLessThan(2400);
            });
        });


    });

});
