/*jslint devel: true, white: true, debug: true, nomen: true*/

/* JAVASCRIPT ONLY APPLICABLE TO THE COMPOSE PAGE 
*
* This code is slowly getting organized into modules, primarily using closures. We're running JSHint on new code to try to keep it conforming to some standard best practices. 
*
* More info on modules and closures: https://medium.freecodecamp.com/javascript-modules-a-beginner-s-guide-783f7d7a5fcc
* 																	 http://eloquentjavascript.net/10_modules.html
*
* How to make the *this* keyword consistently point to what you want it to: https://www.smashingmagazine.com/2014/01/understanding-javascript-function-prototype-bind
* 
* Goal for the future is to actually keep these modules in separate files and use something like require.js to grab them as needed.  Possibly we could even go crazy and start 
* minifying our js as part of the deployment process so that we can add tons of comments without increasing pageweight.  Time to party like it's 2003! - MG 2016-08-26 */


//define namespaces for this file
var dpii = dpii || {}; //define a namespace for our js
var $ = $ || console.error('Jquery is not available for this script');
//dpii.dss_provider_email = "varouting@direct-ehealth.com";  // Email address used for the DSS prodiver search integration.
dpii.dss_provider_email = "tauser@dev.direct.DOMAIN.EXT";  // Email address used for the DSS prodiver search integration.
dpii.dss_provider_search_website = "https://direct-ehealth.net/";
dpii.compose = (function() { 
	"use strict";
	
	return {
		messageId: function(){ 
			return $('input[name="msg_id"]').val(); 
		},
		
		hasMessageId: function(){
			var messageID = this.messageId();
			return ($.isNumeric(messageID) && messageID > 0 && Math.floor(messageID) == messageID);
		},
		
		_init: function(){
			//call on the _init method for any object inside of dpii.compose that has one
			for(var property in this){
				if(!this.hasOwnProperty(property) || property == '_init') 
					continue;
				if(typeof this[property] === 'object'){
					this[property].parent = this;
					if(this[property].hasOwnProperty('_init')){
						this[property]._init();
					}
				}
			}
		
			initRichTextEditor();
 		},
	};
})();

//////////////////////////////////////////////////////////////////////////
// CHANGES
// tracking changes that the user has made since last saving the message
//////////////////////////////////////////////////////////////////////////
dpii.compose.changes = (function() {
	var dataAttributes = {'exist': 'altered-since-save'};
	
	return {
		interval: null,
		
		exist: function(){ 
			return $('#main_form').data(dataAttributes.exist) === 1; 
		},

		mark: function(){ 
			return $('#main_form').data(dataAttributes.exist, 1); 
		}, 

		clear: function(){   
			return $('#main_form').data(dataAttributes.exist, 0);
		},
		
		_init: function(){
			this.clear();
		
			this.interval = setInterval(function() {
				if(this.exist()){
					$("#main_form").trigger('autosave');
				}
			}.bind(this), 60000);

			//changes to any input in the main compose form 
			$('#main_form :input').change(function(){
				this.mark();
			}.bind(this)); 
			
			//changes to message body will trigger autosave (special case since it's not a normal form field)
			$("#tinyeditorframe").contents().find("#editor").on('blur keyup paste', function() { 
			  if(window.parent.$('#message_body').val() != $(this).html()) { 
				this.mark();
				window.parent.$('#message_body').val($(this).html());
			  }
			}.bind(this));						
		},
	};   
})();


///////////////////////////////////
// CSRF
///////////////////////////////////

dpii.compose.csrf = (function() { 
	var tokenIdentifier = 'input[type=hidden].token';
	
	return {
		name: function(){ 
			return $(tokenIdentifier).attr('name'); 
		},
		
		value: function(){
			return $(tokenIdentifier).val(); 
		},
		
		queryString: function(){
			return '?' + this.name() + '=' + this.value(); 
		},
		
		update: function(value){
			return $(tokenIdentifier).val(value);
		
		}
	};   
})();

///////////////////////////////////
// FEEDBACK
///////////////////////////////////

dpii.compose.feedback = (function() { 
	
		function show(alertType, message, alertFor, header){		
				var container = $('.alert-danger.clone-me').clone().removeClass('clone-me').css('display', 'block');

				container.find('.message-text').text(message);
				if(header)
					container.find('.message-header').html('<strong>' + header + '</strong>');
				if(alertType != 'danger') 
					container.removeClass('alert-danger').addClass('alert-'+alertType);
				if(alertFor)
					container.data('for', alertFor);

				$('.alert-danger.clone-me').after(container);
				dpii.compose.files.adjustInputTrigger();
		}
	
	return {
		info: function(message, identifier){
			return show('info', message, identifier);
		},

		error: function(message, identifier){
			return show('danger', message, identifier, 'An error was encountered. ');
		},

		success: function(message, identifier){
			return show('success', message, identifier, 'Success! ');
		},

		warning: function(message, identifier){
			return show('warning', message, identifier, 'Warning: ');
		},

		remove: function(identifier){
			$('.alert[data-for="'+identifier+'"]').remove();
		},

		setValidation: function(input, message){
			this.error(message, $(input).attr('name'));
			$(input).addClass('has-error');
		},

		removeValidation: function(input){
			this.remove($(input).attr('name'));
			$(input).removeClass('has-error');
		},
	};   
})();

///////////////////////////////////
// RECIPIENTS
///////////////////////////////////

dpii.compose.recipients = (function() { 
	
	var applyTokensToExistingRecipients = function(fieldName, fieldText){
		html_entity_decode(fieldText).split(';').forEach(function(address){
			address = address.replace(/'/g,"\'"); // Escape apostrophes before trimming
			address = $.trim(address);
			if(address.length > 0){
				var extracted = address.match(/([a-zA-Z0-9\'._-]+@[a-zA-Z0-9._-]+\.[a-zA-Z0-9._-]+)/gi); //Apostrophe added 
				$('textarea[name="'+ fieldName+'"]').tokenInput('add', { name : htmlentities(address,'ENT_NOQUOTES'), id : htmlentities(extracted), uid: uniqid() });
			}
		}.bind(this));
	};
	
	var markupForValidatedRecipient = function(item){
		var email = item.id;
		if(item.descripton != null)
			email = item.description;
		return '<li><div style="display: inline-block; padding-left: 10px;"><div class="full_name"> ' + item.name + '</div><div class="email">' + email + '</div></div></li>';
	};
	
	var markupForUnvalidatedRecipient = function(item){
		item.uid = uniqid();
		var markup = '<li class="unvalidated"><p class="unvalidated" id="'+item.uid+'" data-address="' + item.id + '"';
		if(item.description == null) {
			markup += 'title="' + item.id + '" data-address="' +item.id+ '">';
		}else{
			markup += " onclick=\"viewDistList('" + item.uid + "','" + htmlentities(base64_encode(json_encode(item))) + "','message_to');\" title=\"" + item.description +"\" ><img src=\"/images/group.png\" class=\"hover_pointer\" alt=\"Distribution List\"> ";
		}
		markup += item.name + '</p></li>';
		return markup;
	};
	
	var tokenSettings = {
		theme: 'dpii',
		searchDelay: 500,
		hintText: 'Enter a Direct address',
		tokenDelimiter: ';',
		onAdd: function(e) { if(!multipleAddressSplit(e)) { verifyAddress(e); }	},
		noResultsText: 'This is not a trusted address',
		resultsFormatter: markupForValidatedRecipient,
		tokenFormatter: markupForUnvalidatedRecipient,
	};
	
	
	return {
		_init: function(){
			var message_to_text = $('textarea[name="message_to"]').text();
			var message_cc_text = $('textarea[name="message_cc"]').text();
			$('textarea[name="message_to"], textarea[name="message_cc"]').ready(function(){
				$("#message_to").tokenInput('/inbox/get_contacts_search/', tokenSettings);
				$("#message_cc").tokenInput('/inbox/get_contacts_search/', tokenSettings);
				applyTokensToExistingRecipients('message_to', message_to_text);
				applyTokensToExistingRecipients('message_cc', message_cc_text);
			});	
		}
	};   
})();

///////////////////////////////////////////////////////////////////
// SAVE
///////////////////////////////////////////////////////////////////

dpii.compose.save = (function(options) { 
	var inProgress = false;
	
	return {
		inProgress: function(){ 
			return inProgress; 
		},
		run: function(options){ 
			if(!this.parent.changes.exist() && (!$.isPlainObject(options) || !options.forceSave))
				return false;
			
			if(this.inProgress()) 
				return false;

			if(dpii.compose.ui.dialogIsOpen()) 
				return false; //the user is working on something besides the draft, and saving may cause problms
			
			inProgress = true;

			if($('#message_body').css('display') == 'none') {
				$('textarea[name="message_body"]').val(editor.getEditorContent());
			}

			var settings = {
				type: 'POST',
				url: '/inbox/ajax_draft_save/',
				data: $('#main_form').serialize(),
				dataType: 'html',
				complete: function(jqXHR, status){

					inProgress = false;
					$('.autosave').remove();

					if(userIsNotAuthorized(jqXHR)) {
						window.location = '/auth/logout';
						return false;
					}

					if(!isJSON(jqXHR.responseText)){
						return false;
					}

					var parsedResponse = $.parseJSON(jqXHR.responseText);
					this.parent.csrf.update(parsedResponse.token);
					if(status == 'success'){
						var id = parsedResponse.id;
						if($.isNumeric(id) && id > 1 && Math.floor(id) == id){
							$('input[name="msg_id"]').val(id);
							this.parent.changes.clear();
						}
					}
				}.bind(this),
			};

			if($.isPlainObject(options)){
				if(options.forceSave)
				   settings.data += '&force_save=true';
				if(options.async === false)
					settings.async = false;
			}

			return $.ajax(settings);
		}
	};   
})();
	


///////////////////////////////////////////////////////////////////
// USER INTERFACE
///////////////////////////////////////////////////////////////////
dpii.compose.ui = (function(options) {
 
	return {
		dialogIsOpen: function(){
			return ($('.overlay').length > 0 || $('.form-dialog-container').length > 0);
		}, 
		
		_init: function(){
			$('a.cancel').click(function(event) {
				if(!this.parent.changes.exist()) return true; //if there are no unsaved changes, go ahead and cancel without prompting
				if(event.preventDefault) event.preventDefault(); else event.returnValue = false;
				var dialog = $('<p>This draft has unsaved changes.  Would you like to save your changes?</p>').dialog({
					buttons: {
						"Yes": function() {$('#save_btn').click();},
						"No":  function() {window.location.href = "/inbox";},
						"Cancel":  function() {
							dialog.dialog('close');
						}
					}
				});
			}.bind(this));

			$("#show-cc").click(function(event) {
				if(event.preventDefault) event.preventDefault(); else event.returnValue = false;
				if($('textarea[name="message_cc"]').length) {
					$('textarea[name="message_cc"]').parent().parent().css('display','table-row');
					$('textarea[name="message_cc"]').focus();
					$('#show-cc').remove();
				}
			});
                        
                        $(".ps-address-book").click(function(event) {
				//if(event.preventDefault) event.preventDefault(); else event.returnValue = false;
				
                                // Launch Provider Search Box (DSS) //
                                // Link is https://direct-ehealth.com:449/ //
                                
                                var $this = $(this);
                                
                                var url = dpii.dss_provider_search_website;
                                var windowName = "Provider Search";//$(this).attr("name");
                                var windowSize = $this.data("popup");
                                
                                // Adding support to center the popup page. //
                                // Fixes dual-screen position                         Most browsers      Firefox
                                var dualScreenLeft = window.screenLeft != undefined ? window.screenLeft : window.screenX;
                                var dualScreenTop = window.screenTop != undefined ? window.screenTop : window.screenY;

                                var w = 800; // default;
                                var h = 600;
                                var width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
                                var height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;
                                
                                w = width - (width * .20);
                                var left = ((width / 2) - (w / 2)) + dualScreenLeft;
                                var top = ((height / 2) - (h / 2)) + dualScreenTop;
 
                                var $dsswindow = window.open(url, windowName, 'scrollbars=yes, width=' + w + ', height=' + h + ', top=' + top + ', left=' + left);
                                
                                // Populate TO field with DSS provider email.  //
                                // varouting@direct-ehealth.com
                                
                                
                                //event.preventDefault();
                                
                                $('#token-input-message_to').val(dpii.dss_provider_email);
                               // $('#token-input-message_to').parent().parent().val(dpii.dss_provider_email);
                                $('textarea[name="message_to"]').val(dpii.dss_provider_email);
                                
                                
                                $('#token-input-message_to').prop("disabled", true);
                                $('#token-input-message_to').parent().parent().css({"border":'none',"color":"#000000"});
                                $('#token-input-message_to').prop("color", '#000000');
                                $('#token-input-message_to').css("width", 300);
                                $('#from_field').css("padding-left", "5px");
                                if($('textarea[name="message_pscc"]').length) {
					$('textarea[name="message_pscc"]').parent().parent().css('display','table-row');
					$('textarea[name="message_pscc"]').focus();
					//$('#show-pscc').remove();
				}
			});
                        
                        // Add input validation of message_pscc. //
                        // uncomment once merged with 1.11.3 where filterXSS is added to the project. //
                        
                        $('textarea[name="message_pscc"]').change(function(){
                            $('textarea[name="message_pscc"]').val(filterXSS($('textarea[name="message_pscc"]').val()));
                        });
                        
                        
                        
		}
	};
	
})();


////////////////////////////////////////////////////////////////////////
// NOT YET ORGANIZED
////////////////////////////////////////////////////////////////////////

//previously just a giant mass of code in the window.load function - needs to be broken down and organized
function composeFormIsValid(){
	clearInterval(dpii.compose.changes.interval);

	if($('button#search_btn').attr('clicked') == "true"){ 
		$('button#search').removeAttr('clicked'); 
		return true; 
	}


	if($('#message_body').css('display') == 'none') {
		$('textarea[name="message_body"]').val(editor.getEditorContent()); //need to set textarea content on submit
	}

	//Clear data
	$('#7332_data_question').css("color","");
	$('#7332_auth_question').css("color","");

	var validate = true;
	var message = "";
	if($('textarea[name="message_to"]').val().length === 0 && $('#save_btn').attr('clicked') != 'true') {
			dpii.compose.feedback.setValidation($('#token-input-message_to').parent().parent(), 'Please specify at least one recipient for the To field.');

			$('#token-input-message_to').css("background","none repeat scroll 0 0 #f8e0e0");
			validate = false;
			message += 'At least one recipient must be specified. ';
			$('#token-input-message_to').blur(function(){
				if($('.token-input-token-dpii').length !== 0){
					removeErrorMessage($('#token-input-message_to').parent().parent(),'to');
					$('#token-input-message_to').css('background','');
				}
			});
	}

        var patient_auth_validation_message = dpii.compose.patientauth.get_validation_message(); 
        if (patient_auth_validation_message !== '') { 
            validate = false; 
            message += patient_auth_validation_message; 
        }
       
	if(!validate){
		$("#pros_modal").css('display','none');
		$('.overlay').remove();
		$('#save_btn').removeAttr('clicked');
		$('#send_btn').removeAttr('clicked');
		$('#StatusUpdater').html(message);
		return false;
	}

	if($('p.untrusted').length && $('#save_btn').attr('clicked') != 'true') {
		$("#pros_modal").css('display','none');
		$('.overlay').remove();
		$('#untrusted-dialog').remove();
		var addresses = '';
		var to_remove = [];
		var i = 1;
		var j = 0;
		$('p.untrusted').each(function() {
			addresses += $(this).attr('data-address');
			to_remove[j] = $(this).attr('data-address');
			if(i < $('p.untrusted').length && $('p.untrusted').length > 1) { addresses += ', '; }
			i++;
			j++;
		});
		$('<div id=\"untrusted-dialog\" title="Untrusted Recipients">'+
			'<a class="hidden_context" href="#">Untrusted Recipients</a>'+
			'<p>The following recipients are untrusted: '+addresses+
			'.</p><p>Untrusted recipients must be removed before sending.</p><p>Click "Remove All" to remove all untrusted recipients,'+
			' or "Cancel" to cancel send and review recipients individually.</p>'+
		   '</div>').dialog({
				buttons: [
					{ text: 'Remove All', click : function() {
						var i = 0;
						$(to_remove).each(function() {
							$("#message_to").tokenInput('remove', { id : to_remove[i] });
							$("#message_cc").tokenInput('remove', { id : to_remove[i] });
							i++;
						});
						$(this).dialog('close'); }
					},
					{ text: 'Cancel', click : function() { $(this).dialog('close'); } }
				],
				close: function() { $('#menuContent').focus(); $('#menuContent').removeClass('visible'); }
		   });
		$('#save_btn').removeAttr('clicked');
		$('#send_btn').removeAttr('clicked');
		return false;
	}else if($('p.unvalidated').length && $('#save_btn').attr('clicked') != 'true') {
		$("#pros_modal").css('display','none');
		$('.overlay').remove();
		var addresses = '';
		var i = 1;
		$('p.unvalidated').each(function() {
			addresses += $(this).attr('title');
			if(i < $('p.unvalidated').length && $('p.unvalidated').length > 1) { addresses += ', '; }
			i++;
		});
		if(confirm('The following recipients have not been validated for trust: '+addresses+'. Message will fail to send if any of the unvalidated recipients are not trusted. Attempt to send anyway?')) {
			//do the check for missing subject too if we are planning on sending it anyway
			if($('input[name="message_subject"]').val().length === 0 && $('#save_btn').attr('clicked') != 'true') {
				if(confirm('No subject specified, send anyway?')){
					$("#pros_modal").css('display','inline');
					$(document.body).append("<div class=\"overlay\"></div>");
					return true;
				}
				else{
					$('#send_btn').removeAttr('clicked');
					return false;
				}
			}
			else {
				$("#pros_modal").css('display','inline');
				$(document.body).append("<div class=\"overlay\"></div>");
				return true;
			}
		}
		else {
			$('#send_btn').removeAttr('clicked');
			return false;
		}
	}
	else if($('input[name="message_subject"]').val().length === 0 && $('#save_btn').attr('clicked') != 'true') {
			$("#pros_modal").css('display','none');
			$('.overlay').remove();
			$('#save_btn').removeAttr('clicked');
			if(confirm('You haven\'t specified a subject - would you like to send this message anyway?')){
				$("#pros_modal").css('display','inline');
				$(document.body).append("<div class=\"overlay\"></div>");
				return true;
			}
			else{
				$('#send_btn').removeAttr('clicked');
				return false;
			}
	}
	else if(dpii.compose.attachments.size() > 0) {
		if(dpii.compose.attachments.size() > dpii.compose.attachments.maxSize()) {
			$("#pros_modal").css('display','none');
			$('.overlay').remove();
			dpii.compose.feedback.error('The total attachment size exceeds the '+dpii.compose.attachments.maxSizeForDisplay()+' limit. Please remove attachments before trying again.');
			$('#save_btn').removeAttr('clicked');
			$('#send_btn').removeAttr('clicked');
			return false;
		}
		else {
			return true;
		}
	}
	else if(editor.getEditorContent().toLowerCase().indexOf('attached') >= 0 && $('#save_btn').attr('clicked') != 'true') {
		if($('tr.attach_input').length) {
			if($('tr#attach0').html().length <= 0) {
				$("#pros_modal").css('display','none');
				$('#save_btn').removeAttr('clicked');
				if(confirm('Did you mean to attach files?\n\n You wrote "attached" in your message but have not attached any files, send anyway?')){
					$("#pros_modal").css('display','inline');
					$(document.body).append("<div class=\"overlay\"></div>");
					return true;
				}
				else{
					$('#send_btn').removeAttr('clicked');
					return false;
				}
			}
		}
		else {
			$("#pros_modal").css('display','none');
			$('.overlay').remove();
			$('#save_btn').removeAttr('clicked');
			if(confirm('Did you mean to attach files?\n\n You wrote "attached" in your message but have not attached any files, send anyway?')){
				$("#pros_modal").css('display','inline');
				$(document.body).append("<div class=\"overlay\"></div>");
				return true;
			}
			else{
				return false;
			}
		}
	}
	else { $('#save_btn').removeAttr('clicked'); return true; }			
}



function removeErrorMessage(input ,error_id){
	$('.alert-error.'+error_id).remove();
	input.css("border","");
	input.css("background","");
}

//sets errors message for compose screen
function setErrorMessage(message, input, error_id){
	//showFeedbackForm(message, error_id);
	input.css("background","none repeat scroll 0 0 #f8e0e0");
	input.css("border"," 2px solid #c00");
}


////////////////////////////////////////////////////////////////////////////////////////////////////////
// INITIALIZATION FUNCTIONS - Things that will be run by document.ready when the page is first loaded
////////////////////////////////////////////////////////////////////////////////////////////////////////

function initRichTextEditor(){
	new TINY.editor.edit('editor',{
		id:'message_body',
		title:'Message Body Rich Text Editor',
		width: $("#message_body").css('width'),
		height: $("#message_body").css('height'),
		cssclass:'te',
		controlclass:'tecontrol',
		rowclass:'teheader',
		dividerclass:'tedivider',
		controls:['toggle','|','bold','italic','underline','strikethrough','|','subscript','superscript','|',
				  'orderedlist','unorderedlist','|','outdent','indent','|','leftalign',
				  'centeralign','rightalign','blockjustify','|','unformat','|','undo','redo','n',
				  'font','size','style','|','image','hr','link','unlink','|','cut','copy','paste','print'],
		footer:true,
		fonts:['Verdana','Arial','Georgia','Trebuchet MS'],
		xhtml:true,
		cssfile:'/css/tinyeditor.css',
		bodyid:'editor',
		footerclass:'tefooter',
		toggle:{text:'source',activetext:'wysiwyg',cssclass:'toggle'},
		resize:{cssclass:'resize'},
		entity_encoding : "raw"
	});
	$('textarea[name="message_body"]').val('');
}
