function search(token) {
	var search = $('input[name="address_search_input"]').val();
    search = $('<div/>').html(search).text();
	$.getJSON('/addressbook/ajax_search/' + encodeURIComponent(search) + '/?'+token+'=' + $('input[name="'+token+'"]').val(), function(data) {
		processResult(data,search,token);
	});

}

function activateResult(id,val,enterKeyPressed) {
	if(enterKeyPressed == null) { enterKeyPressed = false; }
	var global = (($('input[name="global"]').val()==='true')?true:false);
	$('.result').removeClass('active');
	$(id).addClass('active');
	var html_str = '';
	if(val.displayname != null) {
		html_str = '<a class="hidden_context hidden_link" href="#" id="addressBookEntry">Address Book Entry for ' + val.displayname + '</a><br />';
		html_str += "<span class=\"active_name\" style=\"font-weight: bold; font-size: 18px\">" + val.displayname + "</span>\n";
		html_str += "<table width=\"300px\">";
		if(val.uid != null) { html_str += "<tr><td></td><td>Alias</td><td>" + val.uid + "</td></tr>"; }
		if(val.mail != null && !global) { html_str += "<tr><td></td><td>Direct Address</td><td><a class=\"active_mail\" href=\"javascript:addMail('" + val.displayname + "','" + val.mail + "');\">" + val.mail + "</a></td></tr>"; }
		else if(val.mail != null  && global) { html_str += "<tr><td></td><td>Direct Address</td><td><a class=\"active_mail\" href=\"javascript:addMailTo_Value('" + val.mail + "');\">" + val.mail + "</a></td><td style=\"padding-top:8px;\"><a class=\"active_mail\" href=\"javascript:addMailTo_Value('" + val.mail + "');\"><img src=\"/images/email.png\" width=\"20px\" alt=\"Compose Message Icon\" /></a></td></tr>"; }
		if(val.physicaldeliveryofficename != null) { html_str += "<tr><td></td><td>Office</td><td>" + val.physicaldeliveryofficename + "</td></tr>"; }
		if(val.telephonenumber != null){ html_str += "<tr><td></td><td>Phone</td><td>" + val.telephonenumber + "</td></tr>"; }
		if(val.title != null) { html_str += "<tr><td></td><td>Job Title</td><td>" + val.title + "</td></tr>"; }
		if(val.departmentnumber != null) { html_str += "<tr><td></td><td>Department</td><td>" + val.departmentnumber + "</td></tr>"; }
		if(val.o != null) { html_str += "<tr><td></td><td>Organization</td><td>" + val.o + "</td></tr>"; }
		html_str += "</table>";
	}
	else if(val.displayname == null && val.name != null) {
		html_str = '<a class="hidden_context hidden_link" href="#" id="addressBookEntry">Address Book Entry for ' + val.name + ' Distribution List</a><br />';
		html_str += '<a class="active_mail" style="display: none;">' + val.alias + '</a>';
		html_str += "<span class=\"active_name\" style=\"font-weight: bold; font-size: 18px\">" + val.name + "</span>\n";
		html_str += '<a class="active_description" style="display: none;">'+val.description+'</a>';
		html_str += '<a class="active_display_names" style="display: none;">'+val.display_names+'</a>';
		html_str += '<a class="active_addresses_in_display_order" style="display: none;">'+val.addresses_in_display_order+'</a>';
		html_str += '<a class="active_address_tokens" style="display: none;">'+val.address_tokens+'</a>';
		html_str += "<table>";
		if(val.addresses != null) {
			var addresses = val.addresses.split(';');
			for (var i = 0; i < addresses.length; i++) {
				html_str += '<tr><td>' + addresses[i] + '</td></tr>';
			}
		}else{
			html_str+='<tr><td>This distribution list does not have any members.</td></tr>';
		}
		html_str += "</table>";
	}
	$('#result_panel').html(html_str);

	$('.hidden_context').focus(function(e) {
		$(e.target).removeClass('hidden_context');
	});
	$('.hidden_context').blur(function(e) {
		$(e.target).addClass('hidden_context');
	});

	//if(enterKeyPressed) { $('#addressBookEntry').focus(); }
	$('#addressBookEntry').focus();
	$('#addressBookEntry').keydown(function(e) {
		var code = (e.keyCode ? e.keyCode : e.which);
		if(code === 9) { //tab keycode
			if(e.shiftKey) {
				$(id).next().focus();
			}
		}
	});
}

function processResult(data, search, token) {
	var items = [];
	var i = 1;
	$.each(data, function(key, val) {
		//alert(key + '--' +val.display_names);
		if(val.displayname != null  && val.mail != null) {
			var push_str = "<img class=\"contact_icon\" src=\"/images/contact_icon.png\" alt=\"Contact Icon\"/>";
			if(i == 1) { push_str += "<a href=\"#\" id=\"result" + i  + "\" class=\"result active\">" + val.displayname; }
			else { push_str += "<a href=\"#\" id=\"result" + i  + "\" class=\"result\">" + val.displayname; }
			if(val.title !=  null && val.departmentnumber != null) { push_str += ("<br />" + val.title + ", " + val.departmentnumber); }
			else if(val.title != null && val.departmentnumber == null && val.o != null) { push_str += ("<br />" + val.title + ", " + val.o); }
			else if(val.title != null) { push_str += "<br />" + val.title; }
			else if(val.departmentnumber != null) { push_str += "<br />" + val.departmentnumber; }
			if(val.telephonenumber !=  null && val.mobile != null) { push_str += ("<br />" + val.telephonenumber + " " + val.mobile); }
			else if(val.telephonenumber != null) { push_str += "<br />" + val.telephonenumber; }
			else if(val.mobile != null) { push_str += "<br />" + val.mobile; }
			push_str += "</a>";
			items.push(push_str);
			if(i === 1) { var id = $("*:focus").attr("id"); activateResult('#result' + i,val); $('#' + id).focus(); } //activate first result on load, preserving focus
			$('body').off('click','#result' + i);
			$('body').off('dblclick','#result' + i);
			$('body').on('click','#result' + i, function(e, enterKeyPressed) {
				if(enterKeyPressed) { activateResult(e.target,val,true); }
				else { activateResult(e.target,val); }
			});
			$('body').on('keydown','#result' + i, function(e) {
			  if(e.keyCode === 13) {
				$(this).trigger('click', true);
				e.preventDefault();
			  }
			});
			$('body').on('dblclick','#result' + i, function(e) {
				addMail(val.displayname, val.mail);
			});
		}
		else if(val.displayname != null) {
			var push_str = "<img class=\"contact_icon\" src=\"/images/list_icon.png\" alt=\"Distribution List Icon\"/>";
			if(i === 1) { push_str += "<a href=\"#\" id=\"result" + i  + "\" class=\"result active\">" + val.displayname; }
			else {  push_str += "<a href=\"#\" id=\"result" + i  + "\" class=\"result\">" + val.displayname; }
			if(val.description !=  null) { push_str += ('<br />' + val.description); }
			items.push(push_str);
			if(i === 1) { var id = $("*:focus").attr("id"); activateResultContacts('#result' + i,val); $('#' + id).focus(); } //activate first result on load, preserving focus
			$('body').off('click','#result' + i);
			$('body').off('dblclick','#result' + i);
			$('body').on('click','#result' + i, function(e,enterKeyPressed) {
				if(enterKeyPressed) { activateResultContacts(e.target,val,true); }
				else { activateResultContacts(e.target,val); }
			});
			$('body').on('keydown','#result' + i, function(e) {
			  if(e.keyCode === 13) {
				$(this).trigger('click', true);
				e.preventDefault();
			  }
			});
			$('body').on('dblclick','#result' + i, function(e) {
				addList(val.displayname, val.alias, val.description, val.display_names, val.addresses_in_display_order, val.address_tokens);
			});
		}
		else if(val.name != null) {
			var push_str = "<img class=\"contact_icon\" alt=\"Distribution List Icon\" src=\"/images/list_icon.png\"/>";
			if(i === 1) { push_str += '<a href="#" id="result' + i  + '" class="result active">' + val.name; }
			else { push_str += '<a href="#" id="result' + i  + '" class="result">' + val.name; }
			if(val.description !=  null) { push_str += ('<br />' + val.description); }
			push_str += '</a>';
			items.push(push_str);
			if(i == 1) { var id = $("*:focus").attr("id"); activateResult('#result' + i,val); $('#' + id).focus(); } //activate first result on load, preserving focus
			$('body').off('click','#result' + i);
			$('body').off('dblclick','#result' + i);
			$('body').on('click','#result' + i, function(e, enterKeyPressed) {
				if(enterKeyPressed) { activateResult(e.target,val,true); }
				else { activateResult(e.target,val); }
			});
			$('body').on('keydown','#result' + i, function(e) {
			  if(e.keyCode === 13) {
				$(this).trigger('click', true);
				e.preventDefault();
			  }
			});
			$('body').on('dblclick','#result' + i, function(e) {
				addList(val.name, val.alias, val.description, val.display_names, val.addresses_in_display_order, val.address_tokens);
			});
		}
		i++;
	});
	if(search != null && $.trim(search) !== '') {
		$('#StatusUpdater').html(""+items.length + ' results found for "' + search);
		$('#result_info').html(items.length + ' results found for "' + search + '" <br /><a href="javascript:clearSearch(\''+token+'\');">Clear Search</a>');
	}
	else if($.trim(search) === '') { $('#result_info').html(""); }
	$('#result_list').html(items.join('\n'));
}

function searchContacts(token) {
	var search = $('input[name="address_search_input"]').val();
	search = $('<div/>').html(search).text();
	$.getJSON('/addressbook/ajax_contact_search/' + encodeURIComponent(search)+'/?'+token+'=' + $('input[name="'+token+'"]').val(), function(data) {
		processResultContacts(data,search,token);
	});

}

function activateResultContacts(id,val,token,enterKeyPressed) {
	var global = (($('input[name="global"]').val()==='true')?true:false);
	if(enterKeyPressed == null) { enterKeyPressed = false; }
	$('.result').removeClass('active');
	$(id).addClass('active');
	if(val.type === 'contact') {
		var html_str = '<a class="hidden_context hidden_link" href="#" id="contactListEntry">Contact List Entry for ' + val.displayname + '</a><br />';
		html_str += "<span class=\"active_name\" title=\""+val.displayname+"\"><span class=\"edit name\" id=\"last_name\">" + val.sn + "</span><span class=\"name\">, </span><span class=\"edit name\" id=\"first_name\">" + val.givenname + "</span></span>";
		if (val.initials != null) {
			html_str += " <span class=\"edit name\" id=\"middle_name\">" + val.initials + "</span>";
		}
		html_str += "<table>";
		if (val.mail == null) {
			val.mail = '';
		}
		if (!global) {
			html_str += "<tr><td></td><td>Direct Address</td><td class=\"entry_value\" title=\""+val.mail+"\"><span class=\"edit active_mail\" style=\"display: none;\" id=\"mail\">" + val.mail + "</span><a class=\"active_mail\" href=\"javascript:addMail('" + val.displayname + "','" + val.mail + "');\">" + val.mail + "</a></td><td><button aria-label='Edit Direct Address' onclick=\"$('#mail').trigger('edit_contact');\">Edit</button></td></tr>";
		} else if (global) {
			html_str += "<tr><td></td><td>Direct Address</td><td class=\"entry_value\" title=\""+val.mail+"\"><span class=\"edit active_mail\" style=\"display: none;\" id=\"mail\">" + val.mail + "</span><a class=\"active_mail\" href=\"javascript:addMailTo_Value('" + val.mail + "');\">" + val.mail + "</a></td><td><button aria-label='Edit Direct Address' onclick=\"$('#mail').trigger('edit_contact');\">Edit</button></td></tr>";
		}
		if (val.telephonenumber == null){
			val.telephonenumber = '';
		}
		html_str += "<tr><td></td><td>Phone</td><td class=\"edit entry_value\" id=\"telephone\" title=\""+val.telephonenumber+"\">" + val.telephonenumber + "</td><td><button aria-label='Edit Phone' onclick=\"$('#telephone').trigger('edit_contact');\">Edit</button></td></tr>";
		if (val.title == null) {
			val.title ='';
		}
		html_str += "<tr><td></td><td>Job Title</td><td class=\"edit entry_value\" id=\"title\" title=\""+val.title+"\">" + val.title + "</td><td><button aria-label='Edit Job Title' onclick=\"$('#title').trigger('edit_contact');\">Edit</button></td></tr>";
		if (val.departmentnumber == null) {
			val.departmentnumber = '';
		}
		html_str += "<tr><td></td><td>Department</td><td class=\"edit entry_value\" id=\"department\" title=\""+val.departmentnumber+"\">" + val.departmentnumber + "</td><td><button aria-label='Edit Department' onclick=\"$('#department').trigger('edit_contact');\">Edit</button></td></tr>";
		if (val.o == null) {
			val.o = '';
		}
		html_str += "<tr><td></td><td>Organization</td><td class=\"edit entry_value\" id=\"organization\" title=\""+val.o+"\">" + val.o + "</td><td><button aria-label='Edit Organization' onclick=\"$('#organization').trigger('edit_contact');\">Edit</button></td></tr>";
		html_str += "</table>";
		html_str += "<br /><br /><a onclick=\"return confirm('Are you sure you want to delete this contact?');\" href=\"javascript:deleteContact('" + val.cid + "','" + token + "', '"+document.getElementById('LocationGlobal').value+"');\">Delete Contact</a>";
		$('#result_panel').html(html_str);

		$('.hidden_context').focus(function(e) {
			$(e.target).removeClass('hidden_context');
		});
		$('.hidden_context').blur(function(e) {
			$(e.target).addClass('hidden_context');
		});

		//if(enterKeyPressed) { $('#contactListEntry').focus(); }
		$('#contactListEntry').focus();
		$('#contactListEntry').keydown(function(e) {
			var code = (e.keyCode ? e.keyCode : e.which);
			if(code === 9) { //tab keycode
				if(e.shiftKey) {
					$(id).next().focus();
				}
			}
		});

		if($('.edit').length) {
			$('.edit').not('.name, span.active_mail').each(function() {
				$(this).editable('/addressbook/edit_contact/' + val.cid,{
					data: function(value) { return html_entity_decode(value); },
					event: 'edit_contact',
					height: 15,
					width: 'auto',
					onblur : 'submit',
					submitdata: function ( value, settings ) {
						//Send token as Post
						var data = {};
						data[token] = $('input[type="hidden"].token').val();
						return data
					},
					onsubmit: function(settings, original) {
						let input=$(original).find('input');
						$("#"+original.id).html(input);
						let input_val = $('<div/>').html(input.val()).text();
						$("#"+original.id).attr('title', input_val);
						if(original.id === "telephone") { val.telephonenumber = input_val; }
						else if(original.id === "title") { val.title = input_val; }
						else if(original.id === "department") { val.departmentnumber = input_val; }
						else if(original.id === "organization") { val.o = input_val; }
						resetResult(id,val);
					},
					indicator : 'Saving...',
					placeholder: '',
					callback: function(){$('#address_search_input').focus();$(id).focus();}
				});
			});
			$('#mail').bind('edit_contact', function() {
				$('span.edit.active_mail').css('display','block');
				$('a.active_mail').css('display','none');
			});
			$('.edit.active_mail').each(function() {
				$(this).editable('/addressbook/edit_contact/' + val.cid,{
					data: function(value) { return html_entity_decode(value); },
					event: 'edit_contact',
					height: 15,
					width: 'auto',
					onblur : 'submit',
					submitdata: function ( value, settings ) {
						//Send token as Post
						var data = {};
						data[token] = $('input[type="hidden"].token').val();
						return data
					},
					onsubmit: function(settings, original) {
						$('span.edit.active_mail').css('display','none');
						$('a.active_mail').css('display','inline');
						$('a.active_mail').html('Saving...');
						let input = $(original).find('input');
                        let input_val = $('<div/>').html(input.val()).text();
						if(input_val.length <= 0) { input.val(original.revert); }
						val.mail = input_val;
						$('a.active_mail').attr('href',"javascript:addMail('" + val.displayname + "','" + val.mail + "');");
						document.getElementById('mail').parentNode.title = val.mail;
						return true;
					},
					callback : function(value, settings) {
						//replace href js with correct value by pulling it from the parent title, which is the old value until we change it at the end of this function
						$('a.active_mail').attr('href',$('a.active_mail').attr('href').replace($('a.active_mail').parent().attr('title'),value));
						$('a.active_mail').html(value);
						$('a.active_mail').parent().attr('title',value);
						$('#address_search_input').focus();
						$(id).focus();
					},
					indicator : 'Saving...',
					placeholder: ''
				});
			});
			$('.edit.name').each(function() {
				$(this).editable('/addressbook/edit_contact/'+ val.cid,{
					data: function(value) { return html_entity_decode(value); },
					event: 'click',
					height: 15,
					width: 'auto',
					onblur : 'submit',
					submitdata: function ( value, settings ) {
						//Send token as Post
						var data = {};
						data[token] = $('input[type="hidden"].token').val();
						return data
					},
					onsubmit: function(settings, original) {
						let input = $(original).find('input');
                        let input_val = $('<div/>').html(input.val()).text();
						if(input_val.length <= 0) { input.val(original.revert);  }
						if(original.id === "first_name") { val.givenname = input_val; }
						else if(original.id === "last_name") { val.sn = input_val; }
						else { val.initials = input_val; }
						val.displayname = (val.initials ? "" + val.sn + ", " + val.givenname + " " + val.initials : "" + val.sn + ", " + val.givenname);
						$('#contactListEntry').html('Contact List Entry for '+val.displayname);
						resetResult(id,val);
						document.getElementById('first_name').parentNode.title = val.displayname;
						$('a.active_mail').attr('href',"javascript:addMail('" + val.displayname + "','" + val.mail + "');");
						return true;
					},
					indicator : 'Saving...',
					placeholder: '',
					callback: function(){$('#address_search_input').focus();$(id).focus();}
				});
			});
		}
	}
	else if(val.type === 'list') {
		var html_str = '<a class="active_mail" style="display: none;">'+val.alias+'</a>';
		html_str += '<a class="hidden_context hidden_link" href="#" id="contactListEntry">Distribution List Entry for ' + val.displayname + '</a>';
		html_str += '<a class="active_name" style="display: none;">'+val.displayname+'</a>';
		html_str += '<a class="active_description" style="display: none;">'+val.description+'</a>';
		html_str += '<a class="active_display_names" style="display: none;">'+val.display_names+'</a>';
		html_str += '<a class="active_addresses_in_display_order" style="display: none;">'+val.addresses_in_display_order+'</a>';
		html_str += '<a class="active_address_tokens" style="display: none;">'+val.address_tokens+'</a>';
		html_str += '<h2>' + val.displayname + '</h2><br/>';
		html_str += "<table id=\"list_address_table\"><tr>";
		html_str += '<th><a href="javascript:editDistList('+val.id+',\''+token+'\',\''+document.getElementById('LocationGlobal').value+'\')"> Edit List</a></th>';
		html_str += '<th><a style= "float:right;" href="javascript:deleteList('+val.id+',\''+token+'\',\''+document.getElementById('LocationGlobal').value+'\');" onclick="return confirm(\'Are you sure you want to delete this list?\');"> Delete List</a></th>';
		html_str += "</tr></table id=\"list_address_table\">";
		if(typeof val.addresses !== "undefined"){
			html_str += "<table id=\"list_address_table\">";
			var addresses = val.addresses.split(';');
			for(var i = 0; i < addresses.length; i++) {
				if(addresses[i].length > 0) {
					if(i%2 === 0){
						html_str += '<tr>';
					}
					else{
						html_str += '<tr class="alt">'
					}
					html_str += '<td>' + addresses[i] + '</td></tr>';
				}
			}
			html_str += "</table>";
		}


		$('#result_panel').html(html_str);
		$('#contactListEntry').focus();
		$('#contactListEntry').keydown(function(e) {
			var code = (e.keyCode ? e.keyCode : e.which);
			if(code === 9) { //tab keycode
				if(e.shiftKey) {
					$(id).next().focus();
				}
			}
		});
	}
	else if(val.type === 'admin_contact') {
		var html_str = '<a class="hidden_context hidden_link" href="#" id="contactListEntry">Global Contact List entry for '+val.displayname+'</a><br />';
		html_str += "<span class=\"name\" id=\"last_name\">" + val.sn + "</span><span class=\"name\">, </span><span class=\"name\" id=\"first_name\">" + val.givenname + "</span></span>";
		if(val.initials != null) { html_str += " <span class=\"name\" id=\"middle_name\">" + val.initials + "</span>"; }
		html_str += '<a class="active_name" style="display: none;">'+val.displayname+'</a>';
		html_str += "<table>";
		if(val.mail == null) { val.mail = ''; }
		if(!global) { html_str += "<tr><td></td><td>Direct Address</td><td class=\"entry_value\" title=\""+val.mail+"\"><span class=\"active_mail\" style=\"display: none;\" id=\"mail\">" + val.mail + "</span><a class=\"active_mail\" href=\"javascript:addMail('" + val.displayname + "','" + val.mail + "');\">" + val.mail + "</a></td></tr>"; }
		else if(global) { html_str += "<tr><td></td><td>Direct Address</td><td class=\"entry_value\" title=\""+val.mail+"\"><span class=\"active_mail\" style=\"display: none;\" id=\"mail\">" + val.mail + "</span><a class=\"active_mail\" href=\"javascript:addMailTo_Value('" + val.mail + "');\">" + val.mail + "</a></td></tr>"; }
		if(val.telephonenumber == null){ val.telephonenumber = ''; }
		html_str += "<tr><td></td><td>Phone</td><td class=\"entry_value\" id=\"telephone\" title=\""+val.telephonenumber+"\">" + val.telephonenumber + "</td>";
		if(val.title == null) { val.title =''; }
		html_str += "<tr><td></td><td>Job Title</td><td class=\"entry_value\" id=\"title\" title=\""+val.title+"\">" + val.title + "</td>";
		if(val.departmentnumber == null) { val.departmentnumber = ''; }
		html_str += "<tr><td></td><td>Department</td><td class=\"entry_value\" id=\"department\" title=\""+val.departmentnumber+"\">" + val.departmentnumber + "</td>";
		if(val.o == null) { val.o = ''; }
		html_str += "<tr><td></td><td>Organization</td><td class=\"entry_value\" id=\"organization\" title=\""+val.o+"\">" + val.o + "</td>";
		html_str += "</table>";
		$('#result_panel').html(html_str);

		$('.hidden_context').focus(function(e) {
			$(e.target).removeClass('hidden_context');
		});
		$('.hidden_context').blur(function(e) {
			$(e.target).addClass('hidden_context');
		});

		$('#contactListEntry').focus();
		$('#contactListEntry').keydown(function(e) {
			var code = (e.keyCode ? e.keyCode : e.which);
			if(code === 9) { //tab keycode
				if(e.shiftKey) {
					$(id).next().focus();
				}
			}
		});
	}
}

function processResultContacts(data,search,token) {
	var items = [];
	var i = 1;
	$.each(data, function(key, val) {
		if(val.displayname != null && val.type === 'contact') {
			var push_str = "<img class=\"contact_icon\" alt=\"Contact List Icon\" src=\"/images/contact_icon.png\"/>";
			if(i === 1) { push_str += "<a href=\"#\" id=\"result" + i  + "\" class=\"result active\">" + val.displayname; }
			else {  push_str += "<a href=\"#\" id=\"result" + i  + "\" class=\"result\">" + val.displayname; }
			if(val.title !=  null && val.departmentnumber != null) { push_str += ("<br />" + val.title + ", " + val.departmentnumber); }
			else if(val.title != null && val.departmentnumber == null && val.o != null) { push_str += ("<br />" + val.title + ", " + val.o); }
			else if(val.title != null) { push_str += "<br />" + val.title; }
			else if(val.departmentnumber != null) { push_str += "<br />" + val.departmentnumber; }
			if(val.telephonenumber !=  null && val.mobile != null) { push_str += ("<br />" + val.telephonenumber + " " + val.mobile); }
			else if(val.telephonenumber != null) { push_str += "<br />" + val.telephonenumber; }
			else if(val.mobile != null) { push_str += "<br />" + val.mobile; }
			push_str += "</a>";
			items.push(push_str);
			if(i === 1) { var id = $("*:focus").attr("id"); activateResultContacts('#result' + i,val,token); $('#' + id).focus(); } //activate first result on load, preserving focus
			$('body').off('click','#result' + i);
			$('body').off('dblclick','#result' + i);
			$('body').on('click','#result' + i, function(e,enterKeyPressed) {
				if(enterKeyPressed) { activateResultContacts(e.target,val,token,true); }
				else { activateResultContacts(e.target,val,token); }
			});
			$('body').on('keydown','#result' + i, function(e) {
			  if(e.keyCode === 13) {
				$(this).trigger('click', true);
				e.preventDefault();
			  }
			});
			$('body').on('dblclick','#result' + i, function(e) {
				addMail(val.displayname, val.mail);
			});
		}
		if(val.displayname != null && val.type === 'list') {
			var push_str = "<img class=\"contact_icon\" alt=\"Distribution List Icon\" src=\"/images/list_icon.png\"/>";
			if(i === 1) { push_str += "<a href=\"#\" id=\"result" + i  + "\" class=\"result active\">" + val.displayname; }
			else {  push_str += "<a href=\"#\" id=\"result" + i  + "\" class=\"result\">" + val.displayname; }
			if(val.description !=  null) { push_str += ('<br />' + val.description); }
			push_str+='</a>';
			items.push(push_str);
			if(i === 1) { var id = $("*:focus").attr("id"); activateResultContacts('#result' + i,val,token); $('#' + id).focus(); } //activate first result on load, preserving focus
			$('body').off('click','#result' + i);
			$('body').off('dblclick','#result' + i);
			$('body').on('click','#result' + i, function(e,enterKeyPressed) {
				if(enterKeyPressed) { activateResultContacts(e.target,val,token,true); }
				else { activateResultContacts(e.target,val,token); }
			});
			$('body').on('keydown','#result' + i, function(e) {
			  if(e.keyCode === 13) {
				$(this).trigger('click', true);
				e.preventDefault();
			  }
			});
			$('body').on('dblclick','#result' + i, function(e) {
				addList(val.displayname, val.alias, val.description, val.display_names, val.addresses_in_display_order, val.address_tokens);
			});
		}
		if(val.displayname != null && val.type === 'admin_contact') {
			var push_str = "<img class=\"contact_icon\" src=\"/images/icons/world.png\" alt=\"Global Contact Icon\"/>";
			if(i === 1) { push_str += "<a href=\"#\" id=\"result" + i  + "\" class=\"result active\">" + val.displayname; }
			else {  push_str += "<a href=\"#\" id=\"result" + i  + "\" class=\"result\">" + val.displayname; }
			if(val.title !=  null && val.departmentnumber != null) { push_str += ("<br />" + val.title + ", " + val.departmentnumber); }
			else if(val.title != null && val.departmentnumber == null && val.o != null) { push_str += ("<br />" + val.title + ", " + val.o); }
			else if(val.title != null) { push_str += "<br />" + val.title; }
			else if(val.departmentnumber != null) { push_str += "<br />" + val.departmentnumber; }
			if(val.telephonenumber !=  null && val.mobile != null) { push_str += ("<br />" + val.telephonenumber + " " + val.mobile); }
			else if(val.telephonenumber != null) { push_str += "<br />" + val.telephonenumber; }
			else if(val.mobile != null) { push_str += "<br />" + val.mobile; }
			push_str += "</a>";
			items.push(push_str);
			if(i === 1) { var id = $("*:focus").attr("id"); activateResultContacts('#result' + i,val,token); $('#' + id).focus(); } //activate first result on load, preserving focus
			$('body').off('click','#result' + i);
			$('body').off('dblclick','#result' + i);
			$('body').on('click','#result' + i, function(e,enterKeyPressed) {
				if(enterKeyPressed) { activateResultContacts(e.target,val,token,true); }
				else { activateResultContacts(e.target,val,token); }
			});
			$('body').on('keydown','#result' + i, function(e) {
			  if(e.keyCode === 13) {
				$(this).trigger('click', true);
				e.preventDefault();
			  }
			});
			$('body').on('dblclick','#result' + i, function(e) {
				if(window.address_field === "To") {
					var preserve = $('textarea[name="modal_message_to"]').val().substring(0,$('textarea[name="modal_message_to"]').val().lastIndexOf(';') + 1);
					preserve = $.trim(preserve);
					$('textarea[name="modal_message_to"]').val(preserve + '"' + $.trim(val.displayname) + '" <' + $.trim(val.mail) + '>;');
					$('textarea[name="modal_message_to"]').val($('textarea[name="modal_message_to"]').val().replace(/[\r\n]+$/, ''));
					$('textarea[name="modal_message_to"]').focus();
				}
				if(window.address_field === "CC") {
					var preserve = $('textarea[name="modal_message_cc"]').val().substring(0,$('textarea[name="modal_message_cc"]').val().lastIndexOf(';') + 1);
					preserve = $.trim(preserve);
					$('textarea[name="modal_message_cc"]').val(preserve + '"' + $.trim(val.displayname) + '" <' + $.trim(val.mail) + '>;');
					$('textarea[name="modal_message_cc"]').val($('textarea[name="modal_message_cc"]').val().replace(/[\r\n]+$/, ''));
					$('textarea[name="modal_message_cc"]').focus();
				}
			});
		}
		i++;
	});
	if(search != null && $.trim(search) !== '') {
		$('#StatusUpdater').html(""+items.length + ' results found for "' + search);
		$('#result_info').html(items.length + ' results found for "' + search + '" <br /><a href="javascript:clearContactSearch(\''+token+'\');">Clear Search</a>');
	}
	else if($.trim(search) === '') { $('#result_info').html(""); }
	$('#result_list').html(items.join('\n'));
}
function resetResult(id,val){
	var push_str =  val.displayname;
	if(val.title  && val.departmentnumber ) { push_str += ("<br />" + val.title + ", " + val.departmentnumber); }
	else if(val.title  && !val.departmentnumber  && val.o) { push_str += ("<br />" + val.title + ", " + val.o); }
	else if(val.title) { push_str += "<br />" + val.title; }
	else if(val.departmentnumber) { push_str += "<br />" + val.departmentnumber; }
	if(val.telephonenumber  && val.mobile ) { push_str += ("<br />" + val.telephonenumber + " " + val.mobile); }
	else if(val.telephonenumber) { push_str += "<br />" + val.telephonenumber; }
	else if(val.mobile ) { push_str += "<br />" + val.mobile; }
	$(id).html(push_str);

}

function clearSearch(token) {
	$('#result_info').html("");
	$('#result_list').html("");
	$('#result_panel').html("");
	$('input[name="address_search_input"]').val("");
	$('input[name="address_search_input"]').focus();
	search(token);
}

function clearContactSearch(token) {
	$('#result_info').html("");
	$('#result_list').html("");
	$('#result_panel').html("");
	$('input[name="address_search_input"]').val("");
	$('input[name="address_search_input"]').focus();
	searchContacts(token);
}

function addMail(name,mail) {
	if(window.address_field === "To") {
		$('#modal_message_to').tokenInput('add', {id: $.trim(mail), name: $.trim(name) });
		$('textarea[name="modal_message_to"]').focus();
	}
	if(window.address_field === "CC") {
		$('#modal_message_cc').tokenInput('add', {id: $.trim(mail), name: $.trim(name) });
		$('textarea[name="modal_message_to"]').focus();
	}
}

function addList(name, alias, description, display_names, addresses_in_display_order, active_address_tokens) {
	if(window.address_field === "To") {
		$('#modal_message_to').tokenInput('add', {id: $.trim(alias), name: $.trim(name), description: $.trim(description), display_names: $.trim(display_names), addresses_in_display_order: $.trim(addresses_in_display_order), address_tokens: $.trim(active_address_tokens)});
		$('textarea[name="modal_message_to"]').focus();
	}
	if(window.address_field === "CC") {
		$('#modal_message_cc').tokenInput('add', {id: $.trim(alias), name: $.trim(name), description: $.trim(description), display_names: $.trim(display_names), addresses_in_display_order: $.trim(addresses_in_display_order), address_tokens: $.trim(active_address_tokens)});
		$('textarea[name="modal_message_cc"]').focus();
	}
}

function addModalTo() {
	window.address_field = "To";
	if($('a.active_description').text() != null && $('a.active_description').text() !== '') {
		$('#modal_message_to').tokenInput('add', {id: $.trim($('a.active_mail').text()), name: $.trim($('.active_name').text()), description: $.trim($('.active_description').text()), display_names: $.trim($('.active_display_names').text()), addresses_in_display_order: $.trim($('.active_addresses_in_display_order').text()), address_tokens: $.trim($('.active_address_tokens').text())});
	}
	else{
		$('#modal_message_to').tokenInput('add', {id: $.trim($('a.active_mail').text()), name: $.trim($('.active_name').text()) });
	}
	$('textarea[name="modal_message_to"]').focus();
}

function addModalCC() {
	window.address_field = "CC";
	if($('a.active_description').text() != null && $('a.active_description').text() != '') {
		$('#modal_message_cc').tokenInput('add', {id: $.trim($('a.active_mail').text()), name: $.trim($('.active_name').text()), description: $.trim($('.active_description').text()), display_names: $.trim($('.active_display_names').text()), addresses_in_display_order: $.trim($('.active_addresses_in_display_order').text()), address_tokens: $.trim($('.active_address_tokens').text())});
	}
	else{
		$('#modal_message_cc').tokenInput('add', {id: $.trim($('a.active_mail').text()), name: $.trim($('.active_name').text()) });
	}
	$('textarea[name="modal_message_cc"]').focus();
}

function addNewContact(token, location) {
	$.fancybox.showActivity();
	$.ajax({
			url : '/addressbook/add_contact/?location='+location+'&'+token+'=' + $('input[name="'+token+'"]').val()
	}).done(function(data){
		if(data.indexOf('<!-- AUTH -->') >=0 || data.indexOf('<!-- ERROR -->') >=0) {
			window.location = '/auth/logout';
		}else{
			$.fancybox.hideActivity();
			$('#fancybox-content').html(data);
			$('#fancybox-title').css({ display: 'none' });
			$('#first_name').focus();
		}
	});
}

function addMailTo_Value(email){
	//Send email to function redirectCompose and re pass to compose email
	window.location = '/inbox/redirectCompose?mail='+email;
}

function addNewDistList(token, location) {
	function _trapFocusFor508(e) {
		var TAB_KEY = 9;
		var keyPressed = e.which || e.keyCode;
		var $firstEl = $('#list_display_name');
		var $lastEl = $('#fancybox-close');

		// Forward
		if (keyPressed === TAB_KEY && !e.shiftKey) {
			if (e.target.id === 'fancybox-close') {
				e.preventDefault();
				$firstEl.focus();
			}
		}

		// Backward
		if (keyPressed === TAB_KEY && e.shiftKey) {
			if (e.target.id === 'list_display_name') {
				e.preventDefault();
				$lastEl.focus();
			}
		}
	}

	$.fancybox.showActivity();
	$.ajax({
			url : '/inbox/create_list/?location='+location+'&'+token+'=' + $('input[name="'+token+'"].token').val()
	}).done(function(data){
		$.fancybox.hideActivity();
		if(data.indexOf('<!-- AUTH -->') >=0 || data.indexOf('<!-- ERROR -->') >=0) {
			window.location = '/auth/logout';
		}
		else{
			$('#fancybox-content').html(data);
			$('#fancybox-title').css({ display: 'none' });
			$('#list_display_name').focus();
			$('#fancybox-close').attr({
				href: '#',
				role: 'button',
				'aria-label': 'Close'
			});

			var $fancybox_wrap = $('#fancybox-wrap');
			$fancybox_wrap.off('keydown');
			$fancybox_wrap.on('keydown', _trapFocusFor508);

		}
	});

}

function editDistList(display, token, location) {
	function _trapFocusFor508(e) {
		var TAB_KEY = 9;
		var keyPressed = e.which || e.keyCode;
		var $firstEl = $('#list_display_name');
		var $lastEl = $('#fancybox-close');

		// Forward
		if (keyPressed === TAB_KEY && !e.shiftKey) {
			if (e.target.id === 'fancybox-close') {
				e.preventDefault();
				$firstEl.focus();
			}
		}

		// Backward
		if (keyPressed === TAB_KEY && e.shiftKey) {
			if (e.target.id === 'list_display_name') {
				e.preventDefault();
				$lastEl.focus();
			}
		}
	}

	$.fancybox.showActivity();
	$.ajax({
			url : '/inbox/edit_list/'+display+'?location='+location+'&'+token+'='+$('input[name="'+token+'"].token').val()
	}).done(function(data){
		$.fancybox.hideActivity();
		if(data.indexOf('<!-- AUTH -->') >=0 || data.indexOf('<!-- ERROR -->') >=0) {
			window.location = '/auth/logout';
		} else {
			$('#fancybox-content').html(data);
			$('#add_dist_list').attr({ role: 'dialog' });
			$('#fancybox-title').css({ display: 'none' });
			$('#list_display_name').focus();
			$('#fancybox-close').attr({
				href: '#',
				role: 'button',
				'aria-label': 'Close'
			});

			var $fancybox_wrap = $('#fancybox-wrap');
			$fancybox_wrap.off('keydown');
			$fancybox_wrap.on('keydown', _trapFocusFor508);
		}
	});
}

function deleteContact(cid, token, location) {
	$.fancybox.showActivity();
	$.ajax({
		url : '/addressbook/delete_contact/' + cid + '?'+token+'=' + $('input[name="'+token+'"]').val(),
	}).done(function() {
		var is_global = (location === 'GlobalPersonalAddress') ? true : false;
		var contacts_list_data = is_global ? 'GlobalPersonalAddress' : 'return';
		loadContactsList(contacts_list_data, token, is_global);
		$('#fancybox-outer').noty({
			theme: 'inlineTheme',
			text: 'Contact successfully deleted.',
			type: 'success',
			timeout: 5000
		});
	});
}

function loadContactsList(data, token, is_global) {
	// Default to false if 'is_global' parameter is not set.
	is_global = is_global || false;
	$.fancybox.showActivity();
	if(data == null) {
		if(!is_global) {
			$.ajax({
				url : '/addressbook/contacts/?'+token+'=' + $('input[name="'+token+'"]').val()
			}).done(function(data){ createContactsBox(data,'reload', is_global); });
		}
		else {
			$.ajax({
				url : '/addressbook/mainContacts/?'+token+'=' + $('input[name="'+token+'"]').val()
			}).done(function(data){ createContactsBox(data,'reload', is_global); });
		}
	}
	else if(data === 'return') {
		if(!is_global) {
			$.ajax({
				url : '/addressbook/contacts/?'+token+'=' + $('input[name="'+token+'"]').val()
			}).done(function(data){ createContactsBox(data,'return', is_global); });
		}
		else {
			$.ajax({
				url : '/addressbook/mainContacts/?'+token+'=' + $('input[name="'+token+'"]').val()
			}).done(function(data){ createContactsBox(data,'return', is_global); });
		}
	}
	else if(data === 'GlobalPersonalAddress') {
		$.ajax({
			url : '/addressbook/mainContacts/?'+token+'=' + $('input[name="'+token+'"]').val()
		}).done(function(data){ createContactsBox(data,'GlobalPersonalAddress', is_global); });
	}
	else {
		if($(data).find('#result_list').length) {
			createContactsBox(data,'formSubmitResult', is_global);
		} else {
			createContactsBox(data,'validationError', is_global);
		}
	}
}

function createContactsBox(data,type) {
	var global = (($('input[name="global"]').val()=='true')?true:false);
	if(!global) {
		var title = '<div id="footer"><div id="address_list">' +
				'<table><tr><td><button onclick="addModalTo()">To &#8594;</button></td>' +
				'<td><label for="modal_message_to" style="display:none;">To</label>' +
				'<textarea class="expand" name="modal_message_to" id="modal_message_to"></textarea></td></tr>' +
				'<tr><td><button onclick="addModalCC()">CC &#8594;</button></td>' +
				'<td><label for="modal_message_cc" style="display:none;">CC</label>' +
				'<textarea class="expand" name="modal_message_cc" id="modal_message_cc"></textarea></td></tr>' +
				'</table>' +
				'<div style="float: right; padding: 5px;">' +
				'<button type="button" onclick="useAddressList();">OK</button>' +
				'<button type="button" onclick="cancelAddressList()" id="cancel_button">Cancel</button></div></div></div>';
	} else {
		var title = '';
	}

	var parameters = {
		'content' : data,
		'autoDimensions' : false,
		'height' : 500,
		'width' : 750,
		'padding' : 1,
		'titlePosition' : 'inside'
	};

	function _restoreFocus() {
		if (window.__dsm_focus_return_element && window.__dsm_focus_return_element.focus) {
			window.__dsm_focus_return_element.focus();
			window.__dsm_focus_return_element = undefined;
		} else {
			$('#personal_contacts_list_link').focus();
		}
	}

	if (type === 'reload') {
		parameters.onComplete = function () {
			$('#add_contact_link').focus();
		}
	} else if (type === 'GlobalPersonalAddress') {
		return getPersonalAddressBook();
	} else if (type === 'return') {
		parameters.title = title;
		parameters.onComplete = function() {
			$('#add_contact_link').focus();
			initContactBox();
		};
	} else if (type === 'formSubmitResult') {
		parameters.title = title;
		parameters.onComplete = function() {
			initContactBox();
		};
	} else if (type === 'validationError'){
		parameters.onComplete = function() {
			if ($('#validation_errors').length) {
				$('#validation_errors').focus();
			} else {
				$('#first_name').focus();
			}
		};
	}
	parameters.onClosed = _restoreFocus;
	$.fancybox(parameters);
}

function initContactBox() {
	$("#modal_message_to, #modal_message_cc").tokenInput("/inbox/get_contacts_search/",
	{
		theme: "dpii",
		searchDelay: 500,
		hintText: "Enter a Direct address",
		tokenDelimiter: ";",
		onAdd: function(e) { multipleAddressSplit(e); },
		noResultsText: "This is not a trusted address",
		resultsFormatter: function(item){
			if(item.description == null) {
				return "<li>" + "<div style='display: inline-block; padding-left: 10px;'><div class='full_name'>" + " " + item.name + "</div><div class='email'>" + item.id + "</div></div></li>"
			}
			else {
				return "<li>" + "<div style='display: inline-block; padding-left: 10px;'><div class='full_name'>" + " " + item.name + "</div><div class='email'>" + item.description + "</div></div></li>"
			}
		},
		tokenFormatter: function(item) { item.uid = uniqid();
			if(item.description == null) {
				return "<li class=\"unvalidated\"><p class=\"unvalidated\" id=\""+item.uid+"\" title=\"" + item.id + "\" data-address=\""+item.id+"\">" + item.name + "</p></li>"
			}
			else{
				return "<li class=\"unvalidated\"><p class=\"unvalidated\" id=\""+item.uid+"\" title=\"" + item.description + "\" data-address=\""+item.id+"\">" + item.name + "</p></li>"
			}
		}
	});
}

function deleteList(id, token, location) {
	var is_global = (location === 'GlobalPersonalAddress') ? true : false;
	$.fancybox.showActivity();
	$.ajax({
		url : '/inbox/remove_list/' + id + '?location='+ location + '&' + token + '=' + $('input[name="'+token+'"]').val()
	}).done(function(data) {
		loadContactsList('return', token, is_global);
		$('#fancybox-outer').noty({
			theme: 'inlineTheme',
			text: 'List successfully deleted.',
			type: 'success',
			timeout: 5000
		});
	});
}
