<?PHP
/**
 * @package direct-project-innovation-initiative
 * @subpackage views
 * @filesource
 */ /** */

$this->load->view('header/header_settings');
$validation_errors = $this->session->flashdata('validation_errors');
$form_data = $this->session->flashdata('form_data');
?>

<script>
	function initRichTextEditor(){
		new TINY.editor.edit('editor',{
			id:'message_body',
			title:'Message Body Rich Text Editor',
			width: $("#message_body").css('width'),
			height: $("#message_body").css('height'),
			cssclass:'te',
			controlclass:'tecontrol',
			rowclass:'teheader',
			dividerclass:'tedivider',
			controls:['toggle','|','bold','italic','underline','strikethrough','|','subscript','superscript','|',
					  'orderedlist','unorderedlist','|','outdent','indent','|','leftalign',
					  'centeralign','rightalign','blockjustify','|','unformat','|','undo','redo','n',
					  'font','size','style','|','image','hr','link','unlink','|','cut','copy','paste','print'],
			footer:true,
			fonts:['Verdana','Arial','Georgia','Trebuchet MS'],
			xhtml:true,
			cssfile:'/css/tinyeditor.css',
			bodyid:'editor',
			footerclass:'tefooter',
			toggle:{text:'source',activetext:'wysiwyg',cssclass:'toggle'},
			resize:{cssclass:'resize'},
			entity_encoding : "raw"
		});	
	}
</script>
				<a class="hidden_context hidden_link" name="menuContent" id="menuContent">Menu</a>
				<a class="hidden_context hidden_link" name="menuContent" id="skipAdminMenu" href="#mainContent">Skip Menu</a>
				<div id="admin_menu">
					<div class="menuwrap">
						<div class="tab"><a href="/settings">Account Settings</a></div>
					</div>
					<div class="menuwrap">
						<div class="tab"><a href="/settings/notifications">Notification Settings</a></div>
					</div>
					<div class="menuwrap">
						<div class="tab"><a href="/settings/application">Application Settings</a></div>
					</div>
					<div class="menuwrap">
						<div class="tab active"><a href="/settings/automatic_replies">Automatic Replies</a></div>
					</div>
				</div>
			</div>
			
			<div class="content_settings">
						
			<?PHP  echo form_open("/settings/update_automatic_replies", array('onsubmit' => 'mainFormOnSubmit()')); ?>			
				<div class="settings">
				<?php if(!empty($validation_errors)): ?>
					<div id="date_error" class="message_error bootstrap">
						<button type='button' class='close' data-dismiss='alert' aria-label='Close'><span aria-hidden='true'>&times;</span></button>	
						<?php echo implode('<br>', $validation_errors) ?>					
					</div>
				<?php endif ?>
			
				<h2>Automatic Replies</h2>
				<span>Use automatic replies to let others know that you are out of the office or not available to repond to messages.</span>
				
			<table role="presentation" name="automatic_replies_table" id="automatic_replies_table" class="bootstrap">
				<tr>
					<td colspan="2"><input type="radio" name="automatic_replies" class="radioBtn" id="automatic_replies" value="0" <?php if((isset($form_data['automatic_replies']) && ($form_data['automatic_replies'] == "0")) || empty($content))  {echo 'checked=\"checked\"';} ?>  /> <label for="automatic_replies">Do not send automatic replies</label>
						
					</td>
				</tr>
				<tr>
					<td colspan="2" ><input type="radio" name="automatic_replies" class="radioBtn" id="automatic_replies"  value="1" <?php if((isset($form_data['automatic_replies']) && ($form_data['automatic_replies'] == "1")) || !empty($content)) {echo 'checked=\"checked\"';} ?> /> <label for="automatic_replies">Send automatic replies</label>	
					</td>
				</tr>
				<tr>
					<td colspan="2" class="paddingriht"><input type="checkbox"  name="time_period" class="checkBtn" id="time_period"  value="1"  <?php if((isset($form_data['time_period'])&& ($form_data['time_period'] == "1")) || !(empty($start_at) || empty($end_at))) echo 'checked="checked"'  ?> /> <label for="time_period">Only send automatic replies within this time period:</label>	
					</td>
				</tr>
				<tr><td colspan="2" class="paddingrihtdate"><label for="start_date">Start Date </label>: 
				<input type="text" id="start_date" name="start_date" class="date"  value="<?php if(isset($form_data['start_date'])) { echo $this->security->xss_clean($form_data['start_date']); } else { if(!empty($start_at))echo $this->security->xss_clean($start_at);} ?>" onkeydown="if(event.keyCode == 13){$('#start_date').onfocus=function(){this.form.submit();return false;}}" /></td>
				</tr>
				<tr><td colspan="2" class="paddingrihtdate bootstrap"><label for="end_date">End Date</label>: &nbsp;<input type="text" id="end_date" name="end_date" class="date" value="<?php if(isset($form_data['end_date'])) { echo $this->security->xss_clean($form_data['end_date']); } else { if (!empty($end_at)) echo  $this->security->xss_clean($end_at);} ?>" onkeydown="if(event.keyCode == 13){$('#end_date').onfocus = function(){this.form.submit();return false;}}" /></td>
				</tr></table>
				<table role="presentation" name="text_editor" id="text_editor">
				<?php if(isset($form_data['message_body'])){ $textarea_data = $form_data['message_body']; }else{$textarea_data = '';} ?>
				<tr>
				<td colspan="2">
				<br />
				<?php echo form_label('<strong>Reply with this message','message_body</strong>') ?>
				<?php
					if(isset($form_data['message_body'])) { $message_value = $form_data['message_body']; } else {$message_value = $content;} 
				?>
				<?php echo form_textarea(array('id' => 'message_body', 'name' => 'message_body','id' => 'message_body', 'style' => 'height: 100%; width: 100%', 'value' =>$message_value ))  ?>
				</td>
				</tr>
			</table>		

		<br><br>
				<button class="minimal " id="filter_button" type="submit" style="padding: 5px;" >Update Replies</button>
				</div>
			<?PHP echo form_close(); ?>
			</div>
		</div>
		<?PHP $this->load->view("footer"); ?>
<script>
	$( window ).load(function(){
		initRichTextEditor();
		if ($('input[name=automatic_replies]:checked').val() == 1) {
			$("#time_period").attr("disabled", false);
			$("#message_body").attr("disabled", false);
		}else{	
			$('#time_period').attr('disabled', true); 
			disable_dates();
		}
		
		if ($("input[name=time_period]:checked").is(':checked')){
			$("#start_date").attr("disabled", false);
			$("#end_date").attr("disabled", false);
		}else{
			disable_dates(); 
		}
	});
	
	$(".radioBtn").click(function(){  
		if($("input[name=automatic_replies]:checked").val() == "1"){
			$("#time_period").attr("disabled", false);
			$("#end_date").attr("disabled", false);
			$("#time_period").attr("disabled", false);  
		}else if($("input[name=automatic_replies]:checked").val() == "0"){
			$("#time_period").attr("disabled", true);
			disable_dates();
		}		
	});
	
	$("#time_period").click(function(){
		if ($("input[name=time_period]:checked").is(':checked')){
			$("#start_date").attr("disabled", false);
			$("#end_date").attr("disabled", false);
		}
		else {
			disable_dates();
		} 	 		
	});
	
	$('input.date').datetimepicker({timeFormat: "hh:mm tt"});$('input.date').css({"position": "relative","z-index": 999999});
	
	function disable_dates(){
		$("#start_date").attr("disabled", true);
		$("#start_date").attr("value",'');
		$("#end_date").attr("disabled", true);
		$("#end_date").attr("value",'');
	}
	
	//need to set textarea content on submit
	function mainFormOnSubmit() {
		if($('#message_body').css('display') == 'none') {
		$('textarea[name="message_body"]').val(editor.getEditorContent()); 
	}}
</script>
	</body>
</html>