<?php
/**
 * @package direct-project-innovation-initiative
 * @subpackage views
 * @filesource
 */ /** */

/* Note - this code applies the same id to many elements, which is invalid HTML and may cause unexpected behavior for js/css.
 If we're ever refactoring this code, we should consider changing the id="sender", id="subject", id="priority", etc. for table columns
 to classes instead.  Additionally, it would be easier to work with this code if it was embedded PHP in HTML instetad of echoed strings,
 so that we'd have the benefit of syntax highlighting/code formatting. - MG 2014-05-05 */

$mailbox_location = get_instance()->session->mailbox_location();
$mailbox_location_display_name = get_instance()->session->mailbox_location_display_name();
$is_group = get_instance()->mailbox->is_group;


$optional_vars = array( 'show_workflow' => '',
    'sort_column' => '',
);

//make sure that optional vars all have a value
foreach( $optional_vars as $optional_var => $default_value){
    if(!isset($$optional_var)) $$optional_var = $default_value;
}

?>

<table id="messages" class="messages<?php if($is_group): ?> group<?php endif ?>" style="border-spacing: 1px;" summary="This table lists messages in the <?php echo $mailbox_location_display_name ?> folder. Each row contains a checkbox for selecting an individual message to perform an action, such as Archive, Move, or Mark as Read. Each table cell after the checkbox contains information about the message: The sender of the message, the subject (and the priority if applicable), the date it was sent, and the message size.">
	<caption class="hidden_context">List of messages in mailbox folder: <?php echo $mailbox_location_display_name ?></caption>
	<!--[if lte IE 8 ]>
		<colgroup span="<?php echo ($show_workflow ? '9' : '8') ?>">
			<col style="width: 20px;">
			<?php if($show_workflow): ?><col style="width: 20px;"><?php endif ?>
			<col style="width: 20px;">
			<col style="width: 100px;">
			<col style="width: 390px;">
			<col style="width: 20px;">
			<col style="width: 60px;">
			<col style="width: 80px;">
			<col style="width: 70px;">'
		</colgroup>
	<![endif]-->
	<tr class="header">
		<th id="messages-select" class="select">
			<label for="selectall" class="hidden_context">Select All</label>
			<input type="checkbox" name="selectall" id="selectall" onclick="selectAll()" />
		</th>
		<th id="messages-attachment" class="attachment bootstrap">
			<span class="glyphicon glyphicon-paperclip" aria-hidden="true"></span>
			<span class="sr-only">Number of Attachments</span>
		</th>
	<?php if($show_workflow): ?>
		<th id="messages-status-icon" class="status_icon"><a href="/inbox/sort/workflow"><img id="legend" src="/images/dark_man.png" style="width:12.5px;" alt="Status" title="Status" /><?php if($sort_column == 'workflow') echo $sort_icon ?></a></th>
	<?php endif ?>
		<th id="messages-sender" class="sender"><a href="/inbox/sort/sender">From<?php if($sort_column == 'sender') echo $sort_icon ?></a></th>
		<th id="messages-subject" class="subject" colspan="2"><a href="/inbox/sort/subject">Subject<?php if($sort_column == 'subject') echo $sort_icon ?></a></th>
		<th id="messages-flag" class="flag"><a href="/inbox/sort/flag"><img src="/images/icons/flag_less_transparent.png" alt="Flag" title="Flag"/><?php if($sort_column == 'flag') echo $sort_icon ?></a></th>
		<th id="messages-priority" class="priority"><a href="/inbox/sort/priority">Priority<?php if($sort_column == 'priority') echo $sort_icon ?></a></th>
		<th id="messages-date" class="date"><a href="/inbox/sort/timestamp">Date<?php if($sort_column == 'timestamp') echo $sort_icon ?></a></th>
		<th id="messages-size" class="size"><a href="/inbox/sort/size">Size<?php if($sort_column == 'size') echo $sort_icon ?></a></th>
		<?php if(isset($is_multiple_folder_search) && $is_multiple_folder_search === true): ?>
		<th id="messages-folder" class="folder">Folder</th>
		<?php endif ?>


		<?php //start markup with no differences ?>
	</tr>
<?php foreach($headers as $msg_uid => $message): ?>
	<?php $header = $message; ?>
	<?php $message_url = site_url('inbox/viewmsg/'.$message->id); ?>
	<tr<?php if(!$message->seen): ?> class="newmsg"<?php endif ?>>
		<td headers="messages-select" class="select">
			<label for="select<?php echo $message->id ?>" class="hidden_context">Select Message with Subject: <?php echo $message->subject_for_display ?></label>
			<input class="selectmsg" type="checkbox" name="selected_messages[<?php echo $message->id ?>]" id="select<?php echo $message->id ?>" onclick="selectMsg(this)" />
		</td>
		<td headers="messages-attachment" class="attachment bootstrap">
		<?php if($message->has_attachments()): 
		$attach_count = count($message->attachment_names);?>
			<a href="<?php echo $message_url ?>" title="<?= $attach_count.' '.pluralize_if_necessary('Attachment', $attach_count) ?>">
				<span class="glyphicon glyphicon-paperclip" aria-hidden="true"></span>
				<span class="sr-only"><?= $attach_count.' '.pluralize_if_necessary('Attachment', $attach_count) ?></span>
			</a>
		<?php endif; ?>
		</td>
	<?php if($show_workflow): ?>
		<td headers="messages-status-icon" class="workflow status_icon"><?php echo $this->load->view('inbox/messages/_workflow', compact('current_user', 'display_name', 'header'), TRUE); ?></td>
	<?php endif ?>
		<td headers="messages-sender" class="sender">
			<a title="<?php echo $message->sender_for_display ?>" href="<?php echo $message_url ?>"><?php echo $message->sender_for_display ?></a>
		</td>
		<td headers="messages-subject" class="subject"><?php echo $this->load->view('inbox/messages/_subject', compact('message'), TRUE) ?></td>
		<td headers="messages-subject" class="patients bootstrap"><?php if(!$message->property_is_empty('patients')) echo $this->load->view('inbox/messages/_patients', compact('message'), TRUE) ?></td>
		<td headers="messages-flag" class="flag"><?php echo $this->load->view('inbox/messages/_flag', compact('header', 'msg_uid'), TRUE) ?></td>
		<td headers="messages-priority" class="priority">
			<a href="<?php echo $message_url ?>">
				<span title="<?php echo ucfirst($message->importance) ?> Priority" class="<?php echo $message->importance ?>_priority">
					<?php if($message->importance == 'high'): ?>!<?php elseif($message->importance == 'low'): ?>&#8595;<?php else: ?>&nbsp;<?php endif ?>
				</span>
			</a>
		</td>
		<td headers="messages-date" class="date"><a href="<?php echo $message_url ?>"><?php echo $message->timestamp_for_display() ?></a></td>
		<td headers="messages-size" class="size"><a href="<?php echo $message_url ?>"><?php echo $message->size_for_display()?></a></td>
	<?php if(isset($is_multiple_folder_search) && $is_multiple_folder_search === true):?>
		<td headers="messages-size" class="size">
		<?php if(Folder::is_an_entity($message->folder)): ?>
			<?php echo $message->folder->name_for_display() ?>
		<?php endif ?>
		</td>
	<?php endif ?>
	</tr>
<?php endforeach ?>
</table>
<input style="display:none;" id="current_user" value="<?PHP echo $this->security->xss_clean($current_user);?>"/>
<input style="display:none;" id="display_name" value="<?PHP echo $this->security->xss_clean($display_name);?>"/>