<?php
/**
* @package direct-project-innovation-initiative
* @subpackage errors
*/ /** */
?>
<!DOCTYPE html>
<html lang="en">
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<link rel="stylesheet" type="text/css" href="/css/main.css" media="all" />
		<?PHP $theme_css = element('theme_css_name', $CI->user_theme); ?>
		<?PHP if(isset($theme_css) && strlen(trim($theme_css)) > 0) { echo '<link rel="stylesheet" type="text/css" href="/css/themes/' . $theme_css . '.css" />'; } ?>
		<link href="<?php echo site_url('css/bootstrap-scoped.min.css') ?>" rel="stylesheet" type="text/css" media="all" />
		<link href="<?php echo site_url('css/localized.css') ?>" rel="stylesheet" type="text/css" media="all" />
		<title><?php echo PORTAL_TITLE_PREFIX ?><?php echo $video->title ?></title>
	</head>
	<body class="video-template">
		<div class="container-fluid">
			<div id="wrapper">
				<div id="header" class="error"><?PHP $this->load->view('header/banner'); ?></div>
				<div class="wrapper-inner bootstrap">
					<div class="nav col-lg-12">
						<div id="admin_menu" class="admin-menu settings">
						<?php foreach($videos as $video_for_nav): ?>
								<div class="menuwrap">
									<div class="tab<?php if (string_begins_with($video_for_nav->url_for_view(), current_url())) echo ' active'; ?>">
										<?php echo link_to($video_for_nav->url_for_view(), $video_for_nav->title) ?>
									</div>
								</div>
						<?php endforeach ?>
						</div>				
					</div>
					<div class="col-lg-12">
						<div class="template-content">
							<h1><?php echo $video->title; ?></h1>
							<?php echo $contents ?>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?PHP $this->load->view("footer"); ?>
		<script type="text/javascript" src="/jscripts/jquery.min.js"></script>
		<script type="text/javascript" src="/jscripts/jquery.migrate.js"></script>
		<script type="text/javascript" src="/jscripts/bootstrap-3.2.2.min.js"></script>
	</body>
</html>