<?PHP
/**
* @package direct-project-innovation-initiative
* @subpackage views
* @filesource
*/ /** */

$CI = get_instance();
$validation_errors = $this->session->flashdata('validation_errors');

if(is_a($markup_generator, 'Form_markup_generator')){
	$access_fields = array_intersect(array('personal_mailbox_access', 'is_admin', 'is_group_leader', 'is_facility_leader'), $markup_generator->field_names());
	$notification_fields = array_intersect(array('external_email', 'send_notifications_for_personal_mailbox', 'send_notifications_for_group_mailboxes'), $markup_generator->field_names());
}

$this->load->view('header/header_admin');
$this->load->view('message_modal');
?>
		</div>
		<style>
			.admin-panel .edit-user .checkbox-form-group .field-container { display: block; width: 100%; padding-left: 14%; }
			.admin-panel .edit-user .checkbox-form-group label { width: 100%; text-align: left; }

			.bootstrap fieldset { margin: 2em 0; }
			.bootstrap fieldset legend { margin-top: 2em; padding-bottom: 0.2em; font-family: Helvetica, "Helvetica Neue", Arial, sans-serif; }
			.admin-panel .edit-user .access-fields { margin-left: 14%; }
			.admin-panel .edit-user .access-fields .checkbox-form-group { float: left; width: 50%; }
			.admin-panel .edit-user .access-fields .checkbox-form-group .field-container { padding-left: 0; }

		</style>

			<?PHP $this->load->view('adminpanel/admin_nav',array('item' => 'manage_users')); ?>
			<div id="tabs">
				<div class="tab <?php if($user->is_active) echo 'active-tab' ?>"><a href="/adminpanel/manage_users/">Manage Users</a></div>
				<div class="tab long-tab <?php if(!$user->is_active) echo 'active-tab' ?>"><a href="/adminpanel/manage_users/removed/">Manage Removed Users</a></div>
				<?PHP  if($CI->has_permission('manage_user_create')){?><div class="tab long-tab"><a href="/adminpanel/manage_users/create/">Manual Account Creation</a></div><?PHP }?>
			</div>
			<div id="content_wrapper" class="admin-panel">
				<a name="mainContent" id="mainContent" class="hidden_context hidden_link">Main Content</a>
				<div id="content">
					<div id="manage_users">
						<h2><a href="/adminpanel/manage_users/">Manage Users</a> &#8594; <a href="/adminpanel/manage_users/user/<?PHP echo $username; ?>"><?PHP echo $username; ?></a></h2>
						<span style="position: absolute; margin-left: 625px; margin-top: -25px;"><span class="req">*</span> indicates required field.</span>
					<?php if(!is_a($markup_generator, 'Form_markup_generator')): ?>
						<p>The user has not given this application permission to edit his/her account.</p>
					<?php else: ?>
						<div class="bootstrap">
							<div class="form-dialog edit-user">
							<?php if(!empty($error_message)): ?>
								<?php echo dismissable_alert($error_message, 'danger') ?>
							<?php endif?>
							<?php if(!empty($success_message)): ?>
								<?php echo dismissable_alert($success_message, 'success') ?>
							<?php endif?>
								<?PHP echo form_open('', 'class="form-horizontal user-form" role="form"'); ?>
									<?php echo $markup_generator->markup(array_diff($markup_generator->field_names(), $access_fields, $notification_fields)); //all of the fields that are not in the fieldsets below ?>
								<?php if(!empty($access_fields)): ?>
									<fieldset>
										<legend>Access</legend>
										<div class="access-fields">
											<?php echo $markup_generator->markup($access_fields) ?>
										</div>
									</fieldset>
								<?php endif ?>
								<?php if(!empty($notification_fields)): ?>
									<fieldset>
										<legend>Notifications</legend>
										<?php echo $markup_generator->markup($notification_fields) ?>
									</fieldset>
								<?php endif ?>
									<button name="update" class="minimal" type="submit">Update Information</button>
									<?php echo link_to('adminpanel/manage_users'.($user->is_active ? '' : '/removed'), 'Cancel') ?>
								<?PHP echo form_close(); ?>
							</div>
						</div>
					</div>
					<?php endif ?>
				</div>
			</div>
			<?PHP $this->load->view("footer"); ?>
		</div>
    <script type="text/javascript">
    $().ready(function() {
        let numeric_fields = [
            "input[name=\"telephone\"]",
            "input[name=\"mobile\"]"
        ];

        let alphanumeric_fields = [
            "input[name=\"first_name\"]",
            "input[name=\"middle_name\"]",
            "input[name=\"last_name\"]",
            "input[name=\"job_title\"]",
            "input[name=\"department\"]",
            "input[name=\"organization\"]",
            "input[name=\"location\"]"
        ];

        $(numeric_fields.join(",")).on("change", function() {
            $(this).val($(this).val().replace(/\D/g, ''));
        });

        $(alphanumeric_fields.join(",")).on("change", function() {
            $(this).val($(this).val().replace(/[^a-zA-Z 0-9 _.,!"']+/g, ''));
        });

        $('#facility-id-field').chosen();
    });
    </script>
	</body>
</html>
