<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage models
*//** */


/**
* @package direct-project-innovation-initiative
* @subpackage models
*/
class Role_model extends CI_Model {
	
    function __construct() {
        parent::__construct();
        $this->load->database();
    }
	public function create_role ($ou,$cn,$description){
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn,LDAP_ADMIN_USERNAME,LDAP_ADMIN_PASSWORD);
		if($ldap_bind) {
			$attributes = array(
				'ou' => $ou,
				'cn' => $cn,
				'description' => $description,
				'member' => array("cn=admin,".LDAP_BASE_RDN),
				'objectClass' => array("groupOfNames","top")
			);
				if(ldap_add($ldap_conn, $this->get_dn_from_rolename($ou),$attributes)){
                                        ldap_close($ldap_conn);
					return TRUE;
				}
				else{
                                        ldap_close($ldap_conn);
					return FALSE;
				}
		}
		else{ 
                    ldap_close($ldap_conn);
                    return FALSE;
                    
                }
	}
		/* Simple function to format a dn for a given rolename on this system
	 * abstracted to a function so that it can be changed in only
	 * one place if the format ever changes.
	 */ 
	public function get_dn_from_rolename($role) {
		return 'ou='.$role.','.LDAP_ROLES_GROUP;
	}
	
	
	public function get_roles(){
		return $this->get_role_from_role_name("*");
	}
	
	public function get_roles_by_page_number($start, $size) {
		$roles_by_page_number = array();
		$roles = $this->get_roles();
		$j = 0;
		for($i = 0; $i < sizeOf($roles); $i++) {
				
			if($i >= $start - 1 && $i < $start - 1 + $size) {
				$roles_by_page_number[$j] = $groups[$i];
				$j++;
			}
		}
		return $roles_by_page_number;
	}
	
	public function get_permissions_by_role_name($role){
		$this->db->where('role_name',$role);
		$query = $this->db->get("role_permissions");
		if($query){
			return $query->result();
		}
		else{
			return false;
		}
	}
	
	public function get_permissions(){
		$query = $this->db->get("permissions");
		if($query){
			return $query->result();
		}
		else{
			return false;
		}
	}
	public function get_child_permissions($parent){
		$this->db->where("parent_id",$parent);
		$query = $this->db->get("permissions");
		if($query){
			return $query->result();
		}
		else{
			return false;
		}
	}
	public function add_permission_to_role($role , $permission_id){
		if($this->permission_exists($permission_id) && $this->role_exist($role)){
			if($this->role_has_permission($role , $permission_id)){
				return true;
			}
			else{
				$data = array(
						'role_name' => $role ,
						'permission_id' => $permission_id
				);
				$this->db->insert('role_permissions', $data);
				return true;
			}
		}
		return false;
	}
	public function remove_permission_from_role($role , $permission_id){
		if($this->permission_exists($permission_id) && $this->role_exist($role)){
			$this->db->where('role_name',$role);
			$this->db->where('permission_id',$permission_id);
			$this->db->delete("role_permissions");
			return true;
		}
		return false;
	}
	
	public function role_exist($role) {
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn,LDAP_SEARCH_USERNAME,LDAP_SEARCH_PASSWORD);
		if($ldap_bind && ctype_alnum($role)) {
			$search = ldap_search($ldap_conn, LDAP_ROLES_GROUP, '(&(ou=' . $role . ')(cn=*))', array('ou'));
			$entries = ldap_get_entries($ldap_conn, $search);

			if($entries['count'] !== 0) { 
                            ldap_close($ldap_conn);
                            return TRUE; 
                            
                        }
			else{
                            ldap_close($ldap_conn);
                            return FALSE;
			}
		}
		else { 
                    ldap_close($ldap_conn);
                    return NULL; 
                    
                }
	}
	public function get_role_from_role_name($role) {
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn,LDAP_SEARCH_USERNAME,LDAP_SEARCH_PASSWORD);
		if($ldap_bind && (ctype_alnum($role) || $role === '*')) {
			$search = ldap_search($ldap_conn, LDAP_ROLES_GROUP, '(&(ou=' . $role . ')(cn=*))', array('ou','cn'));
			$entries = ldap_get_entries($ldap_conn, $search);
			if($entries['count'] !== 0) { 
                            ldap_close($ldap_conn);
                            return $entries; 
                            
                        }
			else{
                            ldap_close($ldap_conn);
                            return FALSE;
			}
		}
		else { 
                    ldap_close($ldap_conn);
                    return NULL; 
                    
                }
	}
	public function update_role($group_name, $display_name, $description) {
		if($group_name) {
			$ldap_conn = $this->prepare_ldap_conn();
			//because this potentially will be exposed as an API function, we cannot get client cert to link to a user account
			//so use anonymous LDAP admin account and log that the request came from this application
			$ldap_bind = ldap_bind($ldap_conn,LDAP_ADMIN_USERNAME,LDAP_ADMIN_PASSWORD);
			if($ldap_bind) {
				$group_dn = $this->get_dn_from_groupname($group_name);
				$attribute_arr = array(
					'description' => $description,
					'cn' => $display_name
				);
				return ldap_modify($ldap_conn,$group_dn,$attribute_arr);
			}
                        ldap_close($ldap_conn);
		}
		return FALSE;
	}
	
	public function get_roles_membership($dn) {
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn,LDAP_SEARCH_USERNAME,LDAP_SEARCH_PASSWORD);
		if($ldap_bind) {
			//assume bind has already happened and we can do a search
			$search = ldap_search($ldap_conn, LDAP_ROLES_GROUP, "(&(member=" . $dn . "))", array("ou"));
			if(!is_resource($search)) return array();
			$entries = ldap_get_entries($ldap_conn, $search);
			$roles = array();
			for($index = 0; $index<$entries['count']; $index++){
				$roles[]=$entries[$index]['ou'][0];
			}
                        ldap_close($ldap_conn);
			return $roles;
		}
                ldap_close($ldap_conn);
	}
	
	public function user_permissions($dn) {
		$roles = $this->get_roles_membership($dn);
		return $this->get_permissions_from_roles($roles);
	}
	public function remove_roles_from_member($roles,$dn) {
		foreach ($roles as $role){
			if($this->role_exist($role)){
				$this->remove_role_membership($role, $dn);
			}
		}
	}
	public function add_roles_to_member($roles,$dn) {
		foreach ($roles as $role){
			if($this->role_exist($role)){
				$this->add_role_membership($role, $dn);
			}
		}
	}
	public function get_permissions_from_roles($roles){
		if(empty($roles)){
			return array();
		}
		$first = true;
		$this->db->join('permissions', 'permission_id = permissions.id ','left outer');
		foreach($roles as $name){
			if($first){
				$this->db->where("role_name",$name);
				$first = false;	
			}
			else{
				$this->db->or_where("role_name",$name);
			}
		}
		$this->db->select("name");
		$this->db->distinct("");
		$results = $this->db->get("role_permissions");
		if($results){
			$permissions = array();
			$results = $results->result();
			foreach($results as $result){
				$permissions[] = $result->name;
			}
			return $permissions;
		}
		
	}
	
	/* -----------------------------*
	 *  PRIVATE FUNCTIONS           *
	 * -----------------------------*/
	private function add_role_membership($role,$user_dn) {
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn,LDAP_ADMIN_USERNAME,LDAP_ADMIN_PASSWORD);
		if($ldap_bind) {
			return ldap_mod_add($ldap_conn,$this->get_dn_from_rolename($role),array("member" => $user_dn));
		}
                ldap_close($ldap_conn);
	}
	
	private function remove_role_membership($role,$user_dn) {
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn,LDAP_ADMIN_USERNAME,LDAP_ADMIN_PASSWORD);
		if($ldap_bind) {
			return ldap_mod_del($ldap_conn,$this->get_dn_from_rolename($role),array("member" => $user_dn));
		}
                ldap_close($ldap_conn);
	}
	protected function get_permission_id_by_name($name){
		$this->db->where("name",$name);
		$query = $this->db->get("permissions");
		if($query && $query->num_rows() === 1){
			$result = $query->row_array(0);
			return $result['id'];
		}
		else{
			return false;
		}
	}
	protected function permission_exists($permission_id){
		if(!is_numeric($permission_id)){
			return false;
		}
		$this->db->where('id',$permission_id);
		$query = $this->db->get("permissions");
		if($query){
			return ($query->result() === 1);
		}
		else{
			return false;
		}
	}
	protected function role_has_permission($role, $permission_id){
		$this->db->where('role_name',$role);
		$this->db->where('permission_id',$permission_id);
		$query = $this->db->get("role_permissions");
		if($query){
			return ($query->result() === 1);
		}
		else{
			return false;
		}
	}
	private function prepare_ldap_conn() {
		$ldap_conn = ldap_connect(LDAP_HOSTNAME, LDAP_PORT);
		if(!ldap_set_option($ldap_conn, LDAP_OPT_PROTOCOL_VERSION, 3)) { return FALSE; } 
		if(!ldap_set_option($ldap_conn, LDAP_OPT_REFERRALS, 0)) { return FALSE; }
		return $ldap_conn;
	}
}