<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage models
*/

/** Include the parent model */
require_model('public_distribution_list_model');

/**
* Public distribution lists are never really deleted, and still have the same functionality as undeleted lists.
* 
* Public distribution lists are moved to a different ou in LDAP when they're deleted.  This model contains the same functionality
* as the usual public distribution lists, but overrides the ou to use the deleted ou instead.
*
* @author M. Gibbs <gibbs_margaret@bah.com>
*
* @package direct-project-innovation-initiative
* @subpackage models
*/
class Deleted_public_distribution_list_model extends Public_distribution_list_model {
	var $ou =  LDAP_DELETED_DISTRUBUTION_LIST_DN;
	
	/**
	* Overrides parent functionality because we don't allow lists to be completely deleted from LDAP.
	*/
	
	function delete($id){
		$this->error->warning(strip_from_end('_model', (get_class($this))).'#'.$id.' has already been deleted.');
	}
	
	/**
	* Un-delete a distribution list.
	* @param scalar
	* @return boolean	
	*/
	public function restore($id){
		if(!$this->formatted_like_an_id($id)) return $this->error->should_be_an_id($id);
		$list = $this->find_one_deleted($id);
		if(!is_array($list)) return $this->error->should_be_an_id_for_a_deleted_distribution_list($id);
		
		//member attributes move gracefully, but our external addresses don't.  grab these first
		$external_member_results = ldap_search( $this->ldap->conn, 'ou='.$id.','.LDAP_DELETED_DISTRUBUTION_LIST_DN, '(objectclass=inetOrgPerson)');
		$external_members = $this->ldap->get_formatted_entries($external_member_results, 'uid');
		
		//delete the external members from our deleted dl
		foreach($external_members as $uid => $values){
			ldap_delete($this->ldap->conn, 'uid='.$uid.',ou=' . $id . ',' .LDAP_DELETED_DISTRUBUTION_LIST_DN);
		}
		
		$success = ldap_rename($this->ldap->conn, "ou=" . $id . "," . LDAP_DELETED_DISTRUBUTION_LIST_DN, "ou=" . $id,LDAP_DISTRUBUTION_LIST_DN, TRUE);
		//ok, apparently this is one of the few places where ldap doesn't trigger an error itself ....
		if(!$success && $this->ldap->has_ldap_error()) $this->error->warning('LDAP ERROR: '.$this->ldap->get_ldap_error());
		if(!$success) $this->error->warning('Unable to restore '.strip_from_end('_model', get_class($this)).'#'.$id);
		
		//re-add the external members to the restored dl entry
		foreach($external_members as $uid => $values){
			ldap_add($this->ldap->conn, 'uid='.$uid.',ou=' . $id . ',' . LDAP_DISTRUBUTION_LIST_DN, $values);
		}
				
		return $success;		
	}
	
	//override parent because needs to check both active & deleted.  not the most elegant thing ever, but it works.
	function name_is_available($name){
        if(!$this->is->nonempty_string($name)) return $this->error->should_be_a_nonempty_string($name);
     
	 	$CI = get_instance();
		$CI->load->model('public_distribution_list_model');
		return $this->public_distribution_list_model->name_is_available($name);
    }
}