<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package vler
* @subpackage libraries
*/

/**
* @package vler
* @subpackage libraries
*/
class Template {
	
	/** @var CI_Controller */
	protected $CI;
		
	/**
	* Map of variables to be passed to your template view.
	* Use {@link set()} to add a variable to the map and {@link template_data()} to ensure that you get all the values that should be passed to your template.
	* @var array
	*/
	protected $template_data = array();

	/**
	* Store a CI instance.
	*/
	function __construct(){
		$this->CI =& get_instance();
		$this->set('CI', $this->CI);
	}	

	/**
	* Set a variable that will be available to the template view.
	* @param string|array The name of the variable or an array of multiple variables to set (var => value)
	* @param mixed The value for the variable
	*/
	function set($name, $value=null){
		if(is_array($name)){
			foreach($name as $var => $value){
				$this->set($var, $value);
			}
			return;
		}	
			
		if(empty($name) || !is_string($name)) { trigger_error('I expected $name to be a nonempty string, but you gave me '.$name, E_USER_WARNING); return false; } 

		$this->template_data[$name] = $value;
	}

	/**
	* Grab the markup of the template, using a view as the content.
	* @param string Path for the template (same format as you'd normally use for loading a view)
	* @param string Path for the view (same format as you'd normally use for loading a view)
	* @param array|object Map of variable names to values for the view.  (If you pass an object, the class vars will be turned into array elements.)
	* @param boolean True if the markup should be returned as a string instead of just displayed.
	*/
	function load($template, $view = '' , $view_data = array(), $return_as_string = FALSE){
		if(empty($template) || !is_string($template)) { 
			trigger_error('I expected $template to be a nonempty string, but you gave me '.$template, E_USER_WARNING); 
			return false; 
		} 
		if(empty($view) || !is_string($view)) { trigger_error('I expected $view to be a nonempty string, but you gave me '.$view, E_USER_WARNING); return false; } 
		$this->set('contents', $this->CI->load->view($view, $view_data, TRUE));	
		return $this->CI->load->view($template, $this->template_data, $return_as_string);
	}
	
	/**
	* Grab the markup of the template, using a string as the content.
	* @param string Path for the template (same format as you'd normally use for loading a view)
	* @param string Content for the template
	* @param array Completely pointless and not used.  Hmmm.
	* @param boolean True if the markup should be returned as a string instead of just displayed.
	*/
	function load_string($template, $string,  $return_as_string = FALSE){
		if(empty($template) || !is_string($template)) { 
			trigger_error('I expected $template to be a nonempty string, but you gave me '.$template, E_USER_WARNING); 
			return false; 
		} 
		$this->set('contents', $string);	
		return $this->CI->load->view($template, $this->template_data, $return_as_string);
	}
	
	
}
/* End of file Template.php */
/* Location: ./system/application/libraries/Template.php */