<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
*/ /** */

require_once APPPATH.'controllers/inbox.php';

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
*/
class Workflow_controller extends Inbox {
	
	/*assign message to someone*/
	public function assign_message_status($id,$user_id){
		$this->load->model('workflow_model');
		$id = str_replace("status_", "", $id);
		echo $this->create_message_status($id, $user_id,0);
	}
	

	/*assign message to me*/
	public function assign_to_me($id ,$db_id = null){
		$this->load->model('workflow_model');
		$id = str_replace("status_", "", $id);
		if ($db_id === null){//status id
			$results = $this->workflow_model->find_for_message($id);
			if($results === false){
				echo $this->create_message_status($id, $this->user_model->logged_in_user('user_id'),0);
				return;
			}
		}
		else{// database id
			$results = $this->workflow_model->find_one($db_id);
		}
		if(is_array($results)){
			if($results['assigned_to'] === null || $results['assigned_to'] === $this->user_model->logged_in_user('user_id')){
					echo $this->update_message_status($id ,$db_id, $this->user_model->logged_in_user('user_id'), 0);
			}
			else{
				$results['success'] = false;
				$results['error'] = "already assigned";
				$results['assigned_to'] =  $this->user_model->user_cn_from_id($results['assigned_to']);
				echo json_encode($results);
			}
		}
		else{
			echo json_encode(array('success'=>false,'error'=>'failed to get results'));
		}
	}
	
	/*assign message to someone*/
	public function complete_message($id, $db_id = null){
		$this->load->model('workflow_model');
		$id = str_replace("status_", "", $id);
		if ($db_id === null){//status id
			$results = $this->workflow_model->find_for_message($id);
			if($results === false){
				echo $this->create_message_status($id, $this->user_model->logged_in_user('user_id'),1);
				return;
			}
		}
		else{// database id
			$results = $this->workflow_model->find_one($db_id);
		}
		if(is_array($results)){
			if($results['assigned_to'] === null || $results['assigned_to'] === $this->user_model->logged_in_user('user_id')){
					echo $this->update_message_status($id ,$db_id, $this->user_model->logged_in_user('user_id'), 1);
			}
			else{
				$results['success'] = false;
				$results['error'] = "already assigned";
				$results['assigned_to'] =  $this->user_model->user_cn_from_id($results['assigned_to']);
				echo json_encode($results);
			}
		}
		else{
			echo json_encode(array('success'=>false,'error'=>'failed to get results'));
		}
	}

	/*reset message*/
	public function reset_message_status($id, $db_id = null){
		$this->load->model('workflow_model');
		$id = str_replace("status_", "", $id);
		$results = $this->workflow_model->find_for_message($id);
		if($results === false){
			return;
		}
		if(is_array($results)){
			if($results['assigned_to'] === null || $results['assigned_to'] === $this->user_model->logged_in_user('user_id')){
				if($this->workflow_model->remove_from_message($id)){
					echo json_encode(array('success'=>true));
				}else{
					echo json_encode(array('success'=>false,'error'=>'failed to remove'));
				}
			}
			else{
				$results['success'] = false;
				$results['error'] = "already assigned";
				$results['assigned_to'] =  $this->user_model->user_cn_from_id($results['assigned_to']);
				echo json_encode($results);
			}
		}
		else{
			echo json_encode(array('success'=>false,'error'=>'failed to get results'));
		}
	}
	
/////////////////////////////////
// HELPER METHODS
/////////////////////////////////	
	
	protected function create_message_status($id, $assigned, $complete){
		$value = $this->workflow_model->set_for_message($id, array('assigned_to'=>$assigned, 'complete'=> $complete, 'message_id' => $id));
		if($value === false){
			return json_encode(array('success'=>false,'error'=>'failed to create'));
		}
		else{
			$value['success']=true;
			return json_encode($value);
		}
	}
	
	protected function update_message_status($id ,$db_id, $assigned, $complete){
		$value = $this->workflow_model->update_for_message($id, array('assigned_to'=>$assigned, 'complete'=> $complete), $db_id);
		if($value === false){
			return json_encode(array('success'=>false,'error'=>'failed to update'));
		}
		else{
			$value['success']=true;
			return json_encode($value);
		}
	}						
	
}
/* End of file inbox.php */
/* Location: ./application/controllers/inbox.php */