<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package vler-libraries
* @subpackage controllers
* @filesource
*//** */

/**
* Gives the unit tests an unrestricted controller to access and allows developers to run tests from the website.
*
* In future, it would be nice to provide the developers with a useful GUI like {@link https://github.com/VisualPHPUnit/VisualPHPUnit}, 
* but for now this will give a place to test besides the windows command line.
*
*
* @package vler-libraries
* @subpackage controllers
*/
class VLER_unit_test_controller extends CI_Controller{	
	protected $unit_test_location;
	
	function __construct(){
		parent::__construct();
		if(!is_on_local()) redirect('inbox');
		
		$this->output->enable_profiler(false);
	}	

	//run all phpunit tests -- we'll ultimately do something automated here, but until we've got a few more tests ...
	function index(){
		if(!defined('PHPUNIT_TEST')){ //if this is the developer trying to access the test results, show them a GUI
			chdir(VLER_DIRECTORY.'unit-tests/webmail');
			$output = array();
			exec('phpunit', $output);
			prp(implode("\n", $output));
		}
	} 
	
}