<?php

/**
 * Base class for CodeIgniter unit tests
 * 
 * This class wraps $CI reference for communicating with CodeIgniter,
 * as well as helping to load controllers and models
 * 
 * @author Fernando Paincastelli
 * @link https://github.com/fmalk/codeigniter-phpunit
 *
 * @author M. Gibbs <gibbs_margaret@bah.com>
 */
 abstract class CITestCase extends PHPUnit_Framework_TestCase{
	 
	/**
	 * Reference to CodeIgniter
	 * 
	 * @var resource
	 */
	protected $CI;
	
	/**
	 * Call parent constructor and initialize reference to CodeIgniter
	 * 
	 * @internal
	 */
	public function __construct($name = NULL, array $data = array(), $dataName = '')
    {
        parent::__construct($name, $data, $dataName);
		$this->CI =& get_instance();	
    }

	/**
	* Verifies that we encountered a PHP error while running a test.
	* Additionally checks to make sure that we got the return value we expected.
	* 
	* Based on assertThrowsExxception by Lars Temer: http://www.lars-tesmer.com/blog/2011/08/29/phpunit-better-syntax-for-expecting-exceptions/
	*
	* @param function $code An anonymous function that contains the test case, e.g. function(){ return flatten_array(NULL); }
	* @param string $description A text description of what is being tested
	* @param mixed $expected_result Whatever we expect the code to return
	*/
	protected function assertPhpError($code, $description, $expected_result = false) {
		
		try{
			$code();
		}catch (Exception $e) {
			if(!($e instanceof PHPUnit_Framework_Error)){
				throw new PHPUnit_Framework_ExpectationFailedException(	trim($description . "\n" . 
					'Expected a PHP error to be triggered, but a different exception was encountered: '.$e->getMessage()),
					$e
				);
				return false;
			}
		}
		
		if(!isset($e)){
			throw new PHPUnit_Framework_ExpectationFailedException(	trim($description . "\n" . 'Expected a PHP error to be triggered'));
			return false;
		}
		
		
		return $this->assertSame(@$code(), $expected_result, $description);
	}
	
	
}