<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
/**
* Any changes to this library need to be made in both Webmail and the API.
* @package vler
* @subpackage libraries
*/ /** */

require_library('xml_document/ccd');

/**
* @package vler
* @subpackage libraries
*/
class CCR extends CCD{
	
	protected $xpath_namespaces = array('x' => 'urn:astm-org:CCR');

#TODO - WE NEED TO REPLACE THESE VALUES WITH THE CORRECT SPECIFICATIONS FOR CCRS
	protected $values_to_parse = array(
										/*'patient_icn' => array('xpath_query' => 'x:recordTarget/x:patientRole/x:id[@root="2.16.840.1.113883.4.349"]',
															   'attribute' => 'extension',
															   'single_value' => true,
															   'default_value' => '&ndash;', ), */

										//we should probably be just going with 'Continuity of Care Record', but we can try this for now.
										'title' => array( 'xpath_query' => 'x:Purpose/x:Description/x:Text',
														  'single_value' => true,
														  'default_value' => 'Continuity of Care Record'),
										'given_names' => array('xpath_query' => '(x:Actors/x:Actor/x:Person/x:Name/x:CurrentName/x:Given)[1]'),
										'family_name' => array('xpath_query' => '(x:Actors/x:Actor/x:Person/x:Name/x:CurrentName/x:Family)[1]',
														 	   'single_value' => true),
										//note - it is not clear that CCRs contain this value.  We need more information before we can grab this information.  sticking with CCD definition for now.
										'organization' => array('xpath_query' => 'x:author/x:assignedAuthor/x:representedOrganization/x:name', 
																'default_value' => '&ndash;',
																'single_value' => true), 
										//note - this is probably incorrect, but we don't have a working example to check against-- MG 2016-02-07
										'date_of_birth' => array('xpath_query' => 'x:Actors/x:Actor/x:Person/x:DateOfBirth/x:ExactDateTime', //note - this is probably not correct, but we don't have a working example -- MG
											  					 'single_value' => true)
										);


	function date_of_birth(){
		if(empty($this->raw_value('date_of_birth'))) return 'Unknown';
		return $this->human_readable_date($this->raw_value('date_of_birth'));
	}

	function patient_name($default_value = NULL){
		$display_name = implode_nonempty(' ', array(implode_nonempty(' ', $this->given_names), $this->family_name));
		if(empty($display_name) && !is_null($default_value)) return $default_value;
		return $display_name;
	}

	public static function string_matches_schema($xml_string){
		return !empty($xml_string) && validates_as('ccr_xml_string', $xml_string);
	}


}
?>