<?php
/**
* @package icarus
* @subpackage partials-lister
*/

$lister->CI->load->helper('url_helper');
if(is_null($link_text))
	$link_text = $page_number;
if(!is_string($link_text) && is_numeric($link_text))
	$link_text = (string)$link_text;


if(!$this->is->nonzero_unsigned_integer($page_number))
	echo tag('span', $link_text, merge_attributes($attributes, array('class' => 'plain-text'))); // our "..." spacer text.  still do the link_to_unless so that we'll have the same markup as non-linked items.
elseif($lister->page == $page_number)
	echo '<span>'.$page_number.' <span class="sr-only">(current)</span></span>';
else
	echo link_to($lister->url_for_page($page_number), $link_text, $attributes);

	
?>