<?php
/**
* Partial that generates the markup for a checkbox field.
*
* This partial generates the markup for the checkbox <i>only</i> and is used by the {@link Field_markup_generator::field_markup() field_markup()} method.  For the partial that
* generates both checkbox and label within a standard markup container, see {@link _checkbox.php}.  
*
* Form markup generator partials are designed to follow object-oriented-esque patterns of inheritance.  This partial will by default be used by the 
* {@link Checkbox_markup_generator} and all of its children that do not have a partial named after their {@link Field_markup_generator::$_type type}.
* If you wish to override this partial in your application, please follow the instructions in the "Partials and Markup Generation" section of the
* {@link Field_markup_generator} class documentation.
*
* This partial uses the Codeigniter {@link form_checkbox()} method from the CI Form Helper.  For information on extending or overriding CI helper methods, 
* see the {@link http://codeigniter.com/user_guide/general/helpers.html CI manual}.
*
* Like all {@link Field_markup_generator} partials, this partial expects to be passed a copy of the markup generator calling it, called $markup_generator.
* @package vler
* @subpackage form-markup-generator
*
* @author M. Gibbs <gibbs_margaret@bah.com> Last updated 2012-08-02
*/
if(!isset($markup_generator) || !is_a($markup_generator, 'Field_markup_generator'))
	$this->error->should_be_a_field_markup_generator($markup_generator);

echo form_checkbox($markup_generator->attributes());

