<?php
/**
* @package vler
* @subpackage form-markup-generator
*/

/* 

First shuttle departs at {TIME} and runs every {INTEGER} minutes until {TIME}.
Next shuttle departs at X and runs every Y minutes until Z.
Next shuttle departs at X and runs every Y minutes until Z.

*/


/**
* require parent file
*/
require_library('form_markup_generator/field_markup_generators/field_group');
require_library('form_markup_generator/field_markup_generators/text_input');
require_library('form_markup_generator/field_markup_generators/integer_text_input');

/**
* @uses _field_group.php
* @uses _time_field.php
* @uses _label.php
*
* @package vler
* @subpackage form-markup-generator
*/
class Time_markup_generator extends Field_group_markup_generator{
	protected $_type = 'time';
	protected $_feedback_invalid_input = "Please enter the complete time for the %s field, including the hour and the minute."; //child classes should implement a specific description of the value
	protected $_field_templates = array('hour' => array('type' => 'integer_text_input', 'minimum' => 1, 'maximum' => 12),
																			'minute' => array('type' => 'integer_text_input', 'minimum' => 0, 'maximum' => 60), 
																			'meridium' => array('type' => 'dropdown', 'options' => array('am' => 'AM', 'pm' => 'PM')));
	
	protected function has_valid_value_if_any(){
		if(!parent::has_valid_value_if_any()) return false;
		//can't have a minute without a value for the hour
		if(!$this->field('minute')->property_is_empty('value') && $this->field('hour')->property_is_empty('value')){
			return false;
		}
		
		return true;
	}

 	protected function has_value_if_required(){
		if(!parent::has_value_if_required()) return false;
		return ($this->field('hour')->has_value_if_required() && $this->field('minute')->has_value_if_required());
	}

	function value(){
		//we'll always get a meridium value, so check to make sure we have the hour
		$values = $this->values();
		
		$values['hour'] = str_pad($values['hour'], 2, '0', STR_PAD_LEFT);
		$values['minute'] = str_pad(element('minute', $values, '00'), 2, '0', STR_PAD_LEFT);
		
		if(!empty($values['hour'])){
			return strftime("%T", strtotime(element('hour', $values).':'.element('minute', $values, '00').' '.element('meridium', $values)));
		}
	}
	
	function set_required($value){
		$this->_required = $value;
		if(isset($this->fields) && !empty($this->fields)){
			foreach($this->fields as $field_name => $field){
				$this->field($field_name)->required = $value;
			}
		}
		else{
			foreach($this->_field_templates as $field_name => $info){
				if(!is_array($info)) $info = array('type' => $info);
				$this->_field_templates[$field_name]['required'] = $value;
			}
		}
	}
	
	function set_value($value){
		if($this->validator->is_a_mysql_time($value)){
			$timestamp = strtotime($value);
			$value = array('hour' => strftime("%I", $timestamp), 'minute' => strftime("%M", $timestamp), 'meridium' => strftime("%P", $timestamp));
		}

		if($this->validator->is_an_array($value)) parent::set_value($value);
	}
																			
}