<?php
/**
* @package vler
* @subpackage form-markup-generator
*/

/**
* require parent file
*/
require_library('form_markup_generator/field_markup_generators/field_group');
require_library('form_markup_generator/field_markup_generators/integer_text_input');

/**
* @package vler
* @subpackage form-markup-generator
*/
class Social_security_number_markup_generator extends Field_group_markup_generator{
	protected $_type = 'social_security_number';
	protected $_field_templates = array(//note that area numbers may not be 000, 666, or in the range of 900-999 (see: http://en.wikipedia.org/wiki/Social_security_number#Structure)
										'area_number' => array('type' => 'integer_text_input', 'minimum' => 000, 'maximum' => 999, 'min_length' => 3, 'attributes' => array('size' => 3), 
															   'label_attributes' => array('class' => 'sr-only'), 'feedback_invalid_input' => 'Please enter a three digit number for the %s field.'),
										'group_number' => array('type' => 'integer_text_input', 'minimum' => 000, 'maximum' => 99, 'min_length' => 2, 'attributes' => array('size' => 2),
												  			    'label_attributes' => array('class' => 'sr-only'), 'feedback_invalid_input' => 'Please enter a two digit number for the %s field.'),
										'serial_number' => array('type' => 'integer_text_input', 'minimum' => 0000, 'maximum' => 9999, 'min_length' => 4,  'attributes' => array('size' => 4),
												  			     'label_attributes' => array('class' => 'sr-only'), 'feedback_invalid_input' => 'Please enter a four digit number for the %s field.'));


	
	function value(){
		$values = $this->values();	
		
		//check to make sure that we have values - if all three values are an empty string, just return the empty string
		if(count(array_unique($values)) === 1 && empty(first_element($values)) && first_element($values) !== 0){
			return '';
		}
		
		$number_lengths = array('area_number' => 3, 'group_number' => 2, 'serial_number' => 4);
		foreach($values as $field_name => $field_value){
			if($this->has_field($field_name) && is_numeric($field_value))
				$values[$field_name] = str_pad($field_value, $number_lengths[$field_name], '0', STR_PAD_LEFT);
		} 
				
		return implode('-', $values);
	}

	function set_required($value){
		//makes sure that the required value for this group applies to all of the fields in the group
		$this->_required = $value;
		if(isset($this->fields) && !empty($this->fields)){
			foreach($this->fields as $field_name => $field){
				$this->field($field_name)->required = $value;
			}
		}
		else{
			//if we don't have the fields yet, apply the required value to the field templates
			foreach($this->_field_templates as $field_name => $info){
				if(!is_array($info)) $info = array('type' => $info);
				$this->_field_templates[$field_name]['required'] = $value;
			}
		}
	}

	function set_value($value){
		if($this->validator->string_like_a_social_security_number($value)){
			$pieces = explode('-', $value);
			$value = array('area_number' => $pieces[0], 'group_number' => $pieces[1], 'serial_number' => $pieces[2]);	
		}
		if(is_array($value)) $this->set_values($value);
	}
		
	
	function has_value_if_required(){
		//if any of the fields are filled out, all of them are required
		$unique_values = array_unique($this->values);
		if(count($unique_values) > 1 || !empty(first_element($unique_values))){
			foreach($this->field_names() as $field_name){
				$this->field($field_name)->required = true;
			}
		}
		
		return parent::has_value_if_required();
	}


}