<?php
/**
* @package vler
* @subpackage form-markup-generator
*/

//todo:
	//need to transfer the file to some sort of cache - or just the $_FILES array? can we submit a file via JS?  probably not.  How about the session?  that way, PHP will clean it up for us
	//this is needed so that file will be resubmitted on validation.  $_SESSION is probably the most system-agnostic way to do it - it'll work for an CI instance that is using files like us.
	//apply size limit
	//apply limit on file types?  probably not

/**
* require parent file
*/
require_library('form_markup_generator/field_markup_generators/text_input');

/**
* @uses _text_input.php
* @uses _text_input_field.php
* @uses _label.php
*
* @package vler
* @subpackage form-markup-generator
*/
class File_markup_generator extends Text_input_markup_generator{
	protected $_type = 'file';
	
	protected $_unique_id;
	protected $_unique_id_name;
	
	protected $_feedback_invalid_input = "Please enter a file for the %s field."; 
	protected $_feedback_too_large = "The file for the %s field may not exceed %n. Please select a smaller file.";
	protected $_file_info; //the information about this file from $_FILE (or in the future, from a cache if the form is being reloaded)
	protected $_max_size_in_bytes; //defaults to the PHP setting
	protected $_max_length = 255; //filenames must be 255 chars or less in Windows 2008 R2
	protected $_php_max_size; //the upload limit based on the PHP configuration
	protected $validation_method = 'nonempty_string'; 
	
	protected $_property_validation_rules = array('max_size_in_bytes' => 'unsigned_integer');
	
	//todo - this override probably isn't needed if the parent classes correctly checks whether or not raw value is empty, and if we switched to raw value instead of value
	protected function has_value(){
		return (!$this->property_is_empty('value') || trim($this->value) === 0);
	}	
	
	protected function unique_id_name(){
		if(!isset($this->_unique_id_name)){
			$this->_unique_id_name = '__'.$this->name.'_unique_id';
		}
		return $this->_unique_id_name;
	}
	
	public function unique_id(){
		if(!isset($this->_unique_id)){
			if(!empty($_POST[$this->unique_id_name]) && is_numeric($_POST[$this->unique_id_name])){
				$this->_unique_id = get_instance()->input->post($this->unique_id_name);
			}else{
				$this->_unique_id = now();
			}
		}
		return $this->_unique_id;
	}
	
///////////////////////
// VALIDATION
////////////////////////
	
	function feedback_invalid_input(){
		if(!$this->value_does_not_exceed_max_size){
			$feedback = str_replace('%n', byte_format($this->max_size_in_bytes), $this->_feedback_too_large);
			return str_replace("%s", $this->link_to_field(), $feedback);
		}
		return parent::feedback_invalid_input();
	}
	
	
	public function has_valid_value_if_any(){
		if(!parent::has_valid_value_if_any()) return false;
		return $this->value_does_not_exceed_max_size(); 
	}
		
	protected function value_does_not_exceed_max_size(){
		if($this->file_info('size') > $this->max_size_in_bytes)
			return false;
		
		//using a MAX_FILE_SIZE hidden input in the field will prevent PHP from actually uploading files that are too large
		//in this case, the size will be zero and we'll have an error code in the file info
		if($this->file_info('size') == 0 && $this->file_info('error') == 2)
			return false;
		
		return true;
	}
	
	
////////////////////
// GETTERS
////////////////////
	
	public function attributes(){
		$attributes = parent::attributes();
		if(!isset($attributes['type']))
			$attributes['type'] = 'file';
		return $attributes;
	}	
	
	//find the information about this file from the $_FILES array
	//todo - should probably transfer this info to the $_SESSION when we reference it so that forms can be resubmitted
	//todo - if we do that, make sure that there's a way to clear this file out of the session after the form is saved.
	protected function file_info($value = null){
		if(!isset($this->_file_info)){
			$CI = get_instance();
						
			$path = $CI->security->get_csrf_hash().'_'.$this->unique_id.'_'.$this->name.'/';	
						
			if(array_key_exists($this->name, $_FILES) && is_uploaded_file($_FILES[$this->name]['tmp_name'])){
				$this->_file_info = $_FILES[$this->name];
				
				//as long as the file is valid, save it in a cache so that we have it available if we need to reload the form if another field didn't validate
				if($this->validates()){
					$CI->session->clear_cache($path);
					$CI->session->move_uploaded_file_to_cache($this->name, $path);
				}
				
			}elseif($CI->session->path_exists_in_cache($path)){
				$full_path = $CI->session->cache_root($path);
				$file_name = first_element(get_filenames($full_path));
				$full_path .= $file_name;
				$this->_file_info = array(  'name' => $file_name, 
											'type' => mime_content_type($full_path), 
											'tmp_name' => $full_path,
											'size' => filesize($full_path));										
			}else{
				$this->_file_info = array();
			}
			
			if(!is_array($this->_file_info))
				$this->error->warning('An error occurred while finding the file info for '.$this->unique_id.'#'.$this->name);		
		}
		
		if(!is_null($value))
			return element($value, $this->_file_info);
		
		return $this->_file_info;
	}
		
	protected function max_size_in_bytes(){
		if(!isset($this->_max_size_in_bytes)){
			$this->_max_size_in_bytes = $this->php_max_size;
		}
		return $this->_max_size_in_bytes;
	}
		
	protected function php_max_size(){;
		if(!isset($this->_php_max_size)){
			$this->_php_max_size = min(array(ini_get_bytes('memory_limit'), ini_get_bytes('post_max_size'), ini_get_bytes('upload_max_filesize')));
		}
		return $this->_php_max_size;
	}
	
	protected function value(){
		if(!$this->property_is_empty('file_info')){
			return $this->file_info['name'];
		}
	}	
	
	public function value_full_path(){
		if(!$this->property_is_empty('value'))
			return get_instance()->security->get_csrf_hash().'_'.$this->unique_id.'_'.$this->name.'/'.$this->value;
	}
	
////////////////////
// SETTERS
////////////////////
	
	protected function set_max_size_in_bytes($value){
		if(!is_numeric($value)) return $this->error->should_be_numeric($value);
		if($value > $this->php_max_size)
			return $this->error->warning("I can't set the max size to be ".byte_format($value).' when this PHP instance is only configured to support a max file upload of '.byte_format($this->php_max_size, 0));
		$this->_max_size_in_bytes = $value;
	}
		
}