<?php
/**
* @package vler
* @subpackage form-markup-generator
*/


/**
* @todo examine the non-boolean checkbox operation a bit better to determine how to best handle this
*
* @uses _checkbox.php
* @uses _checkbox_field.php
* @uses _label.php
*
* @package vler
* @subpackage form-markup-generator
*/
class Checkbox_markup_generator extends Field_markup_generator{
	protected $_type = 'checkbox';
	//this value is the actual value that will appear in the "value" attribute for HTML; ie, what value the checkbox will add to the POST if it's checked.
	protected $_value_for_markup = 1; //by default, let's assume that these are going to be boolean checkbox.  bad idea?  make an extension if we feel like it.
	//since we're assuming that this is going to be a boolean checkbox, by default we'll look for a 0 or 1 when we're validating
	protected $validation_method = 'unsigned_integer';
	protected $_security_validation_method = 'isValidInteger';
	protected $_security_sanitization_method = 'sanitizeInteger'; 
	
	function attributes(){
		$default_attributes = array('name' => $this->name_for_markup(), 'value' => $this->value_for_markup, 'checked' => ($this->value == $this->value_for_markup));
		return merge_attributes($default_attributes, parent::attributes());
	}
	
	function set_value($value){
		if(empty($value) && !is_numeric($value)) return;
		return parent::set_value($value);
	}
}