<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * @package vler
 * @subpackage libraries
 */

require_library('authentication/Certificate_authentication');

/**
 * @package vler
 * @subpackage libraries
 */ 
class PIV_authentication extends Certificate_authentication {
	protected $type = 'PIV';
	
	/**
	* The user's PIV ID, if it can be determined and authenticated.
	* @return string|null
	*/
	function organization_id(){
		if(!isset($this->_organization_id) && !empty($this->certificate_info())){
			
			//usually the piv id is the last thing in the cert
			$org_id = trim(last_element($this->certificate_info));
			
			//but sometimes there is something in parentheses at the end that we should discard
			if(string_begins_with('(', $org_id) && string_ends_with(')', $org_id)){
				$org_id = element_number(count($this->certificate_info) - 1, $this->certificate_info);
			}
			
			//pivs are always numeric, so make sure that we didn't end up with the wrong thing
			if(is_numeric($org_id))
				$this->_organization_id = $org_id;
			else
				$this->error->warning('Attempted to identify PIV ID from certifiate, but found '.$this->error->describe($org_id));			
			
		}
		return $this->_organization_id;
	}

}

?>