<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * @package vler
 * @subpackage libraries
 */ 

require_library('authentication/Certificate_authentication');

/**
 * @package vler
 * @subpackage libraries
 */ 
class CAC_authentication extends Certificate_authentication {
	protected $type = 'CAC';
	
	/**
	* The user's EDIPI, if it can be determined and authenticated.
	* @return string|null
	*/
	function organization_id(){
		if(!isset($this->_organization_id) && !empty($this->certificate_info())){
			
			//usually the edipiis the last thing in the cert
			$org_id = trim(last_element($this->certificate_info));

			//edipis are always numeric, so make sure that we didn't end up with the wrong thing
			if(is_numeric($org_id))
				$this->_organization_id = $org_id;
			else
				$this->error->warning('Attempted to identify EDIPI from certifiate, but found '.$this->error->describe($org_id));			
			
		}
		return $this->_organization_id;
	}

}


?>