<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* Any changes to this library need to be made in both Webmail and the API.
* @package vler
* @subpackage libraries
*/ /** */

/**
* @package vler
* @subpackage libraries
*/
class XML_attachment extends Attachment{
    protected static $extensions = array('xml','xsl');
	/** @var string */
	protected $_schema;
	/** @var XML_document */
	protected $_parser;
	/** @var string */
	protected static $_parser_class;


////////////////////
// GETTERS
////////////////////

	/**
	* Acccessor for {@link _parser}
	* @return XML_document|null
	*/
	function parser(){
		if(!isset($this->_parser)){
			$parser_class = static::$_parser_class;
			if(empty($parser_class))
				return $this->error->warning(get_class($this).'::$_parser_class must be defined by child classes');
			else{
				$parser_class = class_name_for_library('xml_document/'.strtolower($parser_class)); //this class may be extended by an application, so find the real class name
				$this->_parser = new $parser_class($this->binary_string);
			}
		}
		return $this->_parser;
	}

//////////////////////
// SETTERS
//////////////////////

/////////////////////
// STATIC FUNCTIONS
/////////////////////

	/**
	* Checks the content of a file and casts it as the appropriate child class.
	*
	* For example, if a C32 file is passed to this method, {@link matches_file} will be used to determine that the content of the file
	* matches a child class and the file will be cast as a {@link C32_attachment}. Note that it would be more efficient to just create
	* a new C32_attachment object if you were sure that a file was a C32; this method should be used when you don't know how a file should be cast.
	*
	* @param string Name of the file
	* @param string Content of the file
	* @param array Any additional metadata, formatted array('message_id' => $message_id, 'directory' => $directory)
	* @return XML_attachment
	*/
	public static function create($name, $binary_string, $more_values = array()){
		log_message('debug','Who called this XML(create) ' . debug_backtrace()[1]['class'].':'.debug_backtrace()[1]['function']);
		if(!static::matches_file($name, $binary_string)) {
		    return get_instance()->error->should_be_an_x(
                'name of a '.humanize(get_called_class()).' file',
                $name
            );
        }

		require_library('attachments/patient_document_attachment');
		$patient_document_class = class_name_for_library('attachments/patient_document_attachment');
		log_message('debug','Is this XML file ' . $name . ' a PDA?');
		if($patient_document_class::matches_file($name, $binary_string, true)){
			return $patient_document_class::create($name, $binary_string, $more_values);
		}
		// not a PDA. So, settle for an XML attachment
        $values = array(
            'name' => $name,
            'binary_string' => $binary_string,
        );
        $values = array_merge($values, $more_values);
		return new XML_attachment($values);
	}

	/**
	* True if the given file can be cast as an instance of this class.
	* @param string Name of the file
	* @param string Content of the file
	* @return boolean
	*/
	public static function matches_file($name, $binary_string){
		log_message('debug','Who called this XML(matches_file) ' . debug_backtrace()[1]['class'].':'.debug_backtrace()[1]['function']);
		if(!parent::matches_file($name, $binary_string)) return false;
		log_message('debug','Validating XML file ' . $name);
		return (validates_as('xml_string', $binary_string) !== false);
	}

}
