<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
/**
* Any changes to this library need to be made in both Webmail and the API.
* @package vler
* @subpackage libraries
* @todo replace Message:: calls with something that checks for the model message class name first.
*/

class Patient_document_attachment extends XML_attachment{

	protected static $patient_document_classes = array('C32_attachment', 'CCDA_attachment', 'CCR_attachment');

	protected $_use_lightbox_preview = true;
	protected $_description;
	protected $_purpose; //purpose of disclosure
	protected $_ssn;
	protected $_transformed_markup;	
	protected $_xsl_path; //path to the XSL file, relative to APPPATH
	protected $_das_save_date;
	protected $das_user_friendly_error_message;

	protected $_property_validation_rules= array( 'purpose' => 'nonempty_string');

	#TODO - REFACTOR USING NEW SYSTEM CACHE METHODS ONCE WE HAVE THE OT11 CODE MERGED IN	
	function download_as_pdf(){
		$pdf = $this->to_pdf();
		
		if(is_a($pdf, 'Attachment'))
			//$pdf->download();
			//attempt to apply a workaround that provides a pdf "inline view" instead of a pure to avoid adobe issue - BH 2017-09-07
			$pdf->view_inline();
		else{
			$this->error->warning('Unable to generate pdf for '.$this->name);
			$this->download(); //default to a normal download of this fail if our pdf write failed
		}
	}	
	
	function save_disclosure(){
		if($this->property_is_empty('message_id')) return $this->error->warning('Cannot save a disclosure for '.$this->name.' without a message id');		
		
		$CI = get_instance();
		$values_to_save = array('mailbox' => Mailbox::find_from_session()->name,
								'id' => $this->message_id,
								'ssn' => str_replace('-', '', $this->ssn),
								'purpose' => $this->purpose,
								'hash' => $this->hash);
							
		$CI->api->clear();
		return $CI->api->call('direct/disclosure/log', $values_to_save,'POST');
	}		
	
	//in an ideal world, we would only make this available in a DPII extension, but we need other child attachment classes to be able to extend this class
	//so, we'll just test to see if the user model is available and has the method that we need.
	//tood - would be good to test if wkhtmltopdf is available, too
	function to_pdf(){
		$CI = get_instance();
		if(isset($CI->user) && method_exists($CI->user, 'add_attachment_to_cache')){
				
			$transformed_markup_filename = '__dpii_transformed_'.ireplace_last_with('.xml', '.html', $this->name);
			$pdf_filename = ireplace_last_with('.xml', '.pdf', $this->name);

			//before we try to convert the HTML to PDF, lets check to see if the PDF exists... - BH 2017-08-25
			if ($CI->user->file_name_exists_in_attachment_cache($pdf_filename)) {
				$pdf = $CI->user->attachment_from_cache($pdf_filename);
				return $pdf;
			}

			if(!$CI->user->add_attachment_to_cache($transformed_markup_filename, $this->transformed_markup())){
				$this->error->warning('Unable to write transformed markup for '.$this->name.' to cache');
				return $this->download();
			}		
			
			shell_exec('wkhtmltopdf '.'  '.escapeshellarg($CI->user->attachment_cache().$transformed_markup_filename).' '.escapeshellarg($CI->user->attachment_cache().$pdf_filename).' 2>&1');
			$CI->user->remove_attachment_from_cache($transformed_markup_filename); //remove our temporary markup file so that it doesn't accidentally get attached to the message

			//download the pdf if we created it successfully
			$pdf = $CI->user->attachment_from_cache($pdf_filename);
			
			//remove the pdf so that we won't accidentally attach it to the message - but if we create a system cache, we should comment this out so that we don't have to regenerate each time
			$CI->user->remove_attachment_from_cache($pdf_filename);		
			return $pdf;
		}
	}
	
	//in an ideal world, we would only make this available in a DPII extension, but we need other child attachment classes to be able to extend this class
	//so, we'll cheat and check the subclass prefix to figure out which application we're in.
	function url_for_download_as_pdf(){
		if(config_item('subclass_prefix') == 'DPII_'){
			$name = rawurlencode($this->name);
			if(isset($this->index_in_parent))
				$name = rawurlencode($this->parent->name).'/'.$this->index_in_parent;
			if(Message::formatted_like_an_id($this->message_id))
				return site_url('inbox/message/'.$this->message_id.'/attachments/download/format/pdf/'.$name);
			return site_url('inbox/compose/draft/attachments/download/format/pdf/'.$name);
		}else{
			$this->error->notice('Attachment::url_for_download_for_pdf() cannot be used until it is defined by an application extension');
		}
	}
	
	function view(){
		echo $this->transformed_markup();
	}

	function save_to_das(){
		$CI = get_instance();
		require_model('DAS_log_entry');
		
		//reset any stored error messages before we try again
		if(isset($this->das_user_friendly_error_message))
			$this->das_user_friendly_error_message = null;
		
		//Hash File name to save on DAS
		$filename_hash = sha1($this->message_id." ".$this->name);
		
		$boundary = sha1($filename_hash.microtime());
		$post_data = '--'.$boundary."\r\n";
		$post_data .= 'Content-Disposition: form-data; name="file"; filename="'.$this->name.'"'."\r\n";
		$post_data .= 'Content-Type: text/xml'."\r\n\r\n";
		$post_data .= $this->binary_string."\r\n";
		$post_data .= '--'.$boundary."\r\n";
		
		//Curl to DAS server
		$headers = array('Content-Type: multipart/form-data; boundary='.$boundary, 'Content-Desc: cda/xml');
		$url = VLERDAS_PROTOCOL.'://'.VLERDAS_HOSTNAME.':'.VLERDAS_PORT.'/'.VLERDAS_ECRUD_RESOURCE.'/'.VLERDAS_DATABASE.'/'.VLERDAS_COLLECTION;
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL,            $url );
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
		curl_setopt($ch, CURLOPT_TIMEOUT,        10);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true );
		curl_setopt($ch, CURLOPT_POST,           TRUE);
		curl_setopt($ch, CURLOPT_POSTFIELDS,    $post_data);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true );
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, TLS_SERVER_VERIFYHOST );
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, TLS_SERVER_VERIFYPEER );
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_SSLCERT, TLS_SERVER_CERT_PATH);
		curl_setopt($ch, CURLOPT_SSLKEY, TLS_SERVER_KEY_PATH);
		$result = curl_exec($ch);
		$response = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE);
		
		//if we got back a successful response, log our success and rejoice
		if(in_array($response, array(200, 201, 202))){
			$response_message = 'The attachment was saved successfully.';
			$json = $CI->json->decode($result);
			$document_id = ($json !== FALSE ? $json[0]->_id : null);
			
			$values_for_log = array(  'saved_date' => time(),
									  'result_status' => $response,
									  'attachment_name' => $this->name,
									  'message_id' => $this->message_id,
									  'hash_attachment_name' => $filename_hash,
									  'das_document_id' => $document_id);
			
			if(isset($CI->user) && DAS_log_entry::field_exists('created_by'))
				$values_for_log['created_by'] = $CI->user->username; //at this point, we don't log created_by in api - build this so that it will be available whenever the field is
									  
			if(!DAS_log_entry::create($values_for_log))
				$this->error->warning('Failed to save DAS log entry for '.$this->describe().': attachment was successfully saved to DAS at '.time());
				
			return true;
		}
		
		if(in_array($response, array(500, 502, 503))){
			$this->das_user_friendly_error_message =  'The DAS server cannot be reached at this time. Please try again in a moment, and contact an administrator if the problem persists.';
		}else{
			$this->das_user_friendly_error_message = 'An error occurred while saving the attchment to DAS. Please try again in a moment, and contact an administrator if the problem persists.';
		}
		
		return $this->error->warning('An error occurred while saving '.$this->describe().' to DAS.  HTTP code from DAS call: '.$response);
	}
	
////////////////////
// GETTERS
////////////////////

	//in an ideal world, we would only make this available in a DPII extension, but we need other child attachment classes to be able to extend this class
	//so, we'll just test to see if required model is available before attempting to populate the value
	function das_save_date($format = null){
		if(get_instance()->load->model_exists('das_log_entry')){
			require_model('das_log_entry');		
			if(!isset($this->_das_save_date) && $this->schema == 'C32'){
				get_instance()->db->select('id, message_id, saved_date')->order_by('saved_date', 'desc');
				$saved_info = DAS_log_entry::find_one_for_attachment($this);
				if(DAS_log_entry::is_an_entity($saved_info)){ $this->_das_save_date = $saved_info->saved_date; }
			}
			if(!is_null($format) && isset($this->_das_save_date)){ return date($format, $this->_das_save_date);}
			return $this->_das_save_date;
		}
	}

	function description(){
		if(!isset($this->_description) && isset($this->binary_string)){
			if(is_object($this->parser)){
				$this->_description = $this->parser->description();
			}
		}
		return $this->_description;
	}		

//////////////////////
// SETTERS
//////////////////////

	function set_ssn($value){
		if(is_numeric($value) && strlen($value) == 9){
			$value = substr($value, 0, 3).'-'.substr($value, 3, 2).'-'.substr($value, 5, 4);
		}
		
		if(!$this->is->string_like_a_social_security_number($value)) return $this->error->property_value_should_be_a_ssn('ssn', $this, $value);	
		$this->_ssn = $value;
	}

	function transformed_markup(){
		if(!isset($this->_transformed_markup)){	
			if($this->property_is_empty('xsl_path') || !file_exists(APPPATH.$this->xsl_path))
				return $this->error->warning("I can't transform the markup for ".$this->describe().' without a valid xsl location, but you gave me '.$this->error->describe($this->xsl_path));
		
				$xml = new DOMDocument; //load xml
				if($xml->loadXml($this->binary_string)){
		
				$xsl = new DOMDocument; //load xsl
				$xsl->loadXml(file_get_contents(APPPATH.$this->xsl_path));
				$proc = new XSLTProcessor;
				$proc->importStyleSheet($xsl); // attach the xsl rules
				$this->_transformed_markup = $proc->transformToXML($xml);
				}
		}
		return $this->_transformed_markup;
	}		
	
/////////////////////
// STATIC FUNCTIONS
/////////////////////

	public static function create($name, $binary_string, $more_values = array()){
		log_message('debug','Who called this PDA(create) ' . debug_backtrace()[1]['class'].':'.debug_backtrace()[1]['function']);
		$matches_file = static::matches_file($name, $binary_string);
		if(!$matches_file) {
		    return get_instance()->error->should_be_an_x('name of a '.humanize(get_called_class()).' file', $name);
        }
		
		if (empty($more_values['pda_class'])) {
			foreach(static::$patient_document_classes as $patient_document_class){
				require_library('attachments/'.$patient_document_class);
				if($patient_document_class::matches_file($name, $binary_string)){
					$values = array(
						'name' => $name,
						'binary_string' => $binary_string,
						'pda_class' => $patient_document_class,
					);
					$values = array_merge($values, $more_values);
					return new $patient_document_class($values);
				}
			}
		}
		
		trigger_error($name.' does not match a known patient document class', E_USER_WARNING);
        $values = array(
            'name' => $name,
            'binary_string' => $binary_string,
        );
		return new Patient_document_attachment(array_merge($values, $more_values));
	}

	public static function matches_file($name, $binary_string, $valid_xml = false){
		log_message('debug','Who called this PDA(matches_file) ' . debug_backtrace()[1]['class'].':'.debug_backtrace()[1]['function']);
		if (!$valid_xml) {
			$matches_file = parent::matches_file($name, $binary_string);
			if(!$matches_file) return false;
		}
		$patient_document_classes = static::$patient_document_classes;
		foreach($patient_document_classes as $patient_document_class){
			require_library('attachments/'.$patient_document_class);
			if($patient_document_class::matches_file($name, $binary_string, true)){
				return true;
			}
		} 
		return false;	
	}
	
}
