<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* Any changes to this library need to be made in both Webmail and the API.
* @package vler
* @subpackage libraries
*/

class Csv_attachment extends Attachment{

	protected static $extensions = array('csv');
	protected $_content_as_array;
	protected $_has_headers = true;
	protected $_headers;

///////////////////////
// PROTECTED METHODS
///////////////////////

	//could validate the number of columns and the expected headers by comparing to this method
	protected function headers(){
		if(!isset($this->_headers)){
			if($this->has_headers && !$this->property_is_empty('binary_string')){
				return array_keys(first_element($this->content_as_array));
			}
		}
		return $this->_headers;
	}

	protected function content_as_array(){
		if(!isset($this->_content_as_array) && !$this->property_is_empty('binary_string')){

			//by default, str_getcsv doesn't parse the rows, so here's a work around
			$rows = str_getcsv($this->binary_string, "\n"); //parse the rows
			if($this->has_headers){
				$headers = str_getcsv(first_element($rows));
				array_shift($rows); //remove the headers from the result
			}

			foreach($rows as &$row){
				$row = str_getcsv($row); //parse the items in rows
				if($this->has_headers)
					$row = array_combine($headers, $row);
			}

			$this->_content_as_array = $rows;
		}
		return $this->_content_as_array;
	}

/////////////////////
// STATIC METHODS
/////////////////////

	public static function create($name, $binary_string, $more_values = array()){
		$class = get_called_class();
		if(!static::matches_file($name, $binary_string)) {
		    return get_instance()->error->should_be_an_x('name of a '.humanize($class).' file', $name);
        }
        $values = array(
            'name' => $name,
            'binary_string' => $binary_string,
        );
        $values = array_merge($values, $more_values);
		return new $class($values);
	}

	public static function create_from_path($path, $more_values = array()){
		$CI = get_instance();
		if(!$CI->is->file_path($path)) return $CI->error->should_be_an_existing_file_path($path);
		$name = basename($path);
		$directory = strip_from_end($name, $path);
		return static::create($name, file_get_contents($path), compact('directory'));
	}

	public static function matches_file($name, $binary_string){
		if(!parent::matches_file($name, $binary_string)) return false;
		return in_array(strtolower(pathinfo($name, PATHINFO_EXTENSION)), static::$extensions);
	}

}
