<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package vler
* @subpackage libraries
*//** */
 
/**
* @package vler
* @subpackage libraries
*/
class Locale {
	static protected $timezones = array("Africa/Abidjan" => 0,
										"Africa/Accra" => 1,
										"Africa/Addis_Ababa" => 2,
										"Africa/Algiers" => 3,
										"Africa/Asmara" => 4,
										"Africa/Bamako" => 5,
										"Africa/Bangui" => 6,
										"Africa/Banjul" => 7,
										"Africa/Bissau" => 8,
										"Africa/Blantyre" => 9,
										"Africa/Brazzaville" => 10,
										"Africa/Bujumbura" => 11,
										"Africa/Cairo" => 12,
										"Africa/Casablanca" => 13,
										"Africa/Ceuta" => 14,
										"Africa/Conakry" => 15,
										"Africa/Dakar" => 16,
										"Africa/Dar_es_Salaam" => 17,
										"Africa/Djibouti" => 18,
										"Africa/Douala" => 19,
										"Africa/El_Aaiun" => 20,
										"Africa/Freetown" => 21,
										"Africa/Gaborone" => 22,
										"Africa/Harare" => 23,
										"Africa/Johannesburg" => 24,
										"Africa/Juba" => 25,
										"Africa/Kampala" => 26,
										"Africa/Khartoum" => 27,
										"Africa/Kigali" => 28,
										"Africa/Kinshasa" => 29,
										"Africa/Lagos" => 30,
										"Africa/Libreville" => 31,
										"Africa/Lome" => 32,
										"Africa/Luanda" => 33,
										"Africa/Lubumbashi" => 34,
										"Africa/Lusaka" => 35,
										"Africa/Malabo" => 36,
										"Africa/Maputo" => 37,
										"Africa/Maseru" => 38,
										"Africa/Mbabane" => 39,
										"Africa/Mogadishu" => 40,
										"Africa/Monrovia" => 41,
										"Africa/Nairobi" => 42,
										"Africa/Ndjamena" => 43,
										"Africa/Niamey" => 44,
										"Africa/Nouakchott" => 45,
										"Africa/Ouagadougou" => 46,
										"Africa/Porto-Novo" => 47,
										"Africa/Sao_Tome" => 48,
										"Africa/Tripoli" => 49,
										"Africa/Tunis" => 50,
										"Africa/Windhoek" => 51,
										"America/Adak" => 52,
										"America/Anchorage" => 53,
										"America/Anguilla" => 54,
										"America/Antigua" => 55,
										"America/Araguaina" => 56,
										"America/Argentina/Buenos_Aires" => 57,
										"America/Argentina/Catamarca" => 58,
										"America/Argentina/Cordoba" => 59,
										"America/Argentina/Jujuy" => 60,
										"America/Argentina/La_Rioja" => 61,
										"America/Argentina/Mendoza" => 62,
										"America/Argentina/Rio_Gallegos" => 63,
										"America/Argentina/Salta" => 64,
										"America/Argentina/San_Juan" => 65,
										"America/Argentina/San_Luis" => 66,
										"America/Argentina/Tucuman" => 67,
										"America/Argentina/Ushuaia" => 68,
										"America/Aruba" => 69,
										"America/Asuncion" => 70,
										"America/Atikokan" => 71,
										"America/Bahia" => 72,
										"America/Bahia_Banderas" => 73,
										"America/Barbados" => 74,
										"America/Belem" => 75,
										"America/Belize" => 76,
										"America/Blanc-Sablon" => 77,
										"America/Boa_Vista" => 78,
										"America/Bogota" => 79,
										"America/Boise" => 80,
										"America/Cambridge_Bay" => 81,
										"America/Campo_Grande" => 82,
										"America/Cancun" => 83,
										"America/Caracas" => 84,
										"America/Cayenne" => 85,
										"America/Cayman" => 86,
										"America/Chicago" => 87,
										"America/Chihuahua" => 88,
										"America/Costa_Rica" => 89,
										"America/Creston" => 90,
										"America/Cuiaba" => 91,
										"America/Curacao" => 92,
										"America/Danmarkshavn" => 93,
										"America/Dawson" => 94,
										"America/Dawson_Creek" => 95,
										"America/Denver" => 96,
										"America/Detroit" => 97,
										"America/Dominica" => 98,
										"America/Edmonton" => 99,
										"America/Eirunepe" => 100,
										"America/El_Salvador" => 101,
										"America/Fortaleza" => 102,
										"America/Glace_Bay" => 103,
										"America/Godthab" => 104,
										"America/Goose_Bay" => 105,
										"America/Grand_Turk" => 106,
										"America/Grenada" => 107,
										"America/Guadeloupe" => 108,
										"America/Guatemala" => 109,
										"America/Guayaquil" => 110,
										"America/Guyana" => 111,
										"America/Halifax" => 112,
										"America/Havana" => 113,
										"America/Hermosillo" => 114,
										"America/Indiana/Indianapolis" => 115,
										"America/Indiana/Knox" => 116,
										"America/Indiana/Marengo" => 117,
										"America/Indiana/Petersburg" => 118,
										"America/Indiana/Tell_City" => 119,
										"America/Indiana/Vevay" => 120,
										"America/Indiana/Vincennes" => 121,
										"America/Indiana/Winamac" => 122,
										"America/Inuvik" => 123,
										"America/Iqaluit" => 124,
										"America/Jamaica" => 125,
										"America/Juneau" => 126,
										"America/Kentucky/Louisville" => 127,
										"America/Kentucky/Monticello" => 128,
										"America/Kralendijk" => 129,
										"America/La_Paz" => 130,
										"America/Lima" => 131,
										"America/Los_Angeles" => 132,
										"America/Lower_Princes" => 133,
										"America/Maceio" => 134,
										"America/Managua" => 135,
										"America/Manaus" => 136,
										"America/Marigot" => 137,
										"America/Martinique" => 138,
										"America/Matamoros" => 139,
										"America/Mazatlan" => 140,
										"America/Menominee" => 141,
										"America/Merida" => 142,
										"America/Metlakatla" => 143,
										"America/Mexico_City" => 144,
										"America/Miquelon" => 145,
										"America/Moncton" => 146,
										"America/Monterrey" => 147,
										"America/Montevideo" => 148,
										"America/Montreal" => 149,
										"America/Montserrat" => 150,
										"America/Nassau" => 151,
										"America/New_York" => 152,
										"America/Nipigon" => 153,
										"America/Nome" => 154,
										"America/Noronha" => 155,
										"America/North_Dakota/Beulah" => 156,
										"America/North_Dakota/Center" => 157,
										"America/North_Dakota/New_Salem" => 158,
										"America/Ojinaga" => 159,
										"America/Panama" => 160,
										"America/Pangnirtung" => 161,
										"America/Paramaribo" => 162,
										"America/Phoenix" => 163,
										"America/Port-au-Prince" => 164,
										"America/Port_of_Spain" => 165,
										"America/Porto_Velho" => 166,
										"America/Puerto_Rico" => 167,
										"America/Rainy_River" => 168,
										"America/Rankin_Inlet" => 169,
										"America/Recife" => 170,
										"America/Regina" => 171,
										"America/Resolute" => 172,
										"America/Rio_Branco" => 173,
										"America/Santa_Isabel" => 174,
										"America/Santarem" => 175,
										"America/Santiago" => 176,
										"America/Santo_Domingo" => 177,
										"America/Sao_Paulo" => 178,
										"America/Scoresbysund" => 179,
										"America/Shiprock" => 180,
										"America/Sitka" => 181,
										"America/St_Barthelemy" => 182,
										"America/St_Johns" => 183,
										"America/St_Kitts" => 184,
										"America/St_Lucia" => 185,
										"America/St_Thomas" => 186,
										"America/St_Vincent" => 187,
										"America/Swift_Current" => 188,
										"America/Tegucigalpa" => 189,
										"America/Thule" => 190,
										"America/Thunder_Bay" => 191,
										"America/Tijuana" => 192,
										"America/Toronto" => 193,
										"America/Tortola" => 194,
										"America/Vancouver" => 195,
										"America/Whitehorse" => 196,
										"America/Winnipeg" => 197,
										"America/Yakutat" => 198,
										"America/Yellowknife" => 199,
										"Antarctica/Casey" => 200,
										"Antarctica/Davis" => 201,
										"Antarctica/DumontDUrville" => 202,
										"Antarctica/Macquarie" => 203,
										"Antarctica/Mawson" => 204,
										"Antarctica/McMurdo" => 205,
										"Antarctica/Palmer" => 206,
										"Antarctica/Rothera" => 207,
										"Antarctica/South_Pole" => 208,
										"Antarctica/Syowa" => 209,
										"Antarctica/Vostok" => 210,
										"Arctic/Longyearbyen" => 211,
										"Asia/Aden" => 212,
										"Asia/Almaty" => 213,
										"Asia/Amman" => 214,
										"Asia/Anadyr" => 215,
										"Asia/Aqtau" => 216,
										"Asia/Aqtobe" => 217,
										"Asia/Ashgabat" => 218,
										"Asia/Baghdad" => 219,
										"Asia/Bahrain" => 220,
										"Asia/Baku" => 221,
										"Asia/Bangkok" => 222,
										"Asia/Beirut" => 223,
										"Asia/Bishkek" => 224,
										"Asia/Brunei" => 225,
										"Asia/Choibalsan" => 226,
										"Asia/Chongqing" => 227,
										"Asia/Colombo" => 228,
										"Asia/Damascus" => 229,
										"Asia/Dhaka" => 230,
										"Asia/Dili" => 231,
										"Asia/Dubai" => 232,
										"Asia/Dushanbe" => 233,
										"Asia/Gaza" => 234,
										"Asia/Harbin" => 235,
										"Asia/Hebron" => 236,
										"Asia/Ho_Chi_Minh" => 237,
										"Asia/Hong_Kong" => 238,
										"Asia/Hovd" => 239,
										"Asia/Irkutsk" => 240,
										"Asia/Jakarta" => 241,
										"Asia/Jayapura" => 242,
										"Asia/Jerusalem" => 243,
										"Asia/Kabul" => 244,
										"Asia/Kamchatka" => 245,
										"Asia/Karachi" => 246,
										"Asia/Kashgar" => 247,
										"Asia/Kathmandu" => 248,
										"Asia/Kolkata" => 249,
										"Asia/Krasnoyarsk" => 250,
										"Asia/Kuala_Lumpur" => 251,
										"Asia/Kuching" => 252,
										"Asia/Kuwait" => 253,
										"Asia/Macau" => 254,
										"Asia/Magadan" => 255,
										"Asia/Makassar" => 256,
										"Asia/Manila" => 257,
										"Asia/Muscat" => 258,
										"Asia/Nicosia" => 259,
										"Asia/Novokuznetsk" => 260,
										"Asia/Novosibirsk" => 261,
										"Asia/Omsk" => 262,
										"Asia/Oral" => 263,
										"Asia/Phnom_Penh" => 264,
										"Asia/Pontianak" => 265,
										"Asia/Pyongyang" => 266,
										"Asia/Qatar" => 267,
										"Asia/Qyzylorda" => 268,
										"Asia/Rangoon" => 269,
										"Asia/Riyadh" => 270,
										"Asia/Sakhalin" => 271,
										"Asia/Samarkand" => 272,
										"Asia/Seoul" => 273,
										"Asia/Shanghai" => 274,
										"Asia/Singapore" => 275,
										"Asia/Taipei" => 276,
										"Asia/Tashkent" => 277,
										"Asia/Tbilisi" => 278,
										"Asia/Tehran" => 279,
										"Asia/Thimphu" => 280,
										"Asia/Tokyo" => 281,
										"Asia/Ulaanbaatar" => 282,
										"Asia/Urumqi" => 283,
										"Asia/Vientiane" => 284,
										"Asia/Vladivostok" => 285,
										"Asia/Yakutsk" => 286,
										"Asia/Yekaterinburg" => 287,
										"Asia/Yerevan" => 288,
										"Atlantic/Azores" => 289,
										"Atlantic/Bermuda" => 290,
										"Atlantic/Canary" => 291,
										"Atlantic/Cape_Verde" => 292,
										"Atlantic/Faroe" => 293,
										"Atlantic/Madeira" => 294,
										"Atlantic/Reykjavik" => 295,
										"Atlantic/South_Georgia" => 296,
										"Atlantic/St_Helena" => 297,
										"Atlantic/Stanley" => 298,
										"Australia/Adelaide" => 299,
										"Australia/Brisbane" => 300,
										"Australia/Broken_Hill" => 301,
										"Australia/Currie" => 302,
										"Australia/Darwin" => 303,
										"Australia/Eucla" => 304,
										"Australia/Hobart" => 305,
										"Australia/Lindeman" => 306,
										"Australia/Lord_Howe" => 307,
										"Australia/Melbourne" => 308,
										"Australia/Perth" => 309,
										"Australia/Sydney" => 310,
										"Europe/Amsterdam" => 311,
										"Europe/Andorra" => 312,
										"Europe/Athens" => 313,
										"Europe/Belgrade" => 314,
										"Europe/Berlin" => 315,
										"Europe/Bratislava" => 316,
										"Europe/Brussels" => 317,
										"Europe/Bucharest" => 318,
										"Europe/Budapest" => 319,
										"Europe/Chisinau" => 320,
										"Europe/Copenhagen" => 321,
										"Europe/Dublin" => 322,
										"Europe/Gibraltar" => 323,
										"Europe/Guernsey" => 324,
										"Europe/Helsinki" => 325,
										"Europe/Isle_of_Man" => 326,
										"Europe/Istanbul" => 327,
										"Europe/Jersey" => 328,
										"Europe/Kaliningrad" => 329,
										"Europe/Kiev" => 330,
										"Europe/Lisbon" => 331,
										"Europe/Ljubljana" => 332,
										"Europe/London" => 333,
										"Europe/Luxembourg" => 334,
										"Europe/Madrid" => 335,
										"Europe/Malta" => 336,
										"Europe/Mariehamn" => 337,
										"Europe/Minsk" => 338,
										"Europe/Monaco" => 339,
										"Europe/Moscow" => 340,
										"Europe/Oslo" => 341,
										"Europe/Paris" => 342,
										"Europe/Podgorica" => 343,
										"Europe/Prague" => 344,
										"Europe/Riga" => 345,
										"Europe/Rome" => 346,
										"Europe/Samara" => 347,
										"Europe/San_Marino" => 348,
										"Europe/Sarajevo" => 349,
										"Europe/Simferopol" => 350,
										"Europe/Skopje" => 351,
										"Europe/Sofia" => 352,
										"Europe/Stockholm" => 353,
										"Europe/Tallinn" => 354,
										"Europe/Tirane" => 355,
										"Europe/Uzhgorod" => 356,
										"Europe/Vaduz" => 357,
										"Europe/Vatican" => 358,
										"Europe/Vienna" => 359,
										"Europe/Vilnius" => 360,
										"Europe/Volgograd" => 361,
										"Europe/Warsaw" => 362,
										"Europe/Zagreb" => 363,
										"Europe/Zaporozhye" => 364,
										"Europe/Zurich" => 365,
										"Indian/Antananarivo" => 366,
										"Indian/Chagos" => 367,
										"Indian/Christmas" => 368,
										"Indian/Cocos" => 369,
										"Indian/Comoro" => 370,
										"Indian/Kerguelen" => 371,
										"Indian/Mahe" => 372,
										"Indian/Maldives" => 373,
										"Indian/Mauritius" => 374,
										"Indian/Mayotte" => 375,
										"Indian/Reunion" => 376,
										"Pacific/Apia" => 377,
										"Pacific/Auckland" => 378,
										"Pacific/Chatham" => 379,
										"Pacific/Chuuk" => 380,
										"Pacific/Easter" => 381,
										"Pacific/Efate" => 382,
										"Pacific/Enderbury" => 383,
										"Pacific/Fakaofo" => 384,
										"Pacific/Fiji" => 385,
										"Pacific/Funafuti" => 386,
										"Pacific/Galapagos" => 387,
										"Pacific/Gambier" => 388,
										"Pacific/Guadalcanal" => 389,
										"Pacific/Guam" => 390,
										"Pacific/Honolulu" => 391,
										"Pacific/Johnston" => 392,
										"Pacific/Kiritimati" => 393,
										"Pacific/Kosrae" => 394,
										"Pacific/Kwajalein" => 395,
										"Pacific/Majuro" => 396,
										"Pacific/Marquesas" => 397,
										"Pacific/Midway" => 398,
										"Pacific/Nauru" => 399,
										"Pacific/Niue" => 400,
										"Pacific/Norfolk" => 401,
										"Pacific/Noumea" => 402,
										"Pacific/Pago_Pago" => 403,
										"Pacific/Palau" => 404,
										"Pacific/Pitcairn" => 405,
										"Pacific/Pohnpei" => 406,
										"Pacific/Port_Moresby" => 407,
										"Pacific/Rarotonga" => 408,
										"Pacific/Saipan" => 409,
										"Pacific/Tahiti" => 410,
										"Pacific/Tarawa" => 411,
										"Pacific/Tongatapu" => 412,
										"Pacific/Wake" => 413,
										"Pacific/Wallis" => 414,
										"UTC" => 415,
									);
	static protected $countries = array(
								"AF" => "Afghanistan",  
								"AX" => "Åland Islands",  
								"AL" => "Albania ",  
								"DZ" => "Algeria ",  
								"AS" => "American Samoa",  
								"AD" => "Andorra",  
								"AO" => "Angola ",
								"AI" => "Anguilla ",
								"AQ" => "Antarctica ",
								"AG" => "Antigua and Barbuda ",
								"AR" => "Argentina",
								"AU" => "Australia ",
								"AT" => "Austria ",
								"AZ" => "Azerbaijan",
								"BS" => "Bahamas ",
								"BH" => "Bahrain ",
								"BD" => "Bangladesh ",
								"BB" => "Barbados ",
								"BY" => "Belarus",
								"BE" => "Belgium ",
								"BZ" => "Belize ",
								"BJ" => "Benin ",
								"BM" => "Bermuda ",
								"BT" => "Bhutan",
								"BO" => "Bolivia ",
								"BA" => "Bosnia and Herzegovina ",
								"BW" => "Botswana ",
								"BV" => "Bouvet Island ",
								"BR" => "Brazil",
								"IO" => "British Indian Ocean Territory ",
								"BN" => "Brunei Darussalam ",
								"BG" => "Bulgaria ",
								"BF" => "Burkina Faso ",
								"BI" => "Burundi",
								"KH" => "Cambodia ",
								"CM" => "Cameroon ",
								"CA" => "Canada ",
								"CV" => "Cape Verde ",
								"KY" => "Cayman Islands ",
								"CF" => "Central African Republic ",
								"TD" => "Chad ",
								"CL" => "Chile ",
								"CN" => "China ",
								"CX" => "Christmas Island",
								"CC" => "Cocos (Keeling) Islands ",
								"CO" => "Colombia ",
								"KM" => "Comoros ",
								"CG" => "Congo ",
								"CD" => "Congo, the Democratic Republic of the",
								"CK" => "Cook Islands ",
								"CR" => "Costa Rica ",
								"CI" => "Côte D'Ivoire",
								"HR" => "Croatia ",
								"CU" => "Cuba ",
								"CY" => "Cyprus ",
								"CZ" => "Czech Republic ",
								"DK" => "Denmark",
								"DJ" => "Djibouti ",
								"DM" => "Dominica ",
								"DO" => "Dominican Republic ",
								"EC" => "Ecuador ",
								"EG" => "Egypt",
								"SV" => "El Salvador ",
								"GQ" => "Equatorial Guinea ",
								"ER" => "Eritrea ",
								"EE" => "Estonia ",
								"ET" => "Ethiopia ",
								"FK" => "Falkland Islands (Malvinas) ",
								"FO" => "Faroe Islands ",
								"FJ" => "Fiji ",
								"FI" => "Finland ",
								"FR" => "France",
								"GF" => "French Guiana ",
								"PF" => "French Polynesia ",
								"TF" => "French Southern Territories ",
								"GA" => "Gabon ",
								"GM" => "Gambia ",
								"GE" => "Georgia ",
								"DE" => "Germany ",
								"GH" => "Ghana ",
								"GI" => "Gibraltar ",
								"GR" => "Greece",
								"GL" => "Greenland ",
								"GD" => "Grenada ",
								"GP" => "Guadeloupe ",
								"GU" => "Guam ",
								"GT" => "Guatemala",
								"GG" => "Guernsey ",
								"GN" => "Guinea ",
								"GW" => "Guinea-Bissau ",
								"GY" => "Guyana ",
								"HT" => "Haiti",
								"HM" => "Heard Island and Mcdonald Islands ",
								"VA" => "Holy See (Vatican City State) ",
								"HN" => "Honduras ",
								"HK" => "Hong Kong ",
								"HU" => "Hungary",
								"IS" => "Iceland ",
								"IN" => "India ",
								"ID" => "Indonesia ",
								"IR" => "Iran, Islamic Republic of ",
								"IQ" => "Iraq ",
								"IE" => "Ireland ",
								"IM" => "Isle of Man ",
								"IL" => "Israel ",
								"IT" => "Italy ",
								"JM" => "Jamaica",
								"JP" => "Japan ",
								"JE" => "Jersey ",
								"JO" => "Jordan ",
								"KZ" => "Kazakhstan ",
								"KE" => "Kenya",
								"KI" => "Kiribati ",
								"KP" => "Korea, Democratic People's Republic of ",
								"KR" => "Korea, Republic of ",
								"KW" => "Kuwait ",
								"KG" => "Kyrgyzstan",
								"LA" => "Lao People's Democratic Republic ",
								"LV" => "Latvia ",
								"LB" => "Lebanon ",
								"LS" => "Lesotho ",
								"LR" => "Liberia",
								"LY" => "Libyan Arab Jamahiriya ",
								"LI" => "Liechtenstein ",
								"LT" => "Lithuania ",
								"LU" => "Luxembourg ",
								"MO" => "Macao",
								"MK" => "Macedonia, the Former Yugoslav Republic of ",
								"MG" => "Madagascar ",
								"MW" => "Malawi ",
								"MY" => "Malaysia ",
								"MV" => "Maldives",
								"ML" => "Mali ",
								"MT" => "Malta ",
								"MH" => "Marshall Islands ",
								"MQ" => "Martinique ",
								"MR" => "Mauritania",
								"MU" => "Mauritius ",
								"YT" => "Mayotte ",
								"MX" => "Mexico ",
								"FM" => "Micronesia, Federated States of ",
								"MD" => "Moldova, Republic of",
								"MC" => "Monaco ",
								"MN" => "Mongolia ",
								"ME" => "Montenegro ",
								"MS" => "Montserrat ",
								"MA" => "Morocco",
								"MZ" => "Mozambique ",
								"MM" => "Myanmar ",
								"NA" => "Namibia ",
								"NR" => "Nauru ",
								"NP" => "Nepal",
								"NL" => "Netherlands ",
								"AN" => "Netherlands Antilles ",
								"NC" => "New Caledonia ",
								"NZ" => "New Zealand ",
								"NI" => "Nicaragua",
								"NE" => "Niger ",
								"NG" => "Nigeria ",
								"NU" => "Niue ",
								"NF" => "Norfolk Island ",
								"MP" => "Northern Mariana Islands",
								"NO" => "Norway ",
								"OM" => "Oman ",
								"PK" => "Pakistan ",
								"PW" => "Palau ",
								"PS" => "Palestinian Territory, Occupied",
								"PA" => "Panama ",
								"PG" => "Papua New Guinea ",
								"PY" => "Paraguay ",
								"PE" => "Peru ",
								"PH" => "Philippines",
								"PN" => "Pitcairn ",
								"PL" => "Poland ",
								"PT" => "Portugal ",
								"PR" => "Puerto Rico ",
								"QA" => "Qatar",
								"RE" => "Réunion ",
								"RO" => "Romania ",
								"RU" => "Russian Federation ",
								"RW" => "Rwanda ",
								"SH" => "Saint Helena",
								"KN" => "Saint Kitts and Nevis ",
								"LC" => "Saint Lucia ",
								"PM" => "Saint Pierre and Miquelon ",
								"VC" => "Saint Vincent and the Grenadines ",
								"WS" => "Samoa",
								"SM" => "San Marino ",
								"ST" => "Sao Tome and Principe ",
								"SA" => "Saudi Arabia ",
								"SN" => "Senegal ",
								"RS" => "Serbia",
								"SC" => "Seychelles ",
								"SL" => "Sierra Leone ",
								"SG" => "Singapore ",
								"SK" => "Slovakia ",
								"SI" => "Slovenia",
								"SB" => "Solomon Islands ",
								"SO" => "Somalia ",
								"ZA" => "South Africa ",
								"GS" => "South Georgia and the South Sandwich Islands ",
								"ES" => "Spain",
								"LK" => "Sri Lanka ",
								"SD" => "Sudan ",
								"SR" => "Suriname ",
								"SJ" => "Svalbard and Jan Mayen ",
								"SZ" => "Swaziland",
								"SE" => "Sweden ",
								"CH" => "Switzerland ",
								"SY" => "Syrian Arab Republic ",
								"TW" => "Taiwan, Province of China ",
								"TJ" => "Tajikistan",
								"TZ" => "Tanzania, United Republic of ",
								"TH" => "Thailand ",
								"TL" => "Timor-Leste ",
								"TG" => "Togo ",
								"TK" => "Tokelau",
								"TO" => "Tonga ",
								"TT" => "Trinidad and Tobago ",
								"TN" => "Tunisia ",
								"TR" => "Turkey ",
								"TM" => "Turkmenistan",
								"TC" => "Turks and Caicos Islands ",
								"TV" => "Tuvalu ",
								"UG" => "Uganda ",
								"UA" => "Ukraine ",
								"AE" => "United Arab Emirates",
								"GB" => "United Kingdom ",
								"US" => "United States ",
								"UM" => "United States Minor Outlying Islands ",
								"UY" => "Uruguay ",
								"UZ" => "Uzbekistan",
								"VU" => "Vanuatu ",
								"VA" => "Vatican City State ",
								"VE" => "Venezuela ",
								"VN" => "Viet Nam ",
								"VG" => "Virgin Islands, British ",
								"VI" => "Virgin Islands, U.S. ",
								"WF" => "Wallis and Futuna",
								"EH" => "Western Sahara ",
								"YE" => "Yemen ",
								"CD" => "Zaire ",
								"ZM" => "Zambia ",
								"ZW" => "Zimbabwe ",
							   );

	
	public function get_id_from_timezone($string) {
		if(array_key_exists($string,static::$timezones)) {
			return static::$timezones[$string];
		}
		else { return FALSE; }
	}
	
	public function get_timezone_from_id($id) {
		foreach(static::$timezones as $timezone => $timezone_id) {
			if($id == $timezone_id) { return $timezone; }
		}
		return FALSE;
	}
	
	public function get_countries() {
		return static::$countries;
	}
	
	public function timezone_abbr_from_name($name) {
		if($name){
			$dateTime = new DateTime();
			$dateTime->setTimeZone(new DateTimeZone($name)); 
			return $dateTime->format('T'); 
		}
		return FALSE;
	}
}