<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package vler
* @subpackage libraries
*/ /** */

/**
* @package vler
* @subpackage libraries
*/ 
class JSON {
	protected $CI;

	public function __construct(){
		$this->CI = get_instance();
	}
	
	/**
	* Wrapper for the standard JSON encode method which triggers errors when things go wrong.
	* The standard {@link json_encode} method fails silently when it encounters formatting problems.  
	* We'd like it to trigger an informative PHP warning instead.
	* Also, this no longer escapes unicode by default
	* @param mixed
	* @param int
	* @param int
	* @return striing
	*/
	public function encode($value, $options = JSON_UNESCAPED_UNICODE, $depth = 512){
		$json = json_encode($value, $options, $depth);
		if(json_last_error() != JSON_ERROR_NONE){										
			$this->CI->error->warning('JSON encode error encountered while encoding '.$this->CI->error->describe($value).': '.json_last_error_msg(), 1);
		}
		if(!$this->is_valid($json)){
			$this->CI->error->warning('Unable to encode '.$this->CI->error->describe($value).' as valid JSON: '.$this->CI->error->describe($json));
		}
		
		return $json;
	}	

	/**
	* Wrapper for the standard JSON decode method which triggers errors when things go wrong.
	* The standard {@link json_decode} method fails silently when it encounters formatting problems.  
	* We'd like it to trigger an informative PHP warning instead.
	* @param string
	* @param boolean
	* @param int
	* @param int
	* @return array|object
	*/
	public function decode($json, $assoc = false, $depth = 512, $options = 0){
		if(!is_string($json)) return $this->CI->error->should_be_a_string($json);
		if(!is_bool($assoc)) return $this->CI->error->should_be_a_boolean($assoc);
		if(!is_int($depth)) return $this->CI->error->should_be_an_integer($depth);
		if(!is_int($options)) return $this->CI->error->should_be_an_integer($options);
	
		$json = trim($json);
		$result = json_decode($json, $assoc, $depth, $options);
		if(json_last_error() != JSON_ERROR_NONE){			
			$error_message = 'JSON decode error: '.json_last_error_msg();
			if(is_on_dev())
				$error_message .= "<br>\n\n JSON: ".$json."<br>\n\n"; //only uncomment this temporarily because it fills the logs up pretty fast */
			$this->CI->error->warning($error_message, 1);
		}
		return $result;
	}
	
	public function decode_as_array($json){
		$result = $this->decode($json, TRUE);
		//if we don't get an array back (because the json has errors) return an empty array 
		//json decode returns the json string if it fails to decode it, but that's not that helpful
		if(!is_array($result))
			return array();
		return $result;
	}
	
	public function decode_as_object($json){
		$result = $this->decode($json);
		//if we don't get an array back (because the json has errors) return an empty array 
		//json decode returns the json string if it fails to decode it, but that's not that helpfu
		if(!is_object($result))
			return (object)array();
		return $result;
	}
	
	/**
	* True if a string is correctly formatted JSON
	* @param string
	* @return boolean
	*/
	public function is_valid($json){
		if(!is_string($json)) return false;
		$json = trim($json);
		if(empty($json)) return false;
		json_decode($json);
		return json_last_error() == JSON_ERROR_NONE;
	}
	
	public function is_encodable($value, $options = JSON_UNESCAPED_UNICODE, $depth = 512){
		$json = json_encode($value, $options, $depth);
		return $this->is_valid($json);
	}
	

}
/* End of file Service_Call.php */
/* Location: ./application/libraries/Service_Call.php */