<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package vler
* @subpackage libraries
*/ /** */

require_library('email');

/**
* Extension of the CI Email library for sending messages to addresses that are *not* Direct addresses.
*
* Note that developer local environments have been configured not to send messages to external addresses in order to prevent undesired messages from being sent during development.
* You'll need to check the mail logs to see whether or not the message was sent. (Note - it is *highly* recommended that you use your own address as a test address at first to
* verify that this configuration is working in your environment.)
*
* @author Shawn Williams <williams_shawn@bah.com>
* @author Elan Jaffee <jaffee_elan@bah.com>
* @author Paul Hwa <hwa_weipo@bah.com>
* @author M. Gibbs <gibbs_margaret@bah.com>
*
* @package vler
* @subpackage libraries
*/
class External_email extends VLER_Email{
	
	public $smtp_host = GATEWAY_SMTP_HOSTNAME;
	public $smtp_port = GATEWAY_EXTERNAL_EMAIL_PORT;
	public $mailtype = 'html';
	public $protocol = DIRECT_SEND_PROTOCOL;
	public $smtp_timeout = GATEWAY_SMTP_TIMEOUT;
	public $priority = '3';
	
	
	/**
	* Extends parent to provide a default "From" address.
	* Default address is {@link EXTERNAL_EMAILS_FROM}.
	*
	* @param boolean
	* @return boolean
	*/
	public function send($auto_clear = TRUE){
		if (!isset($this->_headers['From'])){
			$this->from(EXTERNAL_EMAILS_FROM);
		}
		return parent::send($auto_clear);
	}	
}