<?php
/**
* @package icarus
* @subpackage libraries
*/

load_libraries('lister');

/**
* @package icarus
* @subpackage libraries
* @author M. Gibbs <gibbs_margaret@bah.com>
*/
class Entity_lister extends Lister{	
	protected $_model;
	protected $_method_for_list_generation = 'find';
	protected $_arguments_for_list_generation_method;
	protected $_method_for_list_count = 'count';
	protected $_arguments_for_list_count_method;
	protected $_apply_limit_to_list_generation = true;
	protected $_use_method_for_list_count;	//by default, true
	protected $_default_order_by = 'modified_at';

	protected $_property_validation_rules= array( 'apply_limit_to_list_generation' => 'boolean',
													'use_method_for_list_count' => 'boolean',
													'arguments_for_list_generation_method' => 'array',
													'arguments_for_list_count_method' => 'array'
												 );

	protected function _generate_list_items(){
		if($this->property_is_empty('model')) return $this->error->warning("I can't generate list items until the model value is set.");
		$model = $this->_model;
		
		if($this->apply_limit_to_list_generation)
			$model::db()->limit($this->items_per_page, $this->pagination_offset());
		
		$this->list_items_need_to_be_sorted = false;
		$model::db()->order_by($this->order_by, $this->order);	
		$use_method_for_list_count = $this->use_method_for_list_count;
		
		$method = $this->method_for_list_generation;
		if(!isset($this->arguments_for_list_generation_method))
			$entities = $model::$method();
		else
			$entities = call_user_func_array(array($model::model, $method), $this->arguments_for_list_generation_method);
		$this->set_list_items($entities);
		
		//the set_list_items method turns this off, but in this case, we want it to be whatever it was before we set the list items
		$this->use_method_for_list_count = $use_method_for_list_count; 
		
		//now that we've got the means to calculate the total pages, double-check that the page we're on is OK
		//note -- we could run the count method before the list generation method to check this first, but that would mess up any attempt to modify the query
		if($this->page > $this->total_pages())
			set_url_param_and_redirect('page', $this->total_pages());
	}
	
//////////////////////////////////////////////////////////
/// GETTERS
//////////////////////////////////////////////////////////	
//developers - the #@+ in the docblock below indicates that this docblock will be applied to every method until we hit the /**#@-*/ dockblock.
//please only place getter methods for protected variables in this section, or the documentation will be inaccurate.

/**#@+ 
* Accessor for protected variable.
*
* This is a getter method for a protected variable that has the same name as this method, but prefixed by an underscore.  
* 
* In general, you should not call on this method directly.  Call on the variable, but without the underscore in the name -- the {@link __get} method will
* call on any necessary accessor methods.
*/
	
	public function columns(){
		$columns = parent::columns();
		if(!isset($this->_columns) && empty($columns) && !$this->property_is_empty('model')){
			$model = $this->model;
			$this->_columns = $columns = $model::fields();
		}
		return $columns;			
	}
	
	public function default_order(){	
		if($this->order_by == 'modified_at') return 'desc';
		return $this->_default_order;
	}
	
	/**
	* Returns the list_items array if it's been set.
	* Otherwise, runs {@link _generate_list_items} to generate the list items if a method has been set.
	* @uses _generate_list_items
	* @return array
	*/
	public function list_items(){		
		if(!isset($this->list_items))	$this->_generate_list_items();
		return parent::list_items();
	}	
	
	function total_items(){			
		if(!isset($this->total_items) && $this->use_method_for_list_count){
			if(isset($this->model) &&  !$this->property_is_empty('method_for_list_count')){
				$model = $this->model; 
				$count_method = $this->method_for_list_count;
				if(!isset($this->arguments_for_list_count_method))
					$this->_total_items = $model::$count_method();
				else
					$this->_total_items = call_user_func_array(array($model, $count_method), $this->arguments_for_list_count_method);
			}
		}

		return parent::total_items();
	}
	
	function use_method_for_list_count(){
		if(isset($this->_use_method_for_list_count) && !$this->_use_method_for_list_count) return false;
		$model = $this->model;
		$is_possible = (isset($this->method_for_list_count) && isset($this->model) && method_exists($model, $this->method_for_list_count));
		if(isset($this->_use_method_for_list_count)) return ($this->_use_method_for_list_count && $is_possible);
		return $is_possible;
	}


/**#@-*/
	
//////////////////////////////////////////////////////////
/// SETTERS
//////////////////////////////////////////////////////////		

//developers - the #@+ in the docblock below indicates that this docblock will be applied to every method until we hit the /**#@-*/ dockblock.
//please only place setter methods for protected variables in this section, or the documentation will be inaccurate.

/**#@+ 
* Accessor for protected variable.
*
* This is a setter method for a protected variable that has the same name as this method, but prefixed by an underscore.  
* 
* In general, you should not call on this method directly.  Call on the variable, but without the underscore in the name -- the {@link __set} method will
* call on any necessary accessor methods.
*/

	/** @uses use_method_for_list_count */
	public function set_list_items($list_items){
		if(!isset($this->use_method_for_list_count)) $this->use_method_for_list_count = false;
		parent::set_list_items($list_items);
	}

	public function set_model($object_or_class_name){
		if($this->is->object($object_or_class_name)) 
			$class = get_class($object_or_class_name);
		elseif($this->is->nonempty_string_with_no_whitespace($object_or_class_name))
			$class = $object_or_class_name;
		else
			return $this->error->should_be_a_model_object_or_class_name($object_or_class_name);
			
		if(!$this->is->model_class($class)) return $this->error->should_be_a_model_class($class);
		
		require_model($class);
		$this->_model = ucfirst($class);
	}	
	
	public function set_method_for_list_generation($method_name){
		if(!$this->is->nonempty_string_with_no_whitespace($method_name)) return $this->error->should_be_a_nonempty_string_with_no_whitespace($method_name);
		if($this->property_is_empty('model')) return $this->error->warning("I can't set the value of method_for_list_generation until you've set a model for this lister");
		if(!method_exists($this->model, $method_name)) return $this->error->warning($method_name.' is not a valid method for model '.$this->model);
		$this->_method_for_list_generation = $method_name;
	}
	
	/** @uses use_method_for_list_count */
	public function set_method_for_list_count($method_name){
		if(!$this->is->nonempty_string_with_no_whitespace($method_name)) return $this->error->should_be_a_nonempty_string_with_no_whitespace($method_name);
		if($this->property_is_empty('model')) return $this->error->warning("I can't set the value of method_for_list_count until you've set a model for this lister");
		if(!method_exists($this->model, $method_name)) return $this->error->warning($method_name.' is not a valid method for model '.$this->model);
		$this->_method_for_list_count = $method_name;
		$this->use_method_for_list_count = true;
	}

/**#@-*/	
	
}