<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* Functions to access the CI loader when the CI instance is not in scope.
* @package vler
* @subpackage helpers
*/

if(!function_exists('load_helper')){
	/**
	* Shortcut to load a helper when you're outside of the CI instance.
	* This is particularly helpful when you want to load dependent helper files from within a helper or a library.
	* You should use this instead of directly including/requiring the file in order to ensure that any application-specific extensions get uploaded.
	* @param string Name of the helper (e.g. 'string', 'array', 'url', etc.)
	*/
	function load_helper($helper){
		$CI = get_instance();
		return $CI->load->helper($helper);
	}
}

if(!function_exists('load_helpers')){
	/**
	* Shortcut to load several helpers at once when you're outside of the CI instance.
	* Like {@link load_helper}, but allows you to load multiple helpers at once.  
	* This function can take any number of parameters; just enter the names of the helpers you need.
	* <code>load_helpers('array', 'string', 'url', 'inflector')</code>
	*/
	function load_helpers(){
		$array_of_helpers = func_get_args();
		foreach($array_of_helpers as $helper)
			load_helper($helper);
	}
}

if(!function_exists('load_library')){
	/**
	* Shortcut to load a library when you're outside of the CI instance.
	* This is particularly helpful when you want to load dependent library files from within a helper or a library.
	* You should use this instead of directly including/requiring the file in order to ensure that any application-specific extensions get uploaded.
	* @param string Name of the library (e.g. 'string', 'array', 'url', etc.)
	*/
	function load_library($library){
		$CI = get_instance();
		return $CI->load->library($library);
	}
}

if(!function_exists('load_libraries')){
	/**
	* Shortcut to load several libraries at once when you're outside of the CI instance.
	* Like {@link load_library}, but allows you to load multiple libraries at once.  
	* This function can take any number of parameters; just enter the names of the libraries you need.
	* <code>load_libraries('object', 'validator')</code>
	*/
	function load_libraries(){
		$array_of_libraries = func_get_args();
		foreach($array_of_libraries as $library){
			load_library($library);
		}
	}
}
	
if(!function_exists('class_name_for_model')){	
	function class_name_for_model($name){
		return get_instance()->load->class_name_for('model', $name);
	}
}
	
if(!function_exists('class_name_for_library')){		
	function class_name_for_library($name){
		return get_instance()->load->class_name_for('library', $name);
	}
}

if(!function_exists('new_instance_of')){	
	function new_instance_of($type, $name, $parameters){
		return get_instance()->load->new_instance_of($type, $name, $parameters);
	}
}

if(!function_exists('require_library')){	
	function require_library($library){
		return get_instance()->load->require_library($library);
	}
}
	
if(!function_exists('require_libraries')){	
	function require_libraries(){
		foreach(func_get_args() as $library){
			require_library($library);
		}
	}	
}
	
if(!function_exists('require_model')){		
	function require_model($model){
		return get_instance()->load->require_model($model);
	}
}
	
if(!function_exists('require_models')){		
	function require_models(){
		$models = func_get_args();
		if(count($models) == 1 && is_array(current($models)))
			$models = current($models);
		
		foreach($models as $model){
			require_model($model);
		}
	}
}