<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * @package vler
 * @subpackage helpers
 */
/**
 * @param $dirty_html
 * @return array|Purified|string
 */
function purify($dirty_html) {

    if (is_array($dirty_html)) {
        foreach ($dirty_html as $key => $val) {
            $dirty_html[$key] = purify(trim($val));
        }
        return $dirty_html;
    }

    $dirty_html = trim($dirty_html);
    if (empty($dirty_html)) {
        return $dirty_html;
    }

    require_once(VLERPATH."third_party/HTMLPurifier.standalone.php");

    $config = HTMLPurifier_Config::createDefault();
    $config->set('Core.Encoding', 'utf-8');
    $config->set('HTML.Doctype', 'XHTML 1.0 Strict');
    //$config->set('Core.AggressivelyRemoveScript', true);
    $config->set('HTML.ForbiddenElements', array('<script>','<iframe>'));
    $config->set('Core.EscapeNonASCIICharacters', true);
    $config->set('URI.DisableExternalResources', true);
    $config->set('HTML.Nofollow', true);
    $purifier = new HTMLPurifier($config);
    return $purifier->purify($dirty_html);
}
