<?php 
/**
* Extension of the Codeigniter URL helper.
*
* @see https://ellislab.com/codeigniter/user-guide/helpers/url_helper.html
*
* @package vler
* @subpackage helpers
*/

if(!function_exists('raw_http_build_query')){
	/**
	* @param array
	* @return string
	*/
	function raw_http_build_query($query_vars){
		if(empty($query_vars)) return '';
		
		foreach($query_vars as $key => $value){
			if(is_null($value))
				$query_vars[$key] = ''; //keep nulls from getting removed - due to type juggling during string converstion, this ends up being the same thing. -- 2015-09-16 MG
		}
		
		return http_build_query($query_vars, null, '&', PHP_QUERY_RFC3986); 	
	}
}

if ( ! function_exists('redirect'))
{
	/**
	* Redirecting means that we don't hit the post_system hooks, so we miss some of our performance logging.  Overriding the CI redirect function
	* to stay exactly the same, but hit the performance activities we would normally do in the post_system hook before executing the usual CI code
	* (We could just try to run the post_system hook, but we may in future add post system hooks that we don't want to hit when we're redirecting.)
	*
	* @param	string	$uri	URL
	* @param	string	$method	Redirect method - 'auto', 'location' or 'refresh'
	* @param	int	$code	HTTP Response status code
	*/
	function redirect($uri = '', $method = 'auto', $code = NULL){
		
		//START DSM MODIFICATION
		if(defined('ENABLE_PERFORMANCE_LOG') && ENABLE_PERFORMANCE_LOG){	
			write_benchmarks_to_log();
			write_api_calls_to_log();
		}
		//END DSM MODIFICATION - For future upgrades, we can just copy and paste the redirect function from here on
		
		
		if ( ! preg_match('#^(\w+:)?//#i', $uri))
		{
			$uri = site_url($uri);
		}

		// IIS environment likely? Use 'refresh' for better compatibility
		if ($method === 'auto' && isset($_SERVER['SERVER_SOFTWARE']) && strpos($_SERVER['SERVER_SOFTWARE'], 'Microsoft-IIS') !== FALSE)
		{
			$method = 'refresh';
		}
		elseif ($method !== 'refresh' && (empty($code) OR ! is_numeric($code)))
		{
			if (isset($_SERVER['SERVER_PROTOCOL'], $_SERVER['REQUEST_METHOD']) && $_SERVER['SERVER_PROTOCOL'] === 'HTTP/1.1')
			{
				$code = ($_SERVER['REQUEST_METHOD'] !== 'GET')
					? 303	// reference: http://en.wikipedia.org/wiki/Post/Redirect/Get
					: 307;
			}
			else
			{
				$code = 302;
			}
		}

		switch ($method)
		{
			case 'refresh':
				header('Refresh:0;url='.$uri);
				break;
			default:
				header('Location: '.$uri, TRUE, $code);
				break;
		}
		exit;
	}
}
