<?php 
/**
* Extension of the Codeigniter number helper.
*
* @see http://www.codeigniter.com/user_guide/helpers/number_helper.html
*
* @package vler
* @subpackage helpers
*/

//inverse of CI's byte_format function
//specifically intended to work with the shorthand used for PHP ini directives: http://php.net/manual/en/faq.using.php#faq.using.shorthandbytes
function bytes_from_shorthand($value) {
	if(!is_scalar($value)) should_be('scalar', $value);
	if(is_numeric($value)) return $value;
		
    $value = strtolower(trim($value));
	
	if(string_contains(' ', $value)){
		$pieces = explode(' ', $value);
		$quantity = first_element($pieces);
		$unit = last_element($pieces);
		if($unit == 'bytes') return $quantity;
	}else{
		$value = strip_from_end('b', $value);
		$quantity = substr($value, 0, -1);
		$unit = substr($value, -1);
	}
	
	$multipliers = array('k' => 1024, 'm' => 1048576, 'g' => 1073741824, 't' => 1099511627776);
	
	return $quantity * $multipliers[$unit];
}

//for configuration items like max_upload_size, PHP will return the shorthand text instead of the number of bytes (eg 512M)
//since that usually isn't helpful, reliably get back the the actual number in bytes
function ini_get_bytes($ini_var){
	return bytes_from_shorthand(ini_get($ini_var));
}