<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* Extension of Codeigniter's {@link http://codeigniter.com/user_guide/helpers/form_helper.html form_helper}.
*
* @package vler
* @subpackage helpers
*/

/**
* Hidden Input Field
*
* Generates hidden fields.  You can pass a simple key/value string or an associative
* array with multiple values.
*
* @access	public
* @param	mixed
* @param	string
* @return	string
*/ 
function form_hidden($name, $value = '', $id = FALSE, $class = FALSE, $recursing = FALSE){
	static $form;

	if ($recursing === FALSE)
	{
		$form = "\n";
	}

	if (is_array($name))
	{
		foreach ($name as $key => $val)
		{
			//if first param is array, and second is TRUE, assume we want the name to also be the id
			if($value === TRUE) { form_hidden($key, $val, $key, FALSE, TRUE); }
			//otherwise no id attribute will be added to these form elements
			else { form_hidden($key, $val, FALSE, FALSE, TRUE); }
		}
		return $form;
	}

	if(!is_array($value)){
		$attributes = array('type' => 'hidden',
							'name' => trim($name),
							'id' => trim($id),
							'class' => trim($class),
							'value' => html_escape($value));
		
		$form .= '<input '.key_value_implode_nonempty($attributes, '="', '" ').'" />'."\n";
	}
	else
	{
		foreach ($value as $k => $v)
		{
			$k = is_int($k) ? '' : $k;
			form_hidden($name.'['.$k.']', $v, $id, $class, TRUE);
		}
	}

	return $form;
}

//overrides parent to trigger a notice if this is called when the form validation library is not loaded.
function &_get_validation_object(){
	$CI =& get_instance();

	// We set this as a variable since we're returning by reference.
	$return = FALSE;
	
	$object = $CI->load->is_loaded('Form_validation');
	if(FALSE !== $object && isset($CI->$object) && is_object($CI->$object))
		return $CI->$object;
	
	get_instance()->error->warning('Could not find the form validation object - please check to make sure that the form validation library has been loaded');
	return $return;
}