<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package icarus
* @subpackage core
*/

/**
* Extension to Codeigniter's URI class which allows greater ability for dynamic urls.
*
* This is paired with (and dependent on) the extension to the router class.  If you haven't read the docs for {@link MY_Router} yet, go do that now.
*
* This extension of the URI class understands (a) whether or not we've used a (:get) wildcard to allow unspecified name/value pairs to be appended to the url
* and (b) what those name/value pairs are, and what the url would look like without them.
*
* @author M. Gibbs <gibbs_margaret@bah.com>
* @package icarus
* @subpackage core
*/
class VLER_URI extends CI_URI {
	var $url_params_start; //starting segment for the (:get) parameters for this URI, if we have any
	
	function _fetch_uri_string(){
		parent::_fetch_uri_string();
		
		if(!empty($this->uri_string) && strpos($this->uri_string, '/') !== 0)
			$this->uri_string = '/'.$this->uri_string;
			
		return $this->uri_string;
	}
	
	/**
	* @todo Figure out why CI's uri_to_assoc caching is causing empty strings to be append to the url assoc array
	* @todo still applicable for CI 2.0?
	*/
/*	function _uri_to_assoc($n = 3, $default = array(), $which = 'segment'){
		$result = parent::_uri_to_assoc($n, $default, $which);
		//Codeigniter caches the result of uri_to_assoc, which for some reason is messing up the result sometimes (appending random numbers at the end)
		//Ultimately, uncaching things is NOT a good solution, but it will work as a placeholder now
		//INVESTIGATE!
		unset($this->keyval[$n]);
		return $result;
	} */ //trying to see if CI 3.0 has fixed this - MG 2016-06-22
	
	
	/**
	* Like Codeigniter's uri_to_assoc, but specific returns the name/value pairs that are in the (:get) portion of the route.
	* If (:get) has not been used for this route, returns any default values for the name/value pairs
	* @param array $default Array of default values to be used if no params have 
	*/
	function url_params_to_assoc($default = array()){		
		if(isset($this->url_params_start) && !empty($this->url_params_start)){
			if(!empty($default))
				return $this->uri_to_assoc($this->url_params_start, $default);
			else
				return $this->uri_to_assoc($this->url_params_start);
		}
		return $default;
	}
	
	/** 
	* Like {@link http://codeigniter.com/user_guide/helpers/url_helper.html uri_string}, but only returns the portion of the string that belongs to the (:get) wildcard.
	*
	*/
	function url_params_string(){		
		$CI =& get_instance();
		$CI->load->helper('array');	 //need this for the key_value_implode later on
		$url_params = $this->url_params_to_assoc();
		
		if(!empty($url_params))	
			return '/'.key_value_implode($url_params, '/', '/');
		
		return '';
	}
	
	/**
	* Returns what the {@link http://codeigniter.com/user_guide/helpers/url_helper.html uri_string} would be if nothing was set for the (:get) portion of the route.
	* @todo Think of a better name before we use this too many places -- this name is at odds with Codeigniter's idea of a base url.  Thesaurus time!
	*/
	function base_uri_string(){	
		$url_params_string = $this->url_params_string();
				
		if(empty($url_params_string))
			return $this->uri_string();	
		
		$url_params_start = strrpos($this->uri_string(), $url_params_string);
		if($url_params_start === false || !is_numeric($url_params_start) || $url_params_start < 0){
			$message = 'The URI class is confused and thinks that the url params are starting in an impossible place ('.$url_params_start.' instead of a nonzero int).  ';
			$message .= 'You should probably look into this.';
			trigger_error($message, E_USER_NOTICE);
			return $this->uri_string();
		}
		
		return substr($this->uri_string(), 0, $url_params_start);
	}

}
// END URI Class

/* End of file URI.php */
/* Location: ./system/libraries/URI.php */